/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.cache;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Streams;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.airlift.jmx.CacheStatsMBean;
import io.airlift.units.Duration;
import io.trino.collect.cache.EvictableCacheBuilder;
import io.trino.plugin.hive.HivePartition;
import io.trino.plugin.hive.HivePartitionManager;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.PartitionNotFoundException;
import io.trino.plugin.hive.PartitionStatistics;
import io.trino.plugin.hive.acid.AcidOperation;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.HivePartitionName;
import io.trino.plugin.hive.metastore.HivePrincipal;
import io.trino.plugin.hive.metastore.HivePrivilegeInfo;
import io.trino.plugin.hive.metastore.HiveTableName;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.PartitionFilter;
import io.trino.plugin.hive.metastore.PartitionWithStatistics;
import io.trino.plugin.hive.metastore.PrincipalPrivileges;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.metastore.TablesWithParameterCacheKey;
import io.trino.plugin.hive.metastore.UserTableKey;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.statistics.ColumnStatisticType;
import io.trino.spi.type.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

@ThreadSafe
public class CachingHiveMetastore
implements HiveMetastore {
    protected final HiveMetastore delegate;
    private final LoadingCache<String, Optional<Database>> databaseCache;
    private final LoadingCache<String, List<String>> databaseNamesCache;
    private final LoadingCache<HiveTableName, Optional<Table>> tableCache;
    private final LoadingCache<String, List<String>> tableNamesCache;
    private final LoadingCache<TablesWithParameterCacheKey, List<String>> tablesWithParameterCache;
    private final LoadingCache<HiveTableName, PartitionStatistics> tableStatisticsCache;
    private final LoadingCache<HivePartitionName, PartitionStatistics> partitionStatisticsCache;
    private final LoadingCache<String, List<String>> viewNamesCache;
    private final LoadingCache<HivePartitionName, Optional<Partition>> partitionCache;
    private final LoadingCache<PartitionFilter, Optional<List<String>>> partitionFilterCache;
    private final LoadingCache<UserTableKey, Set<HivePrivilegeInfo>> tablePrivilegesCache;
    private final LoadingCache<String, Set<String>> rolesCache;
    private final LoadingCache<HivePrincipal, Set<RoleGrant>> roleGrantsCache;
    private final LoadingCache<String, Set<RoleGrant>> grantedPrincipalsCache;
    private final LoadingCache<String, Optional<String>> configValuesCache;

    public static CachingHiveMetastore cachingHiveMetastore(HiveMetastore delegate, Executor executor, Duration cacheTtl, Optional<Duration> refreshInterval, long maximumSize) {
        return new CachingHiveMetastore(delegate, OptionalLong.of(cacheTtl.toMillis()), refreshInterval.map(Duration::toMillis).map(OptionalLong::of).orElseGet(OptionalLong::empty), Optional.of(executor), maximumSize, StatsRecording.ENABLED);
    }

    public static CachingHiveMetastore memoizeMetastore(HiveMetastore delegate, long maximumSize) {
        return new CachingHiveMetastore(delegate, OptionalLong.empty(), OptionalLong.empty(), Optional.empty(), maximumSize, StatsRecording.DISABLED);
    }

    protected CachingHiveMetastore(HiveMetastore delegate, OptionalLong expiresAfterWriteMillis, OptionalLong refreshMills, Optional<Executor> executor, long maximumSize, StatsRecording statsRecording) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        Objects.requireNonNull(executor, "executor is null");
        this.databaseNamesCache = CachingHiveMetastore.buildCache(expiresAfterWriteMillis, refreshMills, executor, maximumSize, statsRecording, ignored -> this.loadAllDatabases());
        this.databaseCache = CachingHiveMetastore.buildCache(expiresAfterWriteMillis, refreshMills, executor, maximumSize, statsRecording, this::loadDatabase);
        this.tableNamesCache = CachingHiveMetastore.buildCache(expiresAfterWriteMillis, refreshMills, executor, maximumSize, statsRecording, this::loadAllTables);
        this.tablesWithParameterCache = CachingHiveMetastore.buildCache(expiresAfterWriteMillis, refreshMills, executor, maximumSize, statsRecording, this::loadTablesMatchingParameter);
        this.tableStatisticsCache = CachingHiveMetastore.buildCache(expiresAfterWriteMillis, refreshMills, executor, maximumSize, statsRecording, this::loadTableColumnStatistics);
        this.partitionStatisticsCache = CachingHiveMetastore.buildCache(expiresAfterWriteMillis, maximumSize, statsRecording, this::loadPartitionColumnStatistics, this::loadPartitionsColumnStatistics);
        this.tableCache = CachingHiveMetastore.buildCache(expiresAfterWriteMillis, refreshMills, executor, maximumSize, statsRecording, this::loadTable);
        this.viewNamesCache = CachingHiveMetastore.buildCache(expiresAfterWriteMillis, refreshMills, executor, maximumSize, statsRecording, this::loadAllViews);
        this.partitionFilterCache = CachingHiveMetastore.buildCache(expiresAfterWriteMillis, refreshMills, executor, maximumSize, statsRecording, this::loadPartitionNamesByFilter);
        this.partitionCache = CachingHiveMetastore.buildCache(expiresAfterWriteMillis, maximumSize, statsRecording, this::loadPartitionByName, this::loadPartitionsByNames);
        this.tablePrivilegesCache = CachingHiveMetastore.buildCache(expiresAfterWriteMillis, refreshMills, executor, maximumSize, statsRecording, key -> this.loadTablePrivileges(key.getDatabase(), key.getTable(), key.getOwner(), key.getPrincipal()));
        this.rolesCache = CachingHiveMetastore.buildCache(expiresAfterWriteMillis, refreshMills, executor, maximumSize, statsRecording, ignored -> this.loadRoles());
        this.roleGrantsCache = CachingHiveMetastore.buildCache(expiresAfterWriteMillis, refreshMills, executor, maximumSize, statsRecording, this::loadRoleGrants);
        this.grantedPrincipalsCache = CachingHiveMetastore.buildCache(expiresAfterWriteMillis, refreshMills, executor, maximumSize, statsRecording, this::loadPrincipals);
        this.configValuesCache = CachingHiveMetastore.buildCache(expiresAfterWriteMillis, refreshMills, executor, maximumSize, statsRecording, this::loadConfigValue);
    }

    @Managed
    public void flushCache() {
        this.databaseNamesCache.invalidateAll();
        this.tableNamesCache.invalidateAll();
        this.viewNamesCache.invalidateAll();
        this.databaseCache.invalidateAll();
        this.tableCache.invalidateAll();
        this.partitionCache.invalidateAll();
        this.partitionFilterCache.invalidateAll();
        this.tablePrivilegesCache.invalidateAll();
        this.tableStatisticsCache.invalidateAll();
        this.partitionStatisticsCache.invalidateAll();
        this.rolesCache.invalidateAll();
    }

    public void flushPartitionCache(String schemaName, String tableName, List<String> partitionColumns, List<String> partitionValues) {
        Objects.requireNonNull(schemaName, "schemaName is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(partitionColumns, "partitionColumns is null");
        Objects.requireNonNull(partitionValues, "partitionValues is null");
        String providedPartitionName = FileUtils.makePartName(partitionColumns, partitionValues);
        this.invalidatePartitionCache(schemaName, tableName, partitionNameToCheck -> partitionNameToCheck.map(value -> value.equals(providedPartitionName)).orElse(false));
    }

    private static <K, V> V get(LoadingCache<K, V> cache, K key) {
        try {
            return (V)cache.getUnchecked(key);
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), TrinoException.class);
            throw e;
        }
    }

    private static <K, V> Map<K, V> getAll(LoadingCache<K, V> cache, Iterable<K> keys) {
        try {
            return cache.getAll(keys);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), TrinoException.class);
            Throwables.throwIfUnchecked((Throwable)e);
            throw new UncheckedExecutionException(e);
        }
    }

    @Override
    public Optional<Database> getDatabase(String databaseName) {
        return CachingHiveMetastore.get(this.databaseCache, databaseName);
    }

    private Optional<Database> loadDatabase(String databaseName) {
        return this.delegate.getDatabase(databaseName);
    }

    @Override
    public List<String> getAllDatabases() {
        return CachingHiveMetastore.get(this.databaseNamesCache, "");
    }

    private List<String> loadAllDatabases() {
        return this.delegate.getAllDatabases();
    }

    private Table getExistingTable(String databaseName, String tableName) {
        return this.getTable(databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
    }

    @Override
    public Optional<Table> getTable(String databaseName, String tableName) {
        return CachingHiveMetastore.get(this.tableCache, HiveTableName.hiveTableName(databaseName, tableName));
    }

    @Override
    public Set<ColumnStatisticType> getSupportedColumnStatistics(Type type) {
        return this.delegate.getSupportedColumnStatistics(type);
    }

    private Optional<Table> loadTable(HiveTableName hiveTableName) {
        return this.delegate.getTable(hiveTableName.getDatabaseName(), hiveTableName.getTableName());
    }

    @Override
    public PartitionStatistics getTableStatistics(Table table) {
        return CachingHiveMetastore.get(this.tableStatisticsCache, HiveTableName.hiveTableName(table.getDatabaseName(), table.getTableName()));
    }

    private PartitionStatistics loadTableColumnStatistics(HiveTableName tableName) {
        Table table = this.getExistingTable(tableName.getDatabaseName(), tableName.getTableName());
        return this.delegate.getTableStatistics(table);
    }

    @Override
    public Map<String, PartitionStatistics> getPartitionStatistics(Table table, List<Partition> partitions) {
        HiveTableName hiveTableName = HiveTableName.hiveTableName(table.getDatabaseName(), table.getTableName());
        List partitionNames = (List)partitions.stream().map(partition -> HivePartitionName.hivePartitionName(hiveTableName, MetastoreUtil.makePartitionName(table, partition))).collect(ImmutableList.toImmutableList());
        Map<HivePartitionName, PartitionStatistics> statistics = CachingHiveMetastore.getAll(this.partitionStatisticsCache, partitionNames);
        return (Map)statistics.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((HivePartitionName)entry.getKey()).getPartitionName().orElseThrow(), Map.Entry::getValue));
    }

    private PartitionStatistics loadPartitionColumnStatistics(HivePartitionName partition) {
        HiveTableName tableName = partition.getHiveTableName();
        String partitionName = partition.getPartitionName().orElseThrow();
        Table table = this.getExistingTable(tableName.getDatabaseName(), tableName.getTableName());
        Map<String, PartitionStatistics> partitionStatistics = this.delegate.getPartitionStatistics(table, (List<Partition>)ImmutableList.of((Object)this.getExistingPartition(table, partition.getPartitionValues())));
        return partitionStatistics.get(partitionName);
    }

    private Map<HivePartitionName, PartitionStatistics> loadPartitionsColumnStatistics(Iterable<? extends HivePartitionName> keys) {
        SetMultimap tablePartitions = (SetMultimap)Streams.stream(keys).collect(ImmutableSetMultimap.toImmutableSetMultimap(HivePartitionName::getHiveTableName, java.util.function.Function.identity()));
        ImmutableMap.Builder result = ImmutableMap.builder();
        tablePartitions.keySet().forEach(tableName -> {
            Set partitionNames = tablePartitions.get(tableName);
            Set partitionNameStrings = (Set)partitionNames.stream().map(partitionName -> partitionName.getPartitionName().orElseThrow()).collect(ImmutableSet.toImmutableSet());
            Table table = this.getExistingTable(tableName.getDatabaseName(), tableName.getTableName());
            List<Partition> partitions = this.getExistingPartitionsByNames(table, (List<String>)ImmutableList.copyOf((Collection)partitionNameStrings));
            Map<String, PartitionStatistics> statisticsByPartitionName = this.delegate.getPartitionStatistics(table, partitions);
            for (HivePartitionName partitionName2 : partitionNames) {
                String stringNameForPartition = partitionName2.getPartitionName().orElseThrow();
                result.put((Object)partitionName2, (Object)statisticsByPartitionName.get(stringNameForPartition));
            }
        });
        return result.buildOrThrow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTableStatistics(String databaseName, String tableName, AcidTransaction transaction, java.util.function.Function<PartitionStatistics, PartitionStatistics> update) {
        try {
            this.delegate.updateTableStatistics(databaseName, tableName, transaction, update);
        }
        finally {
            HiveTableName hiveTableName = HiveTableName.hiveTableName(databaseName, tableName);
            this.tableStatisticsCache.invalidate((Object)hiveTableName);
            this.tableCache.invalidate((Object)hiveTableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePartitionStatistics(Table table, String partitionName, java.util.function.Function<PartitionStatistics, PartitionStatistics> update) {
        try {
            this.delegate.updatePartitionStatistics(table, partitionName, update);
        }
        finally {
            HivePartitionName hivePartitionName = HivePartitionName.hivePartitionName(HiveTableName.hiveTableName(table.getDatabaseName(), table.getTableName()), partitionName);
            this.partitionStatisticsCache.invalidate((Object)hivePartitionName);
            this.partitionCache.invalidate((Object)hivePartitionName);
        }
    }

    @Override
    public void updatePartitionStatistics(Table table, Map<String, java.util.function.Function<PartitionStatistics, PartitionStatistics>> updates) {
        try {
            this.delegate.updatePartitionStatistics(table, updates);
        }
        finally {
            updates.forEach((partitionName, update) -> {
                HivePartitionName hivePartitionName = HivePartitionName.hivePartitionName(HiveTableName.hiveTableName(table.getDatabaseName(), table.getTableName()), partitionName);
                this.partitionStatisticsCache.invalidate((Object)hivePartitionName);
                this.partitionCache.invalidate((Object)hivePartitionName);
            });
        }
    }

    @Override
    public List<String> getAllTables(String databaseName) {
        return CachingHiveMetastore.get(this.tableNamesCache, databaseName);
    }

    private List<String> loadAllTables(String databaseName) {
        return this.delegate.getAllTables(databaseName);
    }

    @Override
    public List<String> getTablesWithParameter(String databaseName, String parameterKey, String parameterValue) {
        TablesWithParameterCacheKey key = new TablesWithParameterCacheKey(databaseName, parameterKey, parameterValue);
        return CachingHiveMetastore.get(this.tablesWithParameterCache, key);
    }

    private List<String> loadTablesMatchingParameter(TablesWithParameterCacheKey key) {
        return this.delegate.getTablesWithParameter(key.getDatabaseName(), key.getParameterKey(), key.getParameterValue());
    }

    @Override
    public List<String> getAllViews(String databaseName) {
        return CachingHiveMetastore.get(this.viewNamesCache, databaseName);
    }

    private List<String> loadAllViews(String databaseName) {
        return this.delegate.getAllViews(databaseName);
    }

    @Override
    public void createDatabase(Database database) {
        try {
            this.delegate.createDatabase(database);
        }
        finally {
            this.invalidateDatabase(database.getDatabaseName());
        }
    }

    @Override
    public void dropDatabase(String databaseName, boolean deleteData) {
        try {
            this.delegate.dropDatabase(databaseName, deleteData);
        }
        finally {
            this.invalidateDatabase(databaseName);
        }
    }

    @Override
    public void renameDatabase(String databaseName, String newDatabaseName) {
        try {
            this.delegate.renameDatabase(databaseName, newDatabaseName);
        }
        finally {
            this.invalidateDatabase(databaseName);
            this.invalidateDatabase(newDatabaseName);
        }
    }

    @Override
    public void setDatabaseOwner(String databaseName, HivePrincipal principal) {
        try {
            this.delegate.setDatabaseOwner(databaseName, principal);
        }
        finally {
            this.invalidateDatabase(databaseName);
        }
    }

    protected void invalidateDatabase(String databaseName) {
        this.databaseCache.invalidate((Object)databaseName);
        this.databaseNamesCache.invalidateAll();
    }

    @Override
    public void createTable(Table table, PrincipalPrivileges principalPrivileges) {
        try {
            this.delegate.createTable(table, principalPrivileges);
        }
        finally {
            this.invalidateTable(table.getDatabaseName(), table.getTableName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropTable(String databaseName, String tableName, boolean deleteData) {
        try {
            this.delegate.dropTable(databaseName, tableName, deleteData);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceTable(String databaseName, String tableName, Table newTable, PrincipalPrivileges principalPrivileges) {
        try {
            this.delegate.replaceTable(databaseName, tableName, newTable, principalPrivileges);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
            this.invalidateTable(newTable.getDatabaseName(), newTable.getTableName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameTable(String databaseName, String tableName, String newDatabaseName, String newTableName) {
        try {
            this.delegate.renameTable(databaseName, tableName, newDatabaseName, newTableName);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
            this.invalidateTable(newDatabaseName, newTableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commentTable(String databaseName, String tableName, Optional<String> comment) {
        try {
            this.delegate.commentTable(databaseName, tableName, comment);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTableOwner(String databaseName, String tableName, HivePrincipal principal) {
        try {
            this.delegate.setTableOwner(databaseName, tableName, principal);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commentColumn(String databaseName, String tableName, String columnName, Optional<String> comment) {
        try {
            this.delegate.commentColumn(databaseName, tableName, columnName, comment);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addColumn(String databaseName, String tableName, String columnName, HiveType columnType, String columnComment) {
        try {
            this.delegate.addColumn(databaseName, tableName, columnName, columnType, columnComment);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameColumn(String databaseName, String tableName, String oldColumnName, String newColumnName) {
        try {
            this.delegate.renameColumn(databaseName, tableName, oldColumnName, newColumnName);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropColumn(String databaseName, String tableName, String columnName) {
        try {
            this.delegate.dropColumn(databaseName, tableName, columnName);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
        }
    }

    public void invalidateTable(String databaseName, String tableName) {
        this.invalidateTableCache(databaseName, tableName);
        this.tableNamesCache.invalidate((Object)databaseName);
        this.viewNamesCache.invalidate((Object)databaseName);
        this.tablePrivilegesCache.asMap().keySet().stream().filter(userTableKey -> userTableKey.matches(databaseName, tableName)).forEach(arg_0 -> this.tablePrivilegesCache.invalidate(arg_0));
        this.invalidateTableStatisticsCache(databaseName, tableName);
        this.invalidatePartitionCache(databaseName, tableName);
    }

    private void invalidateTableCache(String databaseName, String tableName) {
        this.tableCache.asMap().keySet().stream().filter(table -> table.getDatabaseName().equals(databaseName) && table.getTableName().equals(tableName)).forEach(arg_0 -> this.tableCache.invalidate(arg_0));
    }

    private void invalidateTableStatisticsCache(String databaseName, String tableName) {
        this.tableStatisticsCache.asMap().keySet().stream().filter(table -> table.getDatabaseName().equals(databaseName) && table.getTableName().equals(tableName)).forEach(arg_0 -> this.tableCache.invalidate(arg_0));
    }

    private Partition getExistingPartition(Table table, List<String> partitionValues) {
        return this.getPartition(table, partitionValues).orElseThrow(() -> new PartitionNotFoundException(table.getSchemaTableName(), partitionValues));
    }

    private List<Partition> getExistingPartitionsByNames(Table table, List<String> partitionNames) {
        Map partitions = (Map)this.getPartitionsByNames(table, partitionNames).entrySet().stream().map(entry -> Maps.immutableEntry((Object)((String)entry.getKey()), (Object)((Partition)((Optional)entry.getValue()).orElseThrow(() -> new PartitionNotFoundException(table.getSchemaTableName(), HivePartitionManager.extractPartitionValues((String)entry.getKey())))))).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        return (List)partitionNames.stream().map(partitions::get).collect(ImmutableList.toImmutableList());
    }

    @Override
    public Optional<Partition> getPartition(Table table, List<String> partitionValues) {
        return CachingHiveMetastore.get(this.partitionCache, HivePartitionName.hivePartitionName(HiveTableName.hiveTableName(table.getDatabaseName(), table.getTableName()), partitionValues));
    }

    @Override
    public Optional<List<String>> getPartitionNamesByFilter(String databaseName, String tableName, List<String> columnNames, TupleDomain<String> partitionKeysFilter) {
        return CachingHiveMetastore.get(this.partitionFilterCache, PartitionFilter.partitionFilter(databaseName, tableName, columnNames, partitionKeysFilter));
    }

    private Optional<List<String>> loadPartitionNamesByFilter(PartitionFilter partitionFilter) {
        return this.delegate.getPartitionNamesByFilter(partitionFilter.getHiveTableName().getDatabaseName(), partitionFilter.getHiveTableName().getTableName(), partitionFilter.getPartitionColumnNames(), partitionFilter.getPartitionKeysFilter());
    }

    @Override
    public Map<String, Optional<Partition>> getPartitionsByNames(Table table, List<String> partitionNames) {
        List names = (List)partitionNames.stream().map(name -> HivePartitionName.hivePartitionName(HiveTableName.hiveTableName(table.getDatabaseName(), table.getTableName()), name)).collect(ImmutableList.toImmutableList());
        Map<HivePartitionName, Optional<Partition>> all = CachingHiveMetastore.getAll(this.partitionCache, names);
        ImmutableMap.Builder partitionsByName = ImmutableMap.builder();
        for (Map.Entry<HivePartitionName, Optional<Partition>> entry : all.entrySet()) {
            partitionsByName.put((Object)entry.getKey().getPartitionName().orElseThrow(), entry.getValue());
        }
        return partitionsByName.buildOrThrow();
    }

    private Optional<Partition> loadPartitionByName(HivePartitionName partitionName) {
        HiveTableName hiveTableName = partitionName.getHiveTableName();
        return this.getTable(hiveTableName.getDatabaseName(), hiveTableName.getTableName()).flatMap(table -> this.delegate.getPartition((Table)table, partitionName.getPartitionValues()));
    }

    private Map<HivePartitionName, Optional<Partition>> loadPartitionsByNames(Iterable<? extends HivePartitionName> partitionNames) {
        Objects.requireNonNull(partitionNames, "partitionNames is null");
        Preconditions.checkArgument((!Iterables.isEmpty(partitionNames) ? 1 : 0) != 0, (Object)"partitionNames is empty");
        HivePartitionName firstPartition = (HivePartitionName)Iterables.get(partitionNames, (int)0);
        HiveTableName hiveTableName = firstPartition.getHiveTableName();
        Optional<Table> table = this.getTable(hiveTableName.getDatabaseName(), hiveTableName.getTableName());
        if (table.isEmpty()) {
            return (Map)Streams.stream(partitionNames).collect(ImmutableMap.toImmutableMap(name -> name, name -> Optional.empty()));
        }
        ArrayList<String> partitionsToFetch = new ArrayList<String>();
        for (HivePartitionName hivePartitionName : partitionNames) {
            Preconditions.checkArgument((boolean)hivePartitionName.getHiveTableName().equals(hiveTableName), (String)"Expected table name %s but got %s", (Object)hiveTableName, (Object)hivePartitionName.getHiveTableName());
            partitionsToFetch.add(hivePartitionName.getPartitionName().orElseThrow());
        }
        ImmutableMap.Builder partitions = ImmutableMap.builder();
        Map<String, Optional<Partition>> map = this.delegate.getPartitionsByNames(table.get(), partitionsToFetch);
        for (HivePartitionName hivePartitionName : partitionNames) {
            partitions.put((Object)hivePartitionName, map.getOrDefault(hivePartitionName.getPartitionName().orElseThrow(), Optional.empty()));
        }
        return partitions.buildOrThrow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPartitions(String databaseName, String tableName, List<PartitionWithStatistics> partitions) {
        try {
            this.delegate.addPartitions(databaseName, tableName, partitions);
        }
        finally {
            this.invalidatePartitionCache(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropPartition(String databaseName, String tableName, List<String> parts, boolean deleteData) {
        try {
            this.delegate.dropPartition(databaseName, tableName, parts, deleteData);
        }
        finally {
            this.invalidatePartitionCache(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alterPartition(String databaseName, String tableName, PartitionWithStatistics partition) {
        try {
            this.delegate.alterPartition(databaseName, tableName, partition);
        }
        finally {
            this.invalidatePartitionCache(databaseName, tableName);
        }
    }

    @Override
    public void createRole(String role, String grantor) {
        try {
            this.delegate.createRole(role, grantor);
        }
        finally {
            this.rolesCache.invalidateAll();
        }
    }

    @Override
    public void dropRole(String role) {
        try {
            this.delegate.dropRole(role);
        }
        finally {
            this.rolesCache.invalidateAll();
            this.roleGrantsCache.invalidateAll();
        }
    }

    @Override
    public Set<String> listRoles() {
        return CachingHiveMetastore.get(this.rolesCache, "");
    }

    private Set<String> loadRoles() {
        return this.delegate.listRoles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        try {
            this.delegate.grantRoles(roles, grantees, adminOption, grantor);
        }
        finally {
            this.roleGrantsCache.invalidateAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        try {
            this.delegate.revokeRoles(roles, grantees, adminOption, grantor);
        }
        finally {
            this.roleGrantsCache.invalidateAll();
        }
    }

    @Override
    public Set<RoleGrant> listGrantedPrincipals(String role) {
        return CachingHiveMetastore.get(this.grantedPrincipalsCache, role);
    }

    @Override
    public Set<RoleGrant> listRoleGrants(HivePrincipal principal) {
        return CachingHiveMetastore.get(this.roleGrantsCache, principal);
    }

    private Set<RoleGrant> loadRoleGrants(HivePrincipal principal) {
        return this.delegate.listRoleGrants(principal);
    }

    private Set<RoleGrant> loadPrincipals(String role) {
        return this.delegate.listGrantedPrincipals(role);
    }

    private void invalidatePartitionCache(String databaseName, String tableName) {
        this.invalidatePartitionCache(databaseName, tableName, partitionName -> true);
    }

    private void invalidatePartitionCache(String databaseName, String tableName, Predicate<Optional<String>> partitionPredicate) {
        HiveTableName hiveTableName = HiveTableName.hiveTableName(databaseName, tableName);
        Predicate<HivePartitionName> hivePartitionPredicate = partitionName -> partitionName.getHiveTableName().equals(hiveTableName) && partitionPredicate.test(partitionName.getPartitionName());
        this.partitionCache.asMap().keySet().stream().filter(hivePartitionPredicate).forEach(arg_0 -> this.partitionCache.invalidate(arg_0));
        this.partitionFilterCache.asMap().keySet().stream().filter(partitionFilter -> partitionFilter.getHiveTableName().equals(hiveTableName)).forEach(arg_0 -> this.partitionFilterCache.invalidate(arg_0));
        this.partitionStatisticsCache.asMap().keySet().stream().filter(hivePartitionPredicate).forEach(arg_0 -> this.partitionStatisticsCache.invalidate(arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, HivePrincipal grantor, Set<HivePrivilegeInfo.HivePrivilege> privileges, boolean grantOption) {
        try {
            this.delegate.grantTablePrivileges(databaseName, tableName, tableOwner, grantee, grantor, privileges, grantOption);
        }
        finally {
            this.invalidateTablePrivilegeCacheEntries(databaseName, tableName, tableOwner, grantee);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, HivePrincipal grantor, Set<HivePrivilegeInfo.HivePrivilege> privileges, boolean grantOption) {
        try {
            this.delegate.revokeTablePrivileges(databaseName, tableName, tableOwner, grantee, grantor, privileges, grantOption);
        }
        finally {
            this.invalidateTablePrivilegeCacheEntries(databaseName, tableName, tableOwner, grantee);
        }
    }

    private void invalidateTablePrivilegeCacheEntries(String databaseName, String tableName, String tableOwner, HivePrincipal grantee) {
        this.tablePrivilegesCache.invalidate((Object)new UserTableKey(Optional.of(grantee), databaseName, tableName, Optional.of(tableOwner)));
        this.tablePrivilegesCache.invalidate((Object)new UserTableKey(Optional.empty(), databaseName, tableName, Optional.of(tableOwner)));
    }

    @Override
    public Set<HivePrivilegeInfo> listTablePrivileges(String databaseName, String tableName, Optional<String> tableOwner, Optional<HivePrincipal> principal) {
        return CachingHiveMetastore.get(this.tablePrivilegesCache, new UserTableKey(principal, databaseName, tableName, tableOwner));
    }

    @Override
    public Optional<String> getConfigValue(String name) {
        return CachingHiveMetastore.get(this.configValuesCache, name);
    }

    private Optional<String> loadConfigValue(String name) {
        return this.delegate.getConfigValue(name);
    }

    @Override
    public long openTransaction() {
        return this.delegate.openTransaction();
    }

    @Override
    public void commitTransaction(long transactionId) {
        this.delegate.commitTransaction(transactionId);
    }

    @Override
    public void abortTransaction(long transactionId) {
        this.delegate.abortTransaction(transactionId);
    }

    @Override
    public void sendTransactionHeartbeat(long transactionId) {
        this.delegate.sendTransactionHeartbeat(transactionId);
    }

    @Override
    public void acquireSharedReadLock(String queryId, long transactionId, List<SchemaTableName> fullTables, List<HivePartition> partitions) {
        this.delegate.acquireSharedReadLock(queryId, transactionId, fullTables, partitions);
    }

    @Override
    public String getValidWriteIds(List<SchemaTableName> tables, long currentTransactionId) {
        return this.delegate.getValidWriteIds(tables, currentTransactionId);
    }

    private Set<HivePrivilegeInfo> loadTablePrivileges(String databaseName, String tableName, Optional<String> tableOwner, Optional<HivePrincipal> principal) {
        return this.delegate.listTablePrivileges(databaseName, tableName, tableOwner, principal);
    }

    @Override
    public long allocateWriteId(String dbName, String tableName, long transactionId) {
        return this.delegate.allocateWriteId(dbName, tableName, transactionId);
    }

    @Override
    public void acquireTableWriteLock(String queryId, long transactionId, String dbName, String tableName, DataOperationType operation, boolean isDynamicPartitionWrite) {
        this.delegate.acquireTableWriteLock(queryId, transactionId, dbName, tableName, operation, isDynamicPartitionWrite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTableWriteId(String dbName, String tableName, long transactionId, long writeId, OptionalLong rowCountChange) {
        try {
            this.delegate.updateTableWriteId(dbName, tableName, transactionId, writeId, rowCountChange);
        }
        finally {
            this.invalidateTable(dbName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alterPartitions(String dbName, String tableName, List<Partition> partitions, long writeId) {
        try {
            this.delegate.alterPartitions(dbName, tableName, partitions, writeId);
        }
        finally {
            this.invalidatePartitionCache(dbName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDynamicPartitions(String dbName, String tableName, List<String> partitionNames, long transactionId, long writeId, AcidOperation operation) {
        try {
            this.delegate.addDynamicPartitions(dbName, tableName, partitionNames, transactionId, writeId, operation);
        }
        finally {
            this.invalidatePartitionCache(dbName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alterTransactionalTable(Table table, long transactionId, long writeId, PrincipalPrivileges principalPrivileges) {
        try {
            this.delegate.alterTransactionalTable(table, transactionId, writeId, principalPrivileges);
        }
        finally {
            this.invalidateTable(table.getDatabaseName(), table.getTableName());
        }
    }

    private static <K, V> LoadingCache<K, V> buildCache(OptionalLong expiresAfterWriteMillis, OptionalLong refreshMillis, Optional<Executor> refreshExecutor, long maximumSize, StatsRecording statsRecording, Function<K, V> loader) {
        CacheLoader cacheLoader = CacheLoader.from(loader);
        EvictableCacheBuilder cacheBuilder = EvictableCacheBuilder.newBuilder();
        if (expiresAfterWriteMillis.isPresent()) {
            cacheBuilder.expireAfterWrite(expiresAfterWriteMillis.getAsLong(), TimeUnit.MILLISECONDS);
        }
        Preconditions.checkArgument((refreshMillis.isEmpty() || refreshExecutor.isPresent() ? 1 : 0) != 0, (Object)"refreshMillis is provided but refreshExecutor is not");
        if (refreshMillis.isPresent() && (expiresAfterWriteMillis.isEmpty() || expiresAfterWriteMillis.getAsLong() > refreshMillis.getAsLong())) {
            cacheBuilder.refreshAfterWrite(refreshMillis.getAsLong(), TimeUnit.MILLISECONDS);
            cacheLoader = CacheLoader.asyncReloading((CacheLoader)cacheLoader, (Executor)refreshExecutor.orElseThrow(() -> new IllegalArgumentException("Executor not provided")));
        }
        cacheBuilder.maximumSize(maximumSize);
        if (statsRecording == StatsRecording.ENABLED) {
            cacheBuilder.recordStats();
        }
        return cacheBuilder.build(cacheLoader);
    }

    private static <K, V> LoadingCache<K, V> buildCache(OptionalLong expiresAfterWriteMillis, long maximumSize, StatsRecording statsRecording, final java.util.function.Function<K, V> loader, final java.util.function.Function<Iterable<K>, Map<K, V>> bulkLoader) {
        Objects.requireNonNull(loader, "loader is null");
        Objects.requireNonNull(bulkLoader, "bulkLoader is null");
        CacheLoader cacheLoader = new CacheLoader<K, V>(){

            public V load(K key) {
                return loader.apply(key);
            }

            public Map<K, V> loadAll(Iterable<? extends K> keys) {
                return (Map)bulkLoader.apply(Iterables.transform(keys, (Function)Functions.identity()));
            }
        };
        EvictableCacheBuilder cacheBuilder = EvictableCacheBuilder.newBuilder();
        if (expiresAfterWriteMillis.isPresent()) {
            cacheBuilder.expireAfterWrite(expiresAfterWriteMillis.getAsLong(), TimeUnit.MILLISECONDS);
        }
        cacheBuilder.maximumSize(maximumSize);
        if (statsRecording == StatsRecording.ENABLED) {
            cacheBuilder.recordStats();
        }
        return cacheBuilder.build(cacheLoader);
    }

    @Managed
    @Nested
    public CacheStatsMBean getDatabaseStats() {
        return new CacheStatsMBean(this.databaseCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getDatabaseNamesStats() {
        return new CacheStatsMBean(this.databaseNamesCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getTableStats() {
        return new CacheStatsMBean(this.tableCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getTableNamesStats() {
        return new CacheStatsMBean(this.tableNamesCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getTableWithParameterStats() {
        return new CacheStatsMBean(this.tablesWithParameterCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getTableStatisticsStats() {
        return new CacheStatsMBean(this.tableStatisticsCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getPartitionStatisticsStats() {
        return new CacheStatsMBean(this.partitionStatisticsCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getViewNamesStats() {
        return new CacheStatsMBean(this.viewNamesCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getPartitionStats() {
        return new CacheStatsMBean(this.partitionCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getPartitionFilterStats() {
        return new CacheStatsMBean(this.partitionFilterCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getTablePrivilegesStats() {
        return new CacheStatsMBean(this.tablePrivilegesCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getRolesStats() {
        return new CacheStatsMBean(this.rolesCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getRoleGrantsStats() {
        return new CacheStatsMBean(this.roleGrantsCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getGrantedPrincipalsStats() {
        return new CacheStatsMBean(this.grantedPrincipalsCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getConfigValuesStats() {
        return new CacheStatsMBean(this.configValuesCache);
    }

    LoadingCache<String, Optional<Database>> getDatabaseCache() {
        return this.databaseCache;
    }

    LoadingCache<String, List<String>> getDatabaseNamesCache() {
        return this.databaseNamesCache;
    }

    LoadingCache<HiveTableName, Optional<Table>> getTableCache() {
        return this.tableCache;
    }

    LoadingCache<String, List<String>> getTableNamesCache() {
        return this.tableNamesCache;
    }

    LoadingCache<TablesWithParameterCacheKey, List<String>> getTablesWithParameterCache() {
        return this.tablesWithParameterCache;
    }

    LoadingCache<HiveTableName, PartitionStatistics> getTableStatisticsCache() {
        return this.tableStatisticsCache;
    }

    LoadingCache<HivePartitionName, PartitionStatistics> getPartitionStatisticsCache() {
        return this.partitionStatisticsCache;
    }

    LoadingCache<String, List<String>> getViewNamesCache() {
        return this.viewNamesCache;
    }

    LoadingCache<HivePartitionName, Optional<Partition>> getPartitionCache() {
        return this.partitionCache;
    }

    LoadingCache<PartitionFilter, Optional<List<String>>> getPartitionFilterCache() {
        return this.partitionFilterCache;
    }

    LoadingCache<UserTableKey, Set<HivePrivilegeInfo>> getTablePrivilegesCache() {
        return this.tablePrivilegesCache;
    }

    LoadingCache<String, Set<String>> getRolesCache() {
        return this.rolesCache;
    }

    LoadingCache<HivePrincipal, Set<RoleGrant>> getRoleGrantsCache() {
        return this.roleGrantsCache;
    }

    LoadingCache<String, Set<RoleGrant>> getGrantedPrincipalsCache() {
        return this.grantedPrincipalsCache;
    }

    LoadingCache<String, Optional<String>> getConfigValuesCache() {
        return this.configValuesCache;
    }

    public static enum StatsRecording {
        ENABLED,
        DISABLED;

    }
}

