/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.parquet;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import io.trino.parquet.Field;
import io.trino.parquet.ParquetCorruptionException;
import io.trino.parquet.reader.ParquetReader;
import io.trino.plugin.base.util.Closables;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.LazyBlock;
import io.trino.spi.block.LazyBlockLoader;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.type.Type;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;

public class ParquetPageSource
implements ConnectorPageSource {
    private final ParquetReader parquetReader;
    private final List<Type> types;
    private final List<Optional<Field>> fields;
    private final List<Boolean> rowIndexLocations;
    private int batchId;
    private boolean closed;
    private long completedPositions;

    public ParquetPageSource(ParquetReader parquetReader, List<Type> types, List<Optional<Field>> fields) {
        this(parquetReader, types, Collections.nCopies(types.size(), false), fields);
    }

    public ParquetPageSource(ParquetReader parquetReader, List<Type> types, List<Boolean> rowIndexLocations, List<Optional<Field>> fields) {
        this.parquetReader = Objects.requireNonNull(parquetReader, "parquetReader is null");
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.rowIndexLocations = Objects.requireNonNull(rowIndexLocations, "rowIndexLocations is null");
        this.fields = ImmutableList.copyOf((Collection)Objects.requireNonNull(fields, "fields is null"));
        Preconditions.checkArgument((types.size() == rowIndexLocations.size() && types.size() == fields.size() ? 1 : 0) != 0, (Object)"types, rowIndexLocations, and fields must correspond one-to-one-to-one");
        Streams.forEachPair(rowIndexLocations.stream(), fields.stream(), (isIndexColumn, field) -> Preconditions.checkArgument((isIndexColumn == false || !field.isPresent() ? 1 : 0) != 0, (Object)"Field info for row index column must be empty Optional"));
    }

    private boolean isIndexColumn(int column) {
        return this.rowIndexLocations.get(column);
    }

    public long getCompletedBytes() {
        return this.parquetReader.getDataSource().getReadBytes();
    }

    public OptionalLong getCompletedPositions() {
        return OptionalLong.of(this.completedPositions);
    }

    public long getReadTimeNanos() {
        return this.parquetReader.getDataSource().getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.closed;
    }

    public long getMemoryUsage() {
        return this.parquetReader.getMemoryContext().getBytes();
    }

    public Page getNextPage() {
        try {
            ++this.batchId;
            int batchSize = this.parquetReader.nextBatch();
            if (this.closed || batchSize <= 0) {
                this.close();
                return null;
            }
            this.completedPositions += (long)batchSize;
            Block[] blocks = new Block[this.fields.size()];
            for (int column = 0; column < blocks.length; ++column) {
                if (this.isIndexColumn(column)) {
                    blocks[column] = ParquetPageSource.getRowIndexColumn(this.parquetReader.lastBatchStartRow(), batchSize);
                    continue;
                }
                Type type = this.types.get(column);
                blocks[column] = this.fields.get(column).map(field -> new LazyBlock(batchSize, (LazyBlockLoader)new ParquetBlockLoader((Field)field))).orElseGet(() -> RunLengthEncodedBlock.create((Type)type, null, (int)batchSize));
            }
            return new Page(batchSize, blocks);
        }
        catch (TrinoException e) {
            Closables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{this});
            throw e;
        }
        catch (RuntimeException e) {
            Closables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{this});
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, (Throwable)e);
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.parquetReader.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Block getRowIndexColumn(long baseIndex, int size) {
        long[] rowIndices = new long[size];
        for (int position = 0; position < size; ++position) {
            rowIndices[position] = baseIndex + (long)position;
        }
        return new LongArrayBlock(size, Optional.empty(), rowIndices);
    }

    private final class ParquetBlockLoader
    implements LazyBlockLoader {
        private final int expectedBatchId;
        private final Field field;
        private boolean loaded;

        public ParquetBlockLoader(Field field) {
            this.expectedBatchId = ParquetPageSource.this.batchId;
            this.field = Objects.requireNonNull(field, "field is null");
        }

        public final Block load() {
            Block block;
            Preconditions.checkState((!this.loaded ? 1 : 0) != 0, (Object)"Already loaded");
            Preconditions.checkState((ParquetPageSource.this.batchId == this.expectedBatchId ? 1 : 0) != 0, (Object)"Inconsistent state; wrong batch");
            String parquetDataSourceId = ParquetPageSource.this.parquetReader.getDataSource().getId().toString();
            try {
                block = ParquetPageSource.this.parquetReader.readBlock(this.field);
            }
            catch (ParquetCorruptionException e) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, String.format("Corrupted parquet data; source=%s; %s", parquetDataSourceId, e.getMessage()), (Throwable)e);
            }
            catch (IOException e) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, String.format("Failed reading parquet data; source= %s; %s", parquetDataSourceId, e.getMessage()), (Throwable)e);
            }
            this.loaded = true;
            return block;
        }
    }
}

