/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.rubix;

import com.google.common.collect.ImmutableList;
import com.qubole.rubix.spi.ClusterManager;
import com.qubole.rubix.spi.ClusterType;
import io.trino.spi.HostAddress;
import io.trino.spi.Node;
import io.trino.spi.NodeManager;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TrinoClusterManager
extends ClusterManager {
    private static volatile Optional<NodeManager> nodeManager = Optional.empty();

    public static void setNodeManager(NodeManager value) {
        nodeManager = Optional.of(Objects.requireNonNull(value, "value is null"));
    }

    public ClusterType getClusterType() {
        return ClusterType.PRESTOSQL_CLUSTER_MANAGER;
    }

    public List<String> getNodesInternal() {
        return (List)nodeManager.orElseThrow(() -> new IllegalStateException("NodeManager not set")).getWorkerNodes().stream().filter(node -> !node.isCoordinator()).map(Node::getHost).collect(ImmutableList.toImmutableList());
    }

    protected String getCurrentNodeHostname() {
        return nodeManager.map(NodeManager::getCurrentNode).map(Node::getHost).orElseGet(() -> super.getCurrentNodeHostname());
    }

    protected String getCurrentNodeHostAddress() {
        return nodeManager.map(NodeManager::getCurrentNode).map(Node::getHostAndPort).flatMap(TrinoClusterManager::toInetAddress).map(InetAddress::getHostAddress).orElseGet(() -> super.getCurrentNodeHostAddress());
    }

    private static Optional<InetAddress> toInetAddress(HostAddress address) {
        try {
            return Optional.ofNullable(address.toInetAddress());
        }
        catch (UnknownHostException ignored) {
            return Optional.empty();
        }
    }
}

