/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.iceberg.BaseAllMetadataTableScan;
import org.apache.iceberg.BaseMetadataTable;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.ManifestEntriesTable;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Partitioning;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.ResidualEvaluator;
import org.apache.iceberg.expressions.True;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.ParallelIterable;
import org.apache.iceberg.util.ThreadPools;

public class AllEntriesTable
extends BaseMetadataTable {
    AllEntriesTable(TableOperations ops, Table table) {
        this(ops, table, table.name() + ".all_entries");
    }

    AllEntriesTable(TableOperations ops, Table table, String name) {
        super(ops, table, name);
    }

    public TableScan newScan() {
        return new Scan(this.operations(), this.table(), this.schema());
    }

    public Schema schema() {
        Types.StructType partitionType = Partitioning.partitionType(this.table());
        Schema schema = ManifestEntry.getSchema(partitionType);
        if (partitionType.fields().size() < 1) {
            return TypeUtil.selectNot((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{102}));
        }
        return schema;
    }

    @Override
    MetadataTableType metadataTableType() {
        return MetadataTableType.ALL_ENTRIES;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static CloseableIterable<ManifestFile> allManifestFiles(List<Snapshot> snapshots) {
        try (ParallelIterable iterable = new ParallelIterable(Iterables.transform(snapshots, snapshot -> () -> snapshot.allManifests().iterator()), ThreadPools.getWorkerPool());){
            CloseableIterable closeableIterable = CloseableIterable.withNoopClose((Iterable)Sets.newHashSet(iterable));
            return closeableIterable;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to close parallel iterable", new Object[0]);
        }
    }

    private static class Scan
    extends BaseAllMetadataTableScan {
        Scan(TableOperations ops, Table table, Schema schema) {
            super(ops, table, schema);
        }

        private Scan(TableOperations ops, Table table, Schema schema, TableScanContext context) {
            super(ops, table, schema, context);
        }

        @Override
        protected TableScan newRefinedScan(TableOperations ops, Table table, Schema schema, TableScanContext context) {
            return new Scan(ops, table, schema, context);
        }

        @Override
        protected String tableType() {
            return MetadataTableType.ALL_ENTRIES.name();
        }

        @Override
        protected CloseableIterable<FileScanTask> planFiles(TableOperations ops, Snapshot snapshot, Expression rowFilter, boolean ignoreResiduals, boolean caseSensitive, boolean colStats) {
            CloseableIterable manifests = AllEntriesTable.allManifestFiles(ops.current().snapshots());
            String schemaString = SchemaParser.toJson(this.schema());
            String specString = PartitionSpecParser.toJson(PartitionSpec.unpartitioned());
            True filter = ignoreResiduals ? Expressions.alwaysTrue() : rowFilter;
            ResidualEvaluator residuals = ResidualEvaluator.unpartitioned((Expression)filter);
            return CloseableIterable.transform((CloseableIterable)manifests, manifest -> new ManifestEntriesTable.ManifestReadTask(ops.io(), (ManifestFile)manifest, this.schema(), schemaString, specString, residuals, ops.current().specsById()));
        }
    }
}

