/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.util.Collection;
import java.util.List;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.encryption.EncryptedOutputFile;
import org.apache.iceberg.io.ClusteredWriter;
import org.apache.iceberg.io.DeleteWriteResult;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.FileWriter;
import org.apache.iceberg.io.FileWriterFactory;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.io.RollingPositionDeleteWriter;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.util.CharSequenceSet;

public class ClusteredPositionDeleteWriter<T>
extends ClusteredWriter<PositionDelete<T>, DeleteWriteResult> {
    private final FileWriterFactory<T> writerFactory;
    private final OutputFileFactory fileFactory;
    private final FileIO io;
    private final FileFormat fileFormat;
    private final long targetFileSizeInBytes;
    private final List<DeleteFile> deleteFiles;
    private final CharSequenceSet referencedDataFiles;

    public ClusteredPositionDeleteWriter(FileWriterFactory<T> writerFactory, OutputFileFactory fileFactory, FileIO io, FileFormat fileFormat, long targetFileSizeInBytes) {
        this.writerFactory = writerFactory;
        this.fileFactory = fileFactory;
        this.io = io;
        this.fileFormat = fileFormat;
        this.targetFileSizeInBytes = targetFileSizeInBytes;
        this.deleteFiles = Lists.newArrayList();
        this.referencedDataFiles = CharSequenceSet.empty();
    }

    @Override
    protected FileWriter<PositionDelete<T>, DeleteWriteResult> newWriter(PartitionSpec spec, StructLike partition) {
        if (this.fileFormat == FileFormat.ORC) {
            EncryptedOutputFile outputFile = this.newOutputFile(this.fileFactory, spec, partition);
            return this.writerFactory.newPositionDeleteWriter(outputFile, spec, partition);
        }
        return new RollingPositionDeleteWriter<T>(this.writerFactory, this.fileFactory, this.io, this.targetFileSizeInBytes, spec, partition);
    }

    @Override
    protected void addResult(DeleteWriteResult result) {
        this.deleteFiles.addAll(result.deleteFiles());
        this.referencedDataFiles.addAll((Collection)result.referencedDataFiles());
    }

    @Override
    protected DeleteWriteResult aggregatedResult() {
        return new DeleteWriteResult(this.deleteFiles, this.referencedDataFiles);
    }
}

