/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kudu;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.kudu.KuduPartitionHandle;
import io.trino.plugin.kudu.KuduSplit;
import io.trino.spi.connector.ConnectorPartitionHandle;
import io.trino.spi.connector.ConnectorSplitSource;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class KuduBucketedSplitSource
implements ConnectorSplitSource {
    private final Map<Integer, List<KuduSplit>> groupedSplits;

    KuduBucketedSplitSource(List<KuduSplit> splits) {
        Map<Integer, List<KuduSplit>> map = splits.stream().collect(Collectors.groupingBy(KuduSplit::getBucketNumber));
        this.groupedSplits = new ConcurrentHashMap<Integer, List<KuduSplit>>(map);
    }

    public CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> getNextBatch(ConnectorPartitionHandle partitionHandle, int maxSize) {
        KuduPartitionHandle kuduPartitionHandle = (KuduPartitionHandle)partitionHandle;
        List<KuduSplit> kuduSplits = this.groupedSplits.remove(kuduPartitionHandle.getBucket());
        return CompletableFuture.completedFuture(new ConnectorSplitSource.ConnectorSplitBatch((List)(kuduSplits == null ? ImmutableList.of() : ImmutableList.copyOf(kuduSplits)), true));
    }

    public void close() {
    }

    public boolean isFinished() {
        return this.groupedSplits.isEmpty();
    }
}

