/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kudu;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.kudu.KuduClientSession;
import io.trino.plugin.kudu.KuduTableMapping;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.kudu.client.KuduTable;

public class KuduInsertTableHandle
implements ConnectorInsertTableHandle,
KuduTableMapping {
    private final SchemaTableName schemaTableName;
    private final List<Type> columnTypes;
    private transient KuduTable table;

    @JsonCreator
    public KuduInsertTableHandle(@JsonProperty(value="schemaTableName") SchemaTableName schemaTableName, @JsonProperty(value="columnTypes") List<Type> columnTypes) {
        this(schemaTableName, columnTypes, null);
    }

    public KuduInsertTableHandle(SchemaTableName schemaTableName, List<Type> columnTypes, KuduTable table) {
        this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        this.columnTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnTypes, "columnTypes is null"));
        this.table = table;
    }

    @JsonProperty
    public SchemaTableName getSchemaTableName() {
        return this.schemaTableName;
    }

    @Override
    @JsonProperty
    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    @Override
    public List<Type> getOriginalColumnTypes() {
        return this.columnTypes;
    }

    @Override
    public boolean isGenerateUUID() {
        return false;
    }

    public KuduTable getTable(KuduClientSession session) {
        if (this.table == null) {
            this.table = session.openTable(this.schemaTableName);
        }
        return this.table;
    }
}

