/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kudu;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.validation.FileExists;
import java.io.File;
import java.util.Optional;
import javax.validation.constraints.NotNull;

public class KuduKerberosConfig {
    private String clientPrincipal;
    private File clientKeytab;
    private File config;
    private Optional<String> kuduPrincipalPrimary = Optional.empty();

    @NotNull
    public String getClientPrincipal() {
        return this.clientPrincipal;
    }

    @Config(value="kudu.authentication.client.principal")
    @ConfigDescription(value="Kudu Kerberos client principal")
    public KuduKerberosConfig setClientPrincipal(String clientPrincipal) {
        this.clientPrincipal = clientPrincipal;
        return this;
    }

    @NotNull
    @FileExists
    public File getClientKeytab() {
        return this.clientKeytab;
    }

    @Config(value="kudu.authentication.client.keytab")
    @ConfigDescription(value="Kudu Kerberos client keytab location")
    public KuduKerberosConfig setClientKeytab(File clientKeytab) {
        this.clientKeytab = clientKeytab;
        return this;
    }

    @NotNull
    @FileExists
    public File getConfig() {
        return this.config;
    }

    @Config(value="kudu.authentication.config")
    @ConfigDescription(value="Kudu Kerberos service configuration file")
    public KuduKerberosConfig setConfig(File config) {
        this.config = config;
        return this;
    }

    public Optional<String> getKuduPrincipalPrimary() {
        return this.kuduPrincipalPrimary;
    }

    @Config(value="kudu.authentication.server.principal.primary")
    @ConfigDescription(value="The 'primary' portion of the kudu service principal name")
    public KuduKerberosConfig setKuduPrincipalPrimary(String kuduPrincipalPrimary) {
        this.kuduPrincipalPrimary = Optional.ofNullable(kuduPrincipalPrimary);
        return this;
    }
}

