/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kudu;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.trino.plugin.kudu.KuduClientSession;
import io.trino.plugin.kudu.KuduColumnHandle;
import io.trino.plugin.kudu.KuduInsertTableHandle;
import io.trino.plugin.kudu.KuduOutputTableHandle;
import io.trino.plugin.kudu.KuduPartitioningHandle;
import io.trino.plugin.kudu.KuduSessionProperties;
import io.trino.plugin.kudu.KuduTableHandle;
import io.trino.plugin.kudu.TypeHelper;
import io.trino.plugin.kudu.properties.KuduTableProperties;
import io.trino.plugin.kudu.properties.PartitionDesign;
import io.trino.plugin.kudu.schema.KuduRangePartition;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.Assignment;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorOutputMetadata;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableLayout;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTablePartitioning;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.LimitApplicationResult;
import io.trino.spi.connector.NotFoundException;
import io.trino.spi.connector.ProjectionApplicationResult;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.statistics.ComputedStatistics;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Schema;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.Partition;
import org.apache.kudu.client.PartitionSchema;

public class KuduMetadata
implements ConnectorMetadata {
    private final KuduClientSession clientSession;

    @Inject
    public KuduMetadata(KuduClientSession clientSession) {
        this.clientSession = Objects.requireNonNull(clientSession, "clientSession is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return this.clientSession.listSchemaNames();
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        return this.clientSession.listTables(schemaName);
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        List<Object> tables = prefix.getTable().isEmpty() ? this.listTables(session, prefix.getSchema()) : ImmutableList.of((Object)prefix.toSchemaTableName());
        ImmutableMap.Builder columns = ImmutableMap.builder();
        Iterator iterator = tables.iterator();
        while (iterator.hasNext()) {
            SchemaTableName tableName = (SchemaTableName)iterator.next();
            KuduTableHandle tableHandle = this.getTableHandle(session, tableName);
            if (tableHandle == null) continue;
            ConnectorTableMetadata tableMetadata = this.getTableMetadata(tableHandle);
            columns.put((Object)tableName, (Object)tableMetadata.getColumns());
        }
        return columns.buildOrThrow();
    }

    private ColumnMetadata getColumnMetadata(ColumnSchema column) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        StringBuilder extra = new StringBuilder();
        if (column.isKey()) {
            properties.put("primary_key", true);
            extra.append("primary_key, ");
        }
        if (column.isNullable()) {
            properties.put("nullable", true);
            extra.append("nullable, ");
        }
        String encoding = KuduTableProperties.lookupEncodingString(column.getEncoding());
        if (column.getEncoding() != ColumnSchema.Encoding.AUTO_ENCODING) {
            properties.put("encoding", encoding);
        }
        extra.append("encoding=").append(encoding).append(", ");
        String compression = KuduTableProperties.lookupCompressionString(column.getCompressionAlgorithm());
        if (column.getCompressionAlgorithm() != ColumnSchema.CompressionAlgorithm.DEFAULT_COMPRESSION) {
            properties.put("compression", compression);
        }
        extra.append("compression=").append(compression);
        Type prestoType = TypeHelper.fromKuduColumn(column);
        return ColumnMetadata.builder().setName(column.getName()).setType(prestoType).setExtraInfo(Optional.of(extra.toString())).setProperties(properties).build();
    }

    private ConnectorTableMetadata getTableMetadata(KuduTableHandle tableHandle) {
        KuduTable table = tableHandle.getTable(this.clientSession);
        Schema schema = table.getSchema();
        List columnsMetaList = (List)schema.getColumns().stream().filter(column -> !column.isKey() || !column.getName().equals("row_uuid")).map(this::getColumnMetadata).collect(ImmutableList.toImmutableList());
        Map<String, Object> properties = this.clientSession.getTableProperties(tableHandle);
        return new ConnectorTableMetadata(tableHandle.getSchemaTableName(), columnsMetaList, properties);
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle connectorTableHandle) {
        KuduTableHandle tableHandle = (KuduTableHandle)connectorTableHandle;
        Schema schema = this.clientSession.getTableSchema(tableHandle);
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        for (int ordinal = 0; ordinal < schema.getColumnCount(); ++ordinal) {
            ColumnSchema col = schema.getColumnByIndex(ordinal);
            String name = col.getName();
            Type type = TypeHelper.fromKuduColumn(col);
            KuduColumnHandle columnHandle = new KuduColumnHandle(name, ordinal, type);
            columnHandles.put((Object)name, (Object)columnHandle);
        }
        return columnHandles.buildOrThrow();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        KuduColumnHandle kuduColumnHandle = (KuduColumnHandle)columnHandle;
        if (kuduColumnHandle.isVirtualRowId()) {
            return ColumnMetadata.builder().setName("row_uuid").setType((Type)VarbinaryType.VARBINARY).setHidden(true).build();
        }
        return kuduColumnHandle.getColumnMetadata();
    }

    public KuduTableHandle getTableHandle(ConnectorSession session, SchemaTableName schemaTableName) {
        try {
            KuduTable table = this.clientSession.openTable(schemaTableName);
            OptionalInt bucketCount = OptionalInt.empty();
            List bucketSchemas = table.getPartitionSchema().getHashBucketSchemas();
            if (!bucketSchemas.isEmpty()) {
                bucketCount = OptionalInt.of(bucketSchemas.stream().mapToInt(PartitionSchema.HashBucketSchema::getNumBuckets).reduce(1, Math::multiplyExact));
            }
            return new KuduTableHandle(schemaTableName, table, (TupleDomain<ColumnHandle>)TupleDomain.all(), Optional.empty(), false, bucketCount, OptionalLong.empty());
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        KuduTableHandle kuduTableHandle = (KuduTableHandle)tableHandle;
        return this.getTableMetadata(kuduTableHandle);
    }

    public void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties, TrinoPrincipal owner) {
        this.clientSession.createSchema(schemaName);
    }

    public void dropSchema(ConnectorSession session, String schemaName) {
        this.clientSession.dropSchema(schemaName);
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        this.clientSession.createTable(tableMetadata, ignoreExisting);
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        KuduTableHandle kuduTableHandle = (KuduTableHandle)tableHandle;
        this.clientSession.dropTable(kuduTableHandle.getSchemaTableName());
    }

    public void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTableName) {
        KuduTableHandle kuduTableHandle = (KuduTableHandle)tableHandle;
        this.clientSession.renameTable(kuduTableHandle.getSchemaTableName(), newTableName);
    }

    public void addColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnMetadata column) {
        KuduTableHandle kuduTableHandle = (KuduTableHandle)tableHandle;
        this.clientSession.addColumn(kuduTableHandle.getSchemaTableName(), column);
    }

    public void dropColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column) {
        KuduTableHandle kuduTableHandle = (KuduTableHandle)tableHandle;
        KuduColumnHandle kuduColumnHandle = (KuduColumnHandle)column;
        this.clientSession.dropColumn(kuduTableHandle.getSchemaTableName(), kuduColumnHandle.getName());
    }

    public void renameColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle source, String target) {
        KuduTableHandle kuduTableHandle = (KuduTableHandle)tableHandle;
        KuduColumnHandle kuduColumnHandle = (KuduColumnHandle)source;
        this.clientSession.renameColumn(kuduTableHandle.getSchemaTableName(), kuduColumnHandle.getName(), target);
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle connectorTableHandle) {
        KuduTableHandle tableHandle = (KuduTableHandle)connectorTableHandle;
        KuduTable table = tableHandle.getTable(this.clientSession);
        Schema schema = table.getSchema();
        List columns = schema.getColumns();
        List columnTypes = (List)columns.stream().map(TypeHelper::fromKuduColumn).collect(ImmutableList.toImmutableList());
        return new KuduInsertTableHandle(tableHandle.getSchemaTableName(), columnTypes, table);
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        return Optional.empty();
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorTableLayout> layout) {
        PartitionDesign design = KuduTableProperties.getPartitionDesign(tableMetadata.getProperties());
        boolean generateUUID = !design.hasPartitions();
        ConnectorTableMetadata finalTableMetadata = tableMetadata;
        if (generateUUID) {
            String rowId = "row_uuid";
            ArrayList<ColumnMetadata> copy = new ArrayList<ColumnMetadata>(tableMetadata.getColumns());
            HashMap<String, Boolean> columnProperties = new HashMap<String, Boolean>();
            columnProperties.put("primary_key", true);
            copy.add(0, ColumnMetadata.builder().setName(rowId).setType((Type)VarcharType.VARCHAR).setComment(Optional.of("key=true")).setHidden(true).setProperties(columnProperties).build());
            ImmutableList finalColumns = ImmutableList.copyOf(copy);
            HashMap<String, Object> propsCopy = new HashMap<String, Object>(tableMetadata.getProperties());
            propsCopy.put("partition_by_hash_columns", ImmutableList.of((Object)rowId));
            propsCopy.put("partition_by_hash_buckets", 2);
            ImmutableMap finalProperties = ImmutableMap.copyOf(propsCopy);
            finalTableMetadata = new ConnectorTableMetadata(tableMetadata.getTable(), (List)finalColumns, (Map)finalProperties, tableMetadata.getComment());
        }
        KuduTable table = this.clientSession.createTable(finalTableMetadata, false);
        Schema schema = table.getSchema();
        List columns = schema.getColumns();
        List columnTypes = (List)columns.stream().map(TypeHelper::fromKuduColumn).collect(ImmutableList.toImmutableList());
        List columnOriginalTypes = (List)finalTableMetadata.getColumns().stream().map(ColumnMetadata::getType).collect(ImmutableList.toImmutableList());
        return new KuduOutputTableHandle(finalTableMetadata.getTable(), columnOriginalTypes, columnTypes, generateUUID, table);
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        return Optional.empty();
    }

    private static boolean isTableSupportGroupedExecution(KuduTable kuduTable) {
        return !kuduTable.getPartitionSchema().getHashBucketSchemas().isEmpty();
    }

    public ColumnHandle getDeleteRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return KuduColumnHandle.ROW_ID_HANDLE;
    }

    public ConnectorTableHandle beginDelete(ConnectorSession session, ConnectorTableHandle table) {
        KuduTableHandle handle = (KuduTableHandle)table;
        return new KuduTableHandle(handle.getSchemaTableName(), handle.getConstraint(), handle.getDesiredColumns(), true, handle.getBucketCount(), handle.getLimit());
    }

    public void finishDelete(ConnectorSession session, ConnectorTableHandle tableHandle, Collection<Slice> fragments) {
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle table) {
        KuduTableHandle handle = (KuduTableHandle)table;
        KuduTable kuduTable = handle.getTable(this.clientSession);
        Optional<Object> tablePartitioning = Optional.empty();
        Optional<Object> partitioningColumns = Optional.empty();
        ImmutableList localProperties = ImmutableList.of();
        if (KuduSessionProperties.isKuduGroupedExecutionEnabled(session) && KuduMetadata.isTableSupportGroupedExecution(kuduTable)) {
            Map<String, ColumnHandle> columnMap = this.getColumnHandles(session, handle);
            List<Integer> bucketColumnIds = this.getBucketColumnIds(kuduTable);
            List<ColumnHandle> bucketColumns = this.getSpecifyColumns(kuduTable.getSchema(), bucketColumnIds, columnMap);
            Optional<List<KuduRangePartition>> kuduRangePartitions = KuduMetadata.getKuduRangePartitions(kuduTable);
            tablePartitioning = Optional.of(new ConnectorTablePartitioning((ConnectorPartitioningHandle)new KuduPartitioningHandle(handle.getSchemaTableName().getSchemaName(), handle.getSchemaTableName().getTableName(), handle.getBucketCount().orElse(0), bucketColumnIds, bucketColumns.stream().map(KuduColumnHandle.class::cast).map(KuduColumnHandle::getType).collect(Collectors.toList()), kuduRangePartitions), bucketColumns));
            partitioningColumns = Optional.of(ImmutableSet.copyOf(bucketColumns));
        }
        return new ConnectorTableProperties(handle.getConstraint(), tablePartitioning, partitioningColumns, Optional.empty(), (List)localProperties);
    }

    private List<ColumnHandle> getSpecifyColumns(Schema schema, List<Integer> targetColumns, Map<String, ColumnHandle> columnMap) {
        return (List)targetColumns.stream().map(arg_0 -> ((Schema)schema).getColumnByIndex(arg_0)).map(ColumnSchema::getName).map(columnMap::get).collect(ImmutableList.toImmutableList());
    }

    private List<Integer> getBucketColumnIds(KuduTable kuduTable) {
        List hashBucketSchemas = kuduTable.getPartitionSchema().getHashBucketSchemas();
        return (List)hashBucketSchemas.stream().map(PartitionSchema.HashBucketSchema::getColumnIds).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle table, Constraint constraint) {
        TupleDomain newDomain;
        KuduTableHandle handle = (KuduTableHandle)table;
        TupleDomain<ColumnHandle> oldDomain = handle.getConstraint();
        if (oldDomain.equals((Object)(newDomain = oldDomain.intersect(constraint.getSummary())))) {
            return Optional.empty();
        }
        handle = new KuduTableHandle(handle.getSchemaTableName(), handle.getTable(this.clientSession), (TupleDomain<ColumnHandle>)newDomain, handle.getDesiredColumns(), handle.isDeleteHandle(), handle.getBucketCount(), handle.getLimit());
        return Optional.of(new ConstraintApplicationResult((Object)handle, constraint.getSummary(), false));
    }

    public Optional<ProjectionApplicationResult<ConnectorTableHandle>> applyProjection(ConnectorSession session, ConnectorTableHandle table, List<ConnectorExpression> projections, Map<String, ColumnHandle> assignments) {
        KuduTableHandle handle = (KuduTableHandle)table;
        if (handle.getDesiredColumns().isPresent()) {
            return Optional.empty();
        }
        ImmutableList.Builder desiredColumns = ImmutableList.builder();
        ImmutableList.Builder assignmentList = ImmutableList.builder();
        assignments.forEach((name, column) -> {
            desiredColumns.add(column);
            assignmentList.add((Object)new Assignment(name, column, ((KuduColumnHandle)column).getType()));
        });
        handle = new KuduTableHandle(handle.getSchemaTableName(), handle.getTable(this.clientSession), handle.getConstraint(), Optional.of(desiredColumns.build()), handle.isDeleteHandle(), handle.getBucketCount(), handle.getLimit());
        return Optional.of(new ProjectionApplicationResult((Object)handle, projections, (List)assignmentList.build(), false));
    }

    public Optional<LimitApplicationResult<ConnectorTableHandle>> applyLimit(ConnectorSession session, ConnectorTableHandle table, long limit) {
        KuduTableHandle handle = (KuduTableHandle)table;
        if (handle.getLimit().isPresent() && handle.getLimit().getAsLong() <= limit) {
            return Optional.empty();
        }
        handle = new KuduTableHandle(handle.getSchemaTableName(), handle.getTable(this.clientSession), handle.getConstraint(), handle.getDesiredColumns(), handle.isDeleteHandle(), handle.getBucketCount(), OptionalLong.of(limit));
        return Optional.of(new LimitApplicationResult((Object)handle, false, false));
    }

    private static Optional<List<KuduRangePartition>> getKuduRangePartitions(KuduTable table) {
        List<Partition> rangePartitions = KuduMetadata.getRangePartitions(table);
        List kuduRangePartitions = (List)rangePartitions.stream().map(partition -> new KuduRangePartition(partition.getRangeKeyStart(), partition.getRangeKeyEnd())).collect(ImmutableList.toImmutableList());
        return kuduRangePartitions.isEmpty() ? Optional.empty() : Optional.of(kuduRangePartitions);
    }

    private static List<Partition> getRangePartitions(KuduTable table) {
        long fetchTabletsTimeoutInMillis = 60000L;
        try {
            return table.getRangePartitions(60000L);
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unable to get list of tablets for table " + table.getName(), (Throwable)e);
        }
    }
}

