/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kudu;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Shorts;
import com.google.common.primitives.SignedBytes;
import io.airlift.slice.Slice;
import io.trino.plugin.kudu.KuduClientSession;
import io.trino.plugin.kudu.KuduInsertTableHandle;
import io.trino.plugin.kudu.KuduOutputTableHandle;
import io.trino.plugin.kudu.KuduTableMapping;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.SqlDate;
import io.trino.spi.type.SqlDecimal;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Timestamps;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduOperationApplier;
import org.apache.kudu.client.KuduSession;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.client.Upsert;

public class KuduPageSink
implements ConnectorPageSink {
    private final ConnectorSession connectorSession;
    private final KuduSession session;
    private final KuduTable table;
    private final List<Type> columnTypes;
    private final List<Type> originalColumnTypes;
    private final boolean generateUUID;
    private final String uuid;
    private int nextSubId;

    public KuduPageSink(ConnectorSession connectorSession, KuduClientSession clientSession, KuduInsertTableHandle tableHandle) {
        this(connectorSession, clientSession, tableHandle.getTable(clientSession), tableHandle);
    }

    public KuduPageSink(ConnectorSession connectorSession, KuduClientSession clientSession, KuduOutputTableHandle tableHandle) {
        this(connectorSession, clientSession, tableHandle.getTable(clientSession), tableHandle);
    }

    private KuduPageSink(ConnectorSession connectorSession, KuduClientSession clientSession, KuduTable table, KuduTableMapping mapping) {
        Objects.requireNonNull(clientSession, "clientSession is null");
        this.connectorSession = connectorSession;
        this.columnTypes = mapping.getColumnTypes();
        this.originalColumnTypes = mapping.getOriginalColumnTypes();
        this.generateUUID = mapping.isGenerateUUID();
        this.table = table;
        this.session = clientSession.newSession();
        this.uuid = UUID.randomUUID().toString();
    }

    public CompletableFuture<?> appendPage(Page page) {
        for (int position = 0; position < page.getPositionCount(); ++position) {
            Upsert upsert = this.table.newUpsert();
            PartialRow row = upsert.getRow();
            int start = 0;
            if (this.generateUUID) {
                String id = String.format("%s-%08x", this.uuid, this.nextSubId++);
                row.addString(0, id);
                start = 1;
            }
            for (int channel = 0; channel < page.getChannelCount(); ++channel) {
                this.appendColumn(row, page, position, channel, channel + start);
            }
            try {
                KuduOperationApplier.applyOperationAndVerifySucceeded(this.session, (Operation)upsert);
                continue;
            }
            catch (KuduException e) {
                throw new RuntimeException(e);
            }
        }
        return NOT_BLOCKED;
    }

    private void appendColumn(PartialRow row, Page page, int position, int channel, int destChannel) {
        Block block = page.getBlock(channel);
        Type type = this.columnTypes.get(destChannel);
        if (block.isNull(position)) {
            row.setNull(destChannel);
        } else if (TimestampType.TIMESTAMP_MILLIS.equals((Object)type)) {
            row.addLong(destChannel, Timestamps.truncateEpochMicrosToMillis((long)type.getLong(block, position)));
        } else if (RealType.REAL.equals((Object)type)) {
            row.addFloat(destChannel, Float.intBitsToFloat(Math.toIntExact(type.getLong(block, position))));
        } else if (BigintType.BIGINT.equals((Object)type)) {
            row.addLong(destChannel, type.getLong(block, position));
        } else if (IntegerType.INTEGER.equals((Object)type)) {
            row.addInt(destChannel, Math.toIntExact(type.getLong(block, position)));
        } else if (SmallintType.SMALLINT.equals((Object)type)) {
            row.addShort(destChannel, Shorts.checkedCast((long)type.getLong(block, position)));
        } else if (TinyintType.TINYINT.equals((Object)type)) {
            row.addByte(destChannel, SignedBytes.checkedCast((long)type.getLong(block, position)));
        } else if (BooleanType.BOOLEAN.equals((Object)type)) {
            row.addBoolean(destChannel, type.getBoolean(block, position));
        } else if (DoubleType.DOUBLE.equals((Object)type)) {
            row.addDouble(destChannel, type.getDouble(block, position));
        } else if (type instanceof VarcharType) {
            Type originalType = this.originalColumnTypes.get(destChannel);
            if (DateType.DATE.equals((Object)originalType)) {
                SqlDate date = (SqlDate)originalType.getObjectValue(this.connectorSession, block, position);
                LocalDateTime ldt = LocalDateTime.ofEpochSecond(TimeUnit.DAYS.toSeconds(date.getDays()), 0, ZoneOffset.UTC);
                byte[] bytes = ldt.format(DateTimeFormatter.ISO_LOCAL_DATE).getBytes(StandardCharsets.UTF_8);
                row.addStringUtf8(destChannel, bytes);
            } else {
                row.addString(destChannel, type.getSlice(block, position).toStringUtf8());
            }
        } else if (VarbinaryType.VARBINARY.equals((Object)type)) {
            row.addBinary(destChannel, type.getSlice(block, position).toByteBuffer());
        } else if (type instanceof DecimalType) {
            SqlDecimal sqlDecimal = (SqlDecimal)type.getObjectValue(this.connectorSession, block, position);
            row.addDecimal(destChannel, sqlDecimal.toBigDecimal());
        } else {
            throw new UnsupportedOperationException("Type is not supported: " + type);
        }
    }

    public CompletableFuture<Collection<Slice>> finish() {
        this.closeSession();
        return CompletableFuture.completedFuture(ImmutableList.of());
    }

    public void abort() {
        this.closeSession();
    }

    private void closeSession() {
        try {
            this.session.close();
        }
        catch (KuduException e) {
            throw new RuntimeException(e);
        }
    }
}

