/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kudu;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.trino.plugin.kudu.schema.KuduRangePartition;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class KuduPartitioningHandle
implements ConnectorPartitioningHandle {
    private final String schema;
    private final String table;
    private final int bucketCount;
    private final List<Integer> bucketColumnIndexes;
    private final List<Type> bucketColumnTypes;
    private final Optional<List<KuduRangePartition>> rangePartitions;

    @JsonCreator
    public KuduPartitioningHandle(@JsonProperty(value="schema") String schema, @JsonProperty(value="table") String table, @JsonProperty(value="bucketCount") int bucketCount, @JsonProperty(value="bucketColumnIndexes") List<Integer> bucketColumnIndexes, @JsonProperty(value="bucketColumnTypes") List<Type> bucketColumnTypes, @JsonProperty(value="rangePartitions") Optional<List<KuduRangePartition>> rangePartitions) {
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.table = table;
        this.bucketCount = bucketCount;
        this.bucketColumnIndexes = bucketColumnIndexes;
        this.bucketColumnTypes = Objects.requireNonNull(bucketColumnTypes, "bucketColumnTypes is null");
        this.rangePartitions = Objects.requireNonNull(rangePartitions, "rangePartitions is null");
    }

    @JsonProperty
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty
    public String getTable() {
        return this.table;
    }

    @JsonProperty
    public int getBucketCount() {
        return this.bucketCount;
    }

    @JsonProperty
    public List<Type> getBucketColumnTypes() {
        return this.bucketColumnTypes;
    }

    @JsonProperty
    public List<Integer> getBucketColumnIndexes() {
        return this.bucketColumnIndexes;
    }

    @JsonProperty
    public Optional<List<KuduRangePartition>> getRangePartitions() {
        return this.rangePartitions;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("schema", (Object)this.schema).add("table", (Object)this.table).add("bucketCount", this.bucketCount).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KuduPartitioningHandle that = (KuduPartitioningHandle)o;
        if (this.rangePartitions.isPresent() != that.rangePartitions.isPresent()) {
            return false;
        }
        if (this.rangePartitions.isPresent()) {
            List<KuduRangePartition> thisRangePartitions = this.rangePartitions.get();
            List<KuduRangePartition> thatRangePartitions = that.rangePartitions.get();
            if (thisRangePartitions.size() != thatRangePartitions.size()) {
                return false;
            }
            for (int i = 0; i < thisRangePartitions.size(); ++i) {
                if (thisRangePartitions.get(i).equals(thatRangePartitions.get(i))) continue;
                return false;
            }
        }
        return this.bucketCount == that.bucketCount && Objects.equals(this.bucketColumnTypes, that.bucketColumnTypes);
    }

    public int hashCode() {
        return Objects.hash(this.bucketCount, this.schema, this.table, this.bucketColumnTypes);
    }
}

