/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kudu;

import com.google.common.collect.ImmutableList;
import io.airlift.units.Duration;
import io.trino.plugin.base.session.PropertyMetadataUtil;
import io.trino.plugin.kudu.KuduClientConfig;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.session.PropertyMetadata;
import java.util.List;
import javax.inject.Inject;

public final class KuduSessionProperties {
    private static final String KUDU_GROUPED_EXECUTION_ENABLED = "grouped_execution";
    private static final String DYNAMIC_FILTERING_WAIT_TIMEOUT = "dynamic_filtering_wait_timeout";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public KuduSessionProperties(KuduClientConfig kuduConfig) {
        this.sessionProperties = ImmutableList.of((Object)PropertyMetadata.booleanProperty((String)KUDU_GROUPED_EXECUTION_ENABLED, (String)"Enable grouped execution.", (Boolean)kuduConfig.isGroupedExecutionEnabled(), (boolean)false), (Object)PropertyMetadataUtil.durationProperty((String)DYNAMIC_FILTERING_WAIT_TIMEOUT, (String)"Duration to wait for completion of dynamic filters", (Duration)kuduConfig.getDynamicFilteringWaitTimeout(), (boolean)false));
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static boolean isKuduGroupedExecutionEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(KUDU_GROUPED_EXECUTION_ENABLED, Boolean.class);
    }

    public static Duration getDynamicFilteringWaitTimeout(ConnectorSession session) {
        return (Duration)session.getProperty(DYNAMIC_FILTERING_WAIT_TIMEOUT, Duration.class);
    }
}

