/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kudu;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.SchemaTableName;
import java.util.List;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class KuduSplit
implements ConnectorSplit {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(KuduSplit.class).instanceSize();
    private final SchemaTableName schemaTableName;
    private final int primaryKeyColumnCount;
    private final byte[] serializedScanToken;
    private final int bucketNumber;

    @JsonCreator
    public KuduSplit(@JsonProperty(value="schemaTableName") SchemaTableName schemaTableName, @JsonProperty(value="primaryKeyColumnCount") int primaryKeyColumnCount, @JsonProperty(value="serializedScanToken") byte[] serializedScanToken, @JsonProperty(value="bucketNumber") int bucketNumber) {
        this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        this.primaryKeyColumnCount = primaryKeyColumnCount;
        this.serializedScanToken = Objects.requireNonNull(serializedScanToken, "serializedScanToken is null");
        Preconditions.checkArgument((bucketNumber >= 0 ? 1 : 0) != 0, (Object)"bucketNumber is negative");
        this.bucketNumber = bucketNumber;
    }

    @JsonProperty
    public SchemaTableName getSchemaTableName() {
        return this.schemaTableName;
    }

    @JsonProperty
    public byte[] getSerializedScanToken() {
        return this.serializedScanToken;
    }

    @JsonProperty
    public int getPrimaryKeyColumnCount() {
        return this.primaryKeyColumnCount;
    }

    @JsonProperty
    public int getBucketNumber() {
        return this.bucketNumber;
    }

    public boolean isRemotelyAccessible() {
        return true;
    }

    public List<HostAddress> getAddresses() {
        return ImmutableList.of();
    }

    public Object getInfo() {
        return this;
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.schemaTableName.getRetainedSizeInBytes() + SizeOf.sizeOf((byte[])this.serializedScanToken);
    }
}

