/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kudu;

import io.airlift.slice.Slice;
import io.trino.plugin.kudu.KuduClientSession;
import io.trino.plugin.kudu.KuduRecordSet;
import io.trino.plugin.kudu.RowHelper;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.connector.RecordPageSource;
import io.trino.spi.connector.RecordSet;
import io.trino.spi.connector.UpdatablePageSource;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.apache.kudu.Schema;
import org.apache.kudu.client.Delete;
import org.apache.kudu.client.KeyEncoderAccessor;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduOperationApplier;
import org.apache.kudu.client.KuduSession;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.PartialRow;

public class KuduUpdatablePageSource
implements UpdatablePageSource {
    private final KuduClientSession clientSession;
    private final KuduTable table;
    private final RecordPageSource inner;

    public KuduUpdatablePageSource(KuduRecordSet recordSet) {
        this.clientSession = recordSet.getClientSession();
        this.table = recordSet.getTable();
        this.inner = new RecordPageSource((RecordSet)recordSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRows(Block rowIds) {
        Schema schema = this.table.getSchema();
        KuduSession session = this.clientSession.newSession();
        try {
            try {
                for (int i = 0; i < rowIds.getPositionCount(); ++i) {
                    int len = rowIds.getSliceLength(i);
                    Slice slice = rowIds.getSlice(i, 0, len);
                    PartialRow row = KeyEncoderAccessor.decodePrimaryKey(schema, slice.getBytes());
                    Delete delete = this.table.newDelete();
                    RowHelper.copyPrimaryKey(schema, row, delete.getRow());
                    KuduOperationApplier.applyOperationAndVerifySucceeded(session, (Operation)delete);
                }
            }
            finally {
                session.close();
            }
        }
        catch (KuduException e) {
            throw new RuntimeException(e);
        }
    }

    public CompletableFuture<Collection<Slice>> finish() {
        CompletableFuture<Collection<Slice>> cf = new CompletableFuture<Collection<Slice>>();
        cf.complete(Collections.emptyList());
        return cf;
    }

    public long getCompletedBytes() {
        return this.inner.getCompletedBytes();
    }

    public long getReadTimeNanos() {
        return this.inner.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.inner.isFinished();
    }

    public Page getNextPage() {
        return this.inner.getNextPage();
    }

    public long getMemoryUsage() {
        return this.inner.getMemoryUsage();
    }

    public void close() {
        this.inner.close();
    }
}

