/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kudu.procedures;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.kudu.KuduClientSession;
import io.trino.plugin.kudu.properties.KuduTableProperties;
import io.trino.plugin.kudu.properties.RangePartition;
import io.trino.spi.block.MethodHandleUtil;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class RangePartitionProcedures {
    private static final MethodHandle ADD = MethodHandleUtil.methodHandle(RangePartitionProcedures.class, (String)"addRangePartition", (Class[])new Class[]{String.class, String.class, String.class});
    private static final MethodHandle DROP = MethodHandleUtil.methodHandle(RangePartitionProcedures.class, (String)"dropRangePartition", (Class[])new Class[]{String.class, String.class, String.class});
    private final KuduClientSession clientSession;

    @Inject
    public RangePartitionProcedures(KuduClientSession clientSession) {
        this.clientSession = Objects.requireNonNull(clientSession);
    }

    public Procedure getAddPartitionProcedure() {
        return new Procedure("system", "add_range_partition", (List)ImmutableList.of((Object)new Procedure.Argument("SCHEMA", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("TABLE", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("RANGE_BOUNDS", (Type)VarcharType.VARCHAR)), ADD.bindTo(this));
    }

    public Procedure getDropPartitionProcedure() {
        return new Procedure("system", "drop_range_partition", (List)ImmutableList.of((Object)new Procedure.Argument("SCHEMA", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("TABLE", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("RANGE_BOUNDS", (Type)VarcharType.VARCHAR)), DROP.bindTo(this));
    }

    public void addRangePartition(String schema, String table, String rangeBounds) {
        SchemaTableName schemaTableName = new SchemaTableName(schema, table);
        RangePartition rangePartition = KuduTableProperties.parseRangePartition(rangeBounds);
        this.clientSession.addRangePartition(schemaTableName, rangePartition);
    }

    public void dropRangePartition(String schema, String table, String rangeBounds) {
        SchemaTableName schemaTableName = new SchemaTableName(schema, table);
        RangePartition rangePartition = KuduTableProperties.parseRangePartition(rangeBounds);
        this.clientSession.dropRangePartition(schemaTableName, rangePartition);
    }
}

