/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kudu.properties;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.kudu.properties.ColumnDesign;
import io.trino.plugin.kudu.properties.HashPartitionDefinition;
import io.trino.plugin.kudu.properties.PartitionDesign;
import io.trino.plugin.kudu.properties.RangeBoundValue;
import io.trino.plugin.kudu.properties.RangePartition;
import io.trino.plugin.kudu.properties.RangePartitionDefinition;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.VarcharType;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Schema;
import org.apache.kudu.Type;
import org.apache.kudu.client.KeyEncoderAccessor;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.client.Partition;
import org.apache.kudu.client.PartitionSchema;
import org.joda.time.DateTimeZone;
import org.joda.time.format.ISODateTimeFormat;

public final class KuduTableProperties {
    public static final String PARTITION_BY_HASH_COLUMNS = "partition_by_hash_columns";
    public static final String PARTITION_BY_HASH_BUCKETS = "partition_by_hash_buckets";
    public static final String PARTITION_BY_HASH_COLUMNS_2 = "partition_by_second_hash_columns";
    public static final String PARTITION_BY_HASH_BUCKETS_2 = "partition_by_second_hash_buckets";
    public static final String PARTITION_BY_RANGE_COLUMNS = "partition_by_range_columns";
    public static final String RANGE_PARTITIONS = "range_partitions";
    public static final String NUM_REPLICAS = "number_of_replicas";
    public static final String PRIMARY_KEY = "primary_key";
    public static final String NULLABLE = "nullable";
    public static final String ENCODING = "encoding";
    public static final String COMPRESSION = "compression";
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final long DEFAULT_TIMEOUT = 20000L;
    private final List<PropertyMetadata<?>> tableProperties = ImmutableList.of((Object)new PropertyMetadata("partition_by_hash_columns", "Columns for optional first hash partition level", (io.trino.spi.type.Type)new ArrayType((io.trino.spi.type.Type)VarcharType.VARCHAR), List.class, (Object)ImmutableList.of(), false, value -> (List)((List)value).stream().map(name -> ((String)name).toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList()), value -> value), (Object)PropertyMetadata.integerProperty((String)"partition_by_hash_buckets", (String)"Number of buckets for optional first hash partition level.", null, (boolean)false), (Object)new PropertyMetadata("partition_by_second_hash_columns", "Columns for optional second hash partition level", (io.trino.spi.type.Type)new ArrayType((io.trino.spi.type.Type)VarcharType.VARCHAR), List.class, (Object)ImmutableList.of(), false, value -> (List)((List)value).stream().map(name -> ((String)name).toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList()), value -> value), (Object)PropertyMetadata.integerProperty((String)"partition_by_second_hash_buckets", (String)"Number of buckets for optional second hash partition level.", null, (boolean)false), (Object)new PropertyMetadata("partition_by_range_columns", "Columns for optional range partition level", (io.trino.spi.type.Type)new ArrayType((io.trino.spi.type.Type)VarcharType.VARCHAR), List.class, (Object)ImmutableList.of(), false, value -> (List)((List)value).stream().map(name -> ((String)name).toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList()), value -> value), (Object)PropertyMetadata.integerProperty((String)"number_of_replicas", (String)"Number of tablet replicas. Uses default value from Kudu master if not specified.", null, (boolean)false), (Object)PropertyMetadata.stringProperty((String)"range_partitions", (String)"Initial range partitions as JSON", null, (boolean)false));
    private final List<PropertyMetadata<?>> columnProperties = ImmutableList.of((Object)PropertyMetadata.booleanProperty((String)"primary_key", (String)"If column belongs to primary key", (Boolean)false, (boolean)false), (Object)PropertyMetadata.booleanProperty((String)"nullable", (String)"If column can be set to null", (Boolean)false, (boolean)false), (Object)PropertyMetadata.stringProperty((String)"encoding", (String)"Optional specification of the column encoding. Otherwise default encoding is applied.", null, (boolean)false), (Object)PropertyMetadata.stringProperty((String)"compression", (String)"Optional specification of the column compression. Otherwise default compression is applied.", null, (boolean)false));

    @Inject
    public KuduTableProperties() {
    }

    public List<PropertyMetadata<?>> getTableProperties() {
        return this.tableProperties;
    }

    public List<PropertyMetadata<?>> getColumnProperties() {
        return this.columnProperties;
    }

    public static PartitionDesign getPartitionDesign(Map<String, Object> tableProperties) {
        Objects.requireNonNull(tableProperties);
        List hashColumns = (List)tableProperties.get(PARTITION_BY_HASH_COLUMNS);
        List hashColumns2 = (List)tableProperties.get(PARTITION_BY_HASH_COLUMNS_2);
        PartitionDesign design = new PartitionDesign();
        if (!hashColumns.isEmpty()) {
            ArrayList<HashPartitionDefinition> hashPartitions = new ArrayList<HashPartitionDefinition>();
            HashPartitionDefinition hash1 = KuduTableProperties.getHashPartitionDefinition(tableProperties, hashColumns, PARTITION_BY_HASH_BUCKETS);
            hashPartitions.add(hash1);
            if (!hashColumns2.isEmpty()) {
                HashPartitionDefinition hash2 = KuduTableProperties.getHashPartitionDefinition(tableProperties, hashColumns2, PARTITION_BY_HASH_BUCKETS_2);
                hashPartitions.add(hash2);
            }
            design.setHash(hashPartitions);
        } else if (!hashColumns2.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, "Table property partition_by_second_hash_columns is only allowed if there is also partition_by_hash_columns");
        }
        List rangeColumns = (List)tableProperties.get(PARTITION_BY_RANGE_COLUMNS);
        if (!rangeColumns.isEmpty()) {
            RangePartitionDefinition range = new RangePartitionDefinition();
            range.setColumns(rangeColumns);
            design.setRange(range);
        }
        return design;
    }

    public static ColumnDesign getColumnDesign(Map<String, Object> columnProperties) {
        String compression;
        String encoding;
        Boolean nullable;
        Objects.requireNonNull(columnProperties);
        if (columnProperties.isEmpty()) {
            return ColumnDesign.DEFAULT;
        }
        ColumnDesign design = new ColumnDesign();
        Boolean key = (Boolean)columnProperties.get(PRIMARY_KEY);
        if (key != null) {
            design.setPrimaryKey(key);
        }
        if ((nullable = (Boolean)columnProperties.get(NULLABLE)) != null) {
            design.setNullable(nullable);
        }
        if ((encoding = (String)columnProperties.get(ENCODING)) != null) {
            design.setEncoding(encoding);
        }
        if ((compression = (String)columnProperties.get(COMPRESSION)) != null) {
            design.setCompression(compression);
        }
        return design;
    }

    private static HashPartitionDefinition getHashPartitionDefinition(Map<String, Object> tableProperties, List<String> columns, String bucketPropertyName) {
        Integer hashBuckets = (Integer)tableProperties.get(bucketPropertyName);
        if (hashBuckets == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, "Missing table property " + bucketPropertyName);
        }
        HashPartitionDefinition definition = new HashPartitionDefinition();
        definition.setColumns(columns);
        definition.setBuckets(hashBuckets);
        return definition;
    }

    public static List<RangePartition> getRangePartitions(Map<String, Object> tableProperties) {
        Objects.requireNonNull(tableProperties);
        String json = (String)tableProperties.get(RANGE_PARTITIONS);
        if (json != null) {
            try {
                Object[] partitions = (RangePartition[])mapper.readValue(json, RangePartition[].class);
                if (partitions == null) {
                    return ImmutableList.of();
                }
                return ImmutableList.copyOf((Object[])partitions);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return ImmutableList.of();
    }

    public static RangePartition parseRangePartition(String json) {
        if (json == null) {
            return null;
        }
        try {
            return (RangePartition)mapper.readValue(json, RangePartition.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Optional<Integer> getNumReplicas(Map<String, Object> tableProperties) {
        Objects.requireNonNull(tableProperties);
        Integer numReplicas = (Integer)tableProperties.get(NUM_REPLICAS);
        return Optional.ofNullable(numReplicas);
    }

    public static Map<String, Object> toMap(KuduTable table) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        PartitionDesign partitionDesign = KuduTableProperties.getPartitionDesign(table);
        List<RangePartition> rangePartitionList = KuduTableProperties.getRangePartitionList(table, 20000L);
        try {
            if (partitionDesign.getHash() != null) {
                List<HashPartitionDefinition> list = partitionDesign.getHash();
                if (!list.isEmpty()) {
                    properties.put(PARTITION_BY_HASH_COLUMNS, list.get(0).getColumns());
                    properties.put(PARTITION_BY_HASH_BUCKETS, list.get(0).getBuckets());
                }
                if (list.size() >= 2) {
                    properties.put(PARTITION_BY_HASH_COLUMNS_2, list.get(1).getColumns());
                    properties.put(PARTITION_BY_HASH_BUCKETS_2, list.get(1).getBuckets());
                }
            }
            if (partitionDesign.getRange() != null) {
                properties.put(PARTITION_BY_RANGE_COLUMNS, partitionDesign.getRange().getColumns());
            }
            String partitionRangesValue = mapper.writeValueAsString(rangePartitionList);
            properties.put(RANGE_PARTITIONS, partitionRangesValue);
            properties.put(NUM_REPLICAS, table.getNumReplicas());
            return properties;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<RangePartition> getRangePartitionList(KuduTable table, long timeout) {
        ArrayList<RangePartition> rangePartitions = new ArrayList<RangePartition>();
        if (!table.getPartitionSchema().getRangeSchema().getColumnIds().isEmpty()) {
            try {
                for (Partition partition : table.getRangePartitions(timeout)) {
                    RangePartition rangePartition = KuduTableProperties.buildRangePartition(table, partition);
                    rangePartitions.add(rangePartition);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return rangePartitions;
    }

    private static RangePartition buildRangePartition(KuduTable table, Partition partition) {
        RangeBoundValue lower = KuduTableProperties.buildRangePartitionBound(table, partition.getRangeKeyStart());
        RangeBoundValue upper = KuduTableProperties.buildRangePartitionBound(table, partition.getRangeKeyEnd());
        return new RangePartition(lower, upper);
    }

    private static RangeBoundValue buildRangePartitionBound(KuduTable table, byte[] rangeKey) {
        if (rangeKey.length == 0) {
            return null;
        }
        Schema schema = table.getSchema();
        PartitionSchema partitionSchema = table.getPartitionSchema();
        PartitionSchema.RangeSchema rangeSchema = partitionSchema.getRangeSchema();
        List rangeColumns = rangeSchema.getColumnIds();
        int numColumns = rangeColumns.size();
        PartialRow bound = KeyEncoderAccessor.decodeRangePartitionKey(schema, partitionSchema, rangeKey);
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < numColumns; ++i) {
            Object obj = KuduTableProperties.toValue(schema, bound, (Integer)rangeColumns.get(i));
            list.add(obj);
        }
        return new RangeBoundValue(list);
    }

    private static Object toValue(Schema schema, PartialRow bound, Integer idx) {
        Type type = schema.getColumnByIndex(idx.intValue()).getType();
        switch (type) {
            case UNIXTIME_MICROS: {
                long millis = bound.getLong(idx.intValue()) / 1000L;
                return ISODateTimeFormat.dateTime().withZone(DateTimeZone.UTC).print(millis);
            }
            case STRING: {
                return bound.getString(idx.intValue());
            }
            case INT64: {
                return bound.getLong(idx.intValue());
            }
            case INT32: {
                return bound.getInt(idx.intValue());
            }
            case INT16: {
                return bound.getShort(idx.intValue());
            }
            case INT8: {
                return (short)bound.getByte(idx.intValue());
            }
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: {
                break;
            }
            case BOOL: {
                return bound.getBoolean(idx.intValue());
            }
            case BINARY: {
                return bound.getBinaryCopy(idx.intValue());
            }
        }
        throw new IllegalStateException("Unhandled type " + type + " for range partition");
    }

    public static PartitionDesign getPartitionDesign(KuduTable table) {
        Schema schema = table.getSchema();
        PartitionDesign partitionDesign = new PartitionDesign();
        PartitionSchema partitionSchema = table.getPartitionSchema();
        List hashPartitions = (List)partitionSchema.getHashBucketSchemas().stream().map(hashBucketSchema -> {
            HashPartitionDefinition hash = new HashPartitionDefinition();
            List cols = (List)hashBucketSchema.getColumnIds().stream().map(idx -> schema.getColumnByIndex(idx.intValue()).getName()).collect(ImmutableList.toImmutableList());
            hash.setColumns(cols);
            hash.setBuckets(hashBucketSchema.getNumBuckets());
            return hash;
        }).collect(ImmutableList.toImmutableList());
        partitionDesign.setHash(hashPartitions);
        List rangeColumns = partitionSchema.getRangeSchema().getColumnIds();
        if (!rangeColumns.isEmpty()) {
            RangePartitionDefinition definition = new RangePartitionDefinition();
            definition.setColumns((List)rangeColumns.stream().map(i -> ((ColumnSchema)schema.getColumns().get((int)i)).getName()).collect(ImmutableList.toImmutableList()));
            partitionDesign.setRange(definition);
        }
        return partitionDesign;
    }

    public static PartialRow toRangeBoundToPartialRow(Schema schema, RangePartitionDefinition definition, RangeBoundValue boundValue) {
        PartialRow partialRow = new PartialRow(schema);
        if (boundValue != null) {
            List rangeColumns = (List)definition.getColumns().stream().map(arg_0 -> ((Schema)schema).getColumnIndex(arg_0)).collect(ImmutableList.toImmutableList());
            if (rangeColumns.size() != boundValue.getValues().size()) {
                throw new IllegalStateException("Expected " + rangeColumns.size() + " range columns, but got " + boundValue.getValues().size());
            }
            for (int i = 0; i < rangeColumns.size(); ++i) {
                Object obj = boundValue.getValues().get(i);
                int idx = (Integer)rangeColumns.get(i);
                ColumnSchema columnSchema = schema.getColumnByIndex(idx);
                KuduTableProperties.setColumnValue(partialRow, idx, obj, columnSchema.getType(), columnSchema.getName());
            }
        }
        return partialRow;
    }

    private static void setColumnValue(PartialRow partialRow, int idx, Object obj, Type type, String name) {
        switch (type) {
            case STRING: {
                if (obj instanceof String) {
                    partialRow.addString(idx, (String)obj);
                    break;
                }
                KuduTableProperties.handleInvalidValue(name, type, obj);
                break;
            }
            case INT64: {
                Number n = KuduTableProperties.toNumber(obj, type, name);
                partialRow.addLong(idx, n.longValue());
                break;
            }
            case INT32: {
                Number n = KuduTableProperties.toNumber(obj, type, name);
                partialRow.addInt(idx, n.intValue());
                break;
            }
            case INT16: {
                Number n = KuduTableProperties.toNumber(obj, type, name);
                partialRow.addShort(idx, n.shortValue());
                break;
            }
            case INT8: {
                Number n = KuduTableProperties.toNumber(obj, type, name);
                partialRow.addByte(idx, n.byteValue());
                break;
            }
            case DOUBLE: {
                Number n = KuduTableProperties.toNumber(obj, type, name);
                partialRow.addDouble(idx, n.doubleValue());
                break;
            }
            case FLOAT: {
                Number n = KuduTableProperties.toNumber(obj, type, name);
                partialRow.addFloat(idx, n.floatValue());
                break;
            }
            case UNIXTIME_MICROS: {
                long l = KuduTableProperties.toUnixTimeMicros(obj, type, name);
                partialRow.addLong(idx, l);
                break;
            }
            case BOOL: {
                boolean b = KuduTableProperties.toBoolean(obj, type, name);
                partialRow.addBoolean(idx, b);
                break;
            }
            case BINARY: {
                byte[] bytes = KuduTableProperties.toByteArray(obj, type, name);
                partialRow.addBinary(idx, bytes);
                break;
            }
            default: {
                KuduTableProperties.handleInvalidValue(name, type, obj);
            }
        }
    }

    private static byte[] toByteArray(Object obj, Type type, String name) {
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        if (obj instanceof String) {
            return Base64.getDecoder().decode((String)obj);
        }
        KuduTableProperties.handleInvalidValue(name, type, obj);
        return null;
    }

    private static boolean toBoolean(Object obj, Type type, String name) {
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof String) {
            return Boolean.valueOf((String)obj);
        }
        KuduTableProperties.handleInvalidValue(name, type, obj);
        return false;
    }

    private static long toUnixTimeMicros(Object obj, Type type, String name) {
        if (Number.class.isAssignableFrom(obj.getClass())) {
            return ((Number)obj).longValue();
        }
        if (obj instanceof String) {
            String s = (String)obj;
            s = s.trim().replace(' ', 'T');
            long millis = ISODateTimeFormat.dateOptionalTimeParser().withZone(DateTimeZone.UTC).parseMillis(s);
            return millis * 1000L;
        }
        KuduTableProperties.handleInvalidValue(name, type, obj);
        return 0L;
    }

    private static Number toNumber(Object obj, Type type, String name) {
        if (Number.class.isAssignableFrom(obj.getClass())) {
            return (Number)obj;
        }
        if (obj instanceof String) {
            return new BigDecimal((String)obj);
        }
        KuduTableProperties.handleInvalidValue(name, type, obj);
        return 0;
    }

    private static void handleInvalidValue(String name, Type type, Object obj) {
        throw new IllegalStateException("Invalid value " + obj + " for column " + name + " of type " + type);
    }

    public static ColumnSchema.CompressionAlgorithm lookupCompression(String compression) {
        switch (compression.toLowerCase(Locale.ENGLISH)) {
            case "default": 
            case "default_compression": {
                return ColumnSchema.CompressionAlgorithm.DEFAULT_COMPRESSION;
            }
            case "no": 
            case "no_compression": {
                return ColumnSchema.CompressionAlgorithm.NO_COMPRESSION;
            }
            case "lz4": {
                return ColumnSchema.CompressionAlgorithm.LZ4;
            }
            case "snappy": {
                return ColumnSchema.CompressionAlgorithm.SNAPPY;
            }
            case "zlib": {
                return ColumnSchema.CompressionAlgorithm.ZLIB;
            }
        }
        throw new IllegalArgumentException();
    }

    public static String lookupCompressionString(ColumnSchema.CompressionAlgorithm algorithm) {
        switch (algorithm) {
            case DEFAULT_COMPRESSION: {
                return "default";
            }
            case NO_COMPRESSION: {
                return "no";
            }
            case LZ4: {
                return "lz4";
            }
            case SNAPPY: {
                return "snappy";
            }
            case ZLIB: {
                return "zlib";
            }
        }
        return "unknown";
    }

    public static ColumnSchema.Encoding lookupEncoding(String encoding) {
        switch (encoding.toLowerCase(Locale.ENGLISH)) {
            case "auto": 
            case "auto_encoding": {
                return ColumnSchema.Encoding.AUTO_ENCODING;
            }
            case "bitshuffle": 
            case "bit_shuffle": {
                return ColumnSchema.Encoding.BIT_SHUFFLE;
            }
            case "dictionary": 
            case "dict_encoding": {
                return ColumnSchema.Encoding.DICT_ENCODING;
            }
            case "plain": 
            case "plain_encoding": {
                return ColumnSchema.Encoding.PLAIN_ENCODING;
            }
            case "prefix": 
            case "prefix_encoding": {
                return ColumnSchema.Encoding.PREFIX_ENCODING;
            }
            case "runlength": 
            case "run_length": 
            case "run length": 
            case "rle": {
                return ColumnSchema.Encoding.RLE;
            }
            case "group_varint": {
                return ColumnSchema.Encoding.GROUP_VARINT;
            }
        }
        throw new IllegalArgumentException();
    }

    public static String lookupEncodingString(ColumnSchema.Encoding encoding) {
        switch (encoding) {
            case AUTO_ENCODING: {
                return "auto";
            }
            case BIT_SHUFFLE: {
                return "bitshuffle";
            }
            case DICT_ENCODING: {
                return "dictionary";
            }
            case PLAIN_ENCODING: {
                return "plain";
            }
            case PREFIX_ENCODING: {
                return "prefix";
            }
            case RLE: {
                return "runlength";
            }
            case GROUP_VARINT: {
                return "group_varint";
            }
        }
        return "unknown";
    }
}

