/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kudu.properties;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.kudu.properties.RangeBoundValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RangeBoundValueDeserializer
extends JsonDeserializer<RangeBoundValue> {
    public RangeBoundValue deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ImmutableList list;
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        if (node.isNull()) {
            return null;
        }
        if (node.isArray()) {
            list = new ArrayList();
            Iterator iter = node.elements();
            while (iter.hasNext()) {
                Object v = this.toValue((JsonNode)iter.next());
                list.add(v);
            }
        } else {
            Object v = this.toValue(node);
            list = ImmutableList.of((Object)v);
        }
        return new RangeBoundValue((List<Object>)list);
    }

    private Object toValue(JsonNode node) throws IOException {
        if (node.isTextual()) {
            return node.asText();
        }
        if (node.isNumber()) {
            return node.numberValue();
        }
        if (node.isBoolean()) {
            return node.asBoolean();
        }
        if (node.isBinary()) {
            return node.binaryValue();
        }
        throw new IllegalStateException("Unexpected range bound value: " + node);
    }
}

