/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kudu.schema;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.kudu.KuduClientWrapper;
import io.trino.plugin.kudu.schema.SchemaAlreadyExistsException;
import io.trino.plugin.kudu.schema.SchemaEmulation;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Schema;
import org.apache.kudu.Type;
import org.apache.kudu.client.CreateTableOptions;
import org.apache.kudu.client.Delete;
import org.apache.kudu.client.Insert;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduOperationApplier;
import org.apache.kudu.client.KuduScanner;
import org.apache.kudu.client.KuduSession;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.RowResult;
import org.apache.kudu.client.RowResultIterator;
import org.apache.kudu.client.Upsert;

public class SchemaEmulationByTableNameConvention
implements SchemaEmulation {
    private final String commonPrefix;
    private final String rawSchemasTableName;
    private KuduTable rawSchemasTable;

    public SchemaEmulationByTableNameConvention(String commonPrefix) {
        this.commonPrefix = commonPrefix;
        this.rawSchemasTableName = commonPrefix + "$schemas";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createSchema(KuduClientWrapper client, String schemaName) {
        if ("default".equals(schemaName)) {
            throw new SchemaAlreadyExistsException(schemaName);
        }
        try {
            KuduTable schemasTable = this.getSchemasTable(client);
            try (KuduSession session = client.newSession();){
                Upsert upsert = schemasTable.newUpsert();
                upsert.getRow().addString(0, schemaName);
                KuduOperationApplier.applyOperationAndVerifySucceeded(session, (Operation)upsert);
            }
        }
        catch (KuduException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, (Throwable)e);
        }
    }

    @Override
    public boolean existsSchema(KuduClientWrapper client, String schemaName) {
        if ("default".equals(schemaName)) {
            return true;
        }
        List<String> schemas = this.listSchemaNames(client);
        return schemas.contains(schemaName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropSchema(KuduClientWrapper client, String schemaName) {
        if ("default".equals(schemaName)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, "Deleting default schema not allowed.");
        }
        try {
            String prefix = this.getPrefixForTablesOfSchema(schemaName);
            for (String name : client.getTablesList(prefix).getTablesList()) {
                client.deleteTable(name);
            }
            KuduTable schemasTable = this.getSchemasTable(client);
            try (KuduSession session = client.newSession();){
                Delete delete = schemasTable.newDelete();
                delete.getRow().addString(0, schemaName);
                KuduOperationApplier.applyOperationAndVerifySucceeded(session, (Operation)delete);
            }
        }
        catch (KuduException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, (Throwable)e);
        }
    }

    @Override
    public List<String> listSchemaNames(KuduClientWrapper client) {
        try {
            if (this.rawSchemasTable == null) {
                if (!client.tableExists(this.rawSchemasTableName)) {
                    this.createAndFillSchemasTable(client);
                }
                this.rawSchemasTable = this.getSchemasTable(client);
            }
            KuduScanner scanner = client.newScannerBuilder(this.rawSchemasTable).build();
            RowResultIterator iterator = scanner.nextRows();
            ArrayList<String> result = new ArrayList<String>();
            while (iterator != null) {
                for (RowResult row : iterator) {
                    result.add(row.getString(0));
                }
                iterator = scanner.nextRows();
            }
            return result;
        }
        catch (KuduException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, (Throwable)e);
        }
    }

    private KuduTable getSchemasTable(KuduClientWrapper client) throws KuduException {
        if (this.rawSchemasTable == null) {
            this.rawSchemasTable = client.openTable(this.rawSchemasTableName);
        }
        return this.rawSchemasTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAndFillSchemasTable(KuduClientWrapper client) throws KuduException {
        List<String> existingSchemaNames = this.listSchemaNamesFromTablets(client);
        ColumnSchema schemaColumnSchema = new ColumnSchema.ColumnSchemaBuilder("schema", Type.STRING).key(true).build();
        Schema schema = new Schema((List)ImmutableList.of((Object)schemaColumnSchema));
        CreateTableOptions options = new CreateTableOptions();
        options.addHashPartitions((List)ImmutableList.of((Object)schemaColumnSchema.getName()), 2);
        KuduTable schemasTable = client.createTable(this.rawSchemasTableName, schema, options);
        try (KuduSession session = client.newSession();){
            for (String schemaName : existingSchemaNames) {
                Insert insert = schemasTable.newInsert();
                insert.getRow().addString(0, schemaName);
                KuduOperationApplier.applyOperationAndVerifySucceeded(session, (Operation)insert);
            }
        }
    }

    private List<String> listSchemaNamesFromTablets(KuduClientWrapper client) throws KuduException {
        List tables = client.getTablesList().getTablesList();
        LinkedHashSet<String> schemas = new LinkedHashSet<String>();
        schemas.add("default");
        for (String table : tables) {
            SchemaTableName schemaTableName = this.fromRawName(table);
            if (schemaTableName == null) continue;
            schemas.add(schemaTableName.getSchemaName());
        }
        return ImmutableList.copyOf(schemas);
    }

    @Override
    public String toRawName(SchemaTableName schemaTableName) {
        if ("default".equals(schemaTableName.getSchemaName())) {
            if (this.commonPrefix.isEmpty()) {
                if (schemaTableName.getTableName().indexOf(46) != -1) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, "Table name conflicts with schema emulation settings. No '.' allowed for tables in schema 'default'.");
                }
            } else if (schemaTableName.getTableName().startsWith(this.commonPrefix)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, "Table name conflicts with schema emulation settings. Table name must not start with '" + this.commonPrefix + "'.");
            }
        } else if (schemaTableName.getSchemaName().indexOf(46) != -1) {
            throw new SchemaNotFoundException(schemaTableName.getSchemaName());
        }
        if ("default".equals(schemaTableName.getSchemaName())) {
            return schemaTableName.getTableName();
        }
        return this.commonPrefix + schemaTableName.getSchemaName() + "." + schemaTableName.getTableName();
    }

    @Override
    public SchemaTableName fromRawName(String rawName) {
        if (this.commonPrefix.isEmpty()) {
            int dotIndex = rawName.indexOf(46);
            if (dotIndex == -1) {
                return new SchemaTableName("default", rawName);
            }
            if (dotIndex == 0 || dotIndex == rawName.length() - 1) {
                return null;
            }
            return new SchemaTableName(rawName.substring(0, dotIndex), rawName.substring(dotIndex + 1));
        }
        if (rawName.startsWith(this.commonPrefix)) {
            int start = this.commonPrefix.length();
            int dotIndex = rawName.indexOf(46, start);
            if (dotIndex == -1 || dotIndex == start || dotIndex == rawName.length() - 1) {
                return null;
            }
            String schema = rawName.substring(start, dotIndex);
            if ("default".equalsIgnoreCase(schema)) {
                return null;
            }
            return new SchemaTableName(schema, rawName.substring(dotIndex + 1));
        }
        return new SchemaTableName("default", rawName);
    }

    @Override
    public String getPrefixForTablesOfSchema(String schemaName) {
        if ("default".equals(schemaName)) {
            return "";
        }
        return this.commonPrefix + schemaName + ".";
    }

    @Override
    public List<String> filterTablesForDefaultSchema(List<String> rawTables) {
        return (List)rawTables.stream().filter(table -> !table.contains(".")).collect(ImmutableList.toImmutableList());
    }
}

