/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduSession;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.OperationResponse;

public final class KuduOperationApplier {
    private KuduOperationApplier() {
    }

    public static OperationResponse applyOperationAndVerifySucceeded(KuduSession kuduSession, Operation operation) throws KuduException {
        OperationResponse operationResponse = kuduSession.apply(operation);
        if (operationResponse != null && operationResponse.hasRowError()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Error while applying kudu operation %s: %s", operation.getChangeType().toString(), operationResponse.getRowError()));
        }
        return operationResponse;
    }
}

