/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.JdkSSLOptions;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.SSLOptions;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.policies.ConstantSpeculativeExecutionPolicy;
import com.datastax.driver.core.policies.DCAwareRoundRobinPolicy;
import com.datastax.driver.core.policies.ExponentialReconnectionPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.datastax.driver.core.policies.RoundRobinPolicy;
import com.datastax.driver.core.policies.SpeculativeExecutionPolicy;
import com.datastax.driver.core.policies.TokenAwarePolicy;
import com.datastax.driver.core.policies.WhiteListPolicy;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import io.airlift.configuration.ConfigBinder;
import io.airlift.json.JsonBinder;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecBinder;
import io.airlift.security.pem.PemReader;
import io.trino.plugin.cassandra.CassandraClientConfig;
import io.trino.plugin.cassandra.CassandraConnector;
import io.trino.plugin.cassandra.CassandraErrorCode;
import io.trino.plugin.cassandra.CassandraMetadata;
import io.trino.plugin.cassandra.CassandraPageSinkProvider;
import io.trino.plugin.cassandra.CassandraPartitionManager;
import io.trino.plugin.cassandra.CassandraRecordSetProvider;
import io.trino.plugin.cassandra.CassandraSession;
import io.trino.plugin.cassandra.CassandraSessionProperties;
import io.trino.plugin.cassandra.CassandraSplitManager;
import io.trino.plugin.cassandra.CassandraTokenSplitManager;
import io.trino.plugin.cassandra.ExtraColumnMetadata;
import io.trino.plugin.cassandra.ReopeningCluster;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeId;
import io.trino.spi.type.TypeManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;

public class CassandraClientModule
implements Module {
    private final TypeManager typeManager;

    public CassandraClientModule(TypeManager typeManager) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public void configure(Binder binder) {
        binder.bind(TypeManager.class).toInstance((Object)this.typeManager);
        binder.bind(CassandraConnector.class).in(Scopes.SINGLETON);
        binder.bind(CassandraMetadata.class).in(Scopes.SINGLETON);
        binder.bind(CassandraSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(CassandraTokenSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(CassandraRecordSetProvider.class).in(Scopes.SINGLETON);
        binder.bind(CassandraPageSinkProvider.class).in(Scopes.SINGLETON);
        binder.bind(CassandraPartitionManager.class).in(Scopes.SINGLETON);
        binder.bind(CassandraSessionProperties.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(CassandraClientConfig.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindListJsonCodec(ExtraColumnMetadata.class);
        JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Type.class).to(TypeDeserializer.class);
    }

    @Singleton
    @Provides
    public static CassandraSession createCassandraSession(CassandraClientConfig config, JsonCodec<List<ExtraColumnMetadata>> extraColumnMetadataCodec) {
        List<String> contactPoints;
        Objects.requireNonNull(config, "config is null");
        Objects.requireNonNull(extraColumnMetadataCodec, "extraColumnMetadataCodec is null");
        Cluster.Builder clusterBuilder = Cluster.builder();
        if (config.getProtocolVersion() != null) {
            clusterBuilder.withProtocolVersion(config.getProtocolVersion());
        }
        Preconditions.checkArgument((!(contactPoints = Objects.requireNonNull(config.getContactPoints(), "contactPoints is null")).isEmpty() ? 1 : 0) != 0, (Object)"empty contactPoints");
        clusterBuilder.withPort(config.getNativeProtocolPort());
        clusterBuilder.withReconnectionPolicy((ReconnectionPolicy)new ExponentialReconnectionPolicy(500L, 10000L));
        clusterBuilder.withRetryPolicy(config.getRetryPolicy().getPolicy());
        RoundRobinPolicy loadPolicy = new RoundRobinPolicy();
        if (config.isUseDCAware()) {
            Objects.requireNonNull(config.getDcAwareLocalDC(), "DCAwarePolicy localDC is null");
            DCAwareRoundRobinPolicy.Builder builder = DCAwareRoundRobinPolicy.builder().withLocalDc(config.getDcAwareLocalDC());
            if (config.getDcAwareUsedHostsPerRemoteDc() > 0) {
                builder.withUsedHostsPerRemoteDc(config.getDcAwareUsedHostsPerRemoteDc().intValue());
                if (config.isDcAwareAllowRemoteDCsForLocal()) {
                    builder.allowRemoteDCsForLocalConsistencyLevel();
                }
            }
            loadPolicy = builder.build();
        }
        if (config.isUseTokenAware()) {
            loadPolicy = new TokenAwarePolicy((LoadBalancingPolicy)loadPolicy, config.isTokenAwareShuffleReplicas());
        }
        if (!config.getAllowedAddresses().isEmpty()) {
            Preconditions.checkArgument((!config.getAllowedAddresses().isEmpty() ? 1 : 0) != 0, (Object)"empty AllowListAddresses");
            ArrayList<InetSocketAddress> allowList = new ArrayList<InetSocketAddress>();
            for (String point : config.getAllowedAddresses()) {
                allowList.add(new InetSocketAddress(point, config.getNativeProtocolPort()));
            }
            loadPolicy = new WhiteListPolicy((LoadBalancingPolicy)loadPolicy, allowList);
        }
        clusterBuilder.withLoadBalancingPolicy((LoadBalancingPolicy)loadPolicy);
        SocketOptions socketOptions = new SocketOptions();
        socketOptions.setReadTimeoutMillis(Math.toIntExact(config.getClientReadTimeout().toMillis()));
        socketOptions.setConnectTimeoutMillis(Math.toIntExact(config.getClientConnectTimeout().toMillis()));
        if (config.getClientSoLinger() != null) {
            socketOptions.setSoLinger(config.getClientSoLinger().intValue());
        }
        if (config.isTlsEnabled()) {
            CassandraClientModule.buildSslContext(config.getKeystorePath(), config.getKeystorePassword(), config.getTruststorePath(), config.getTruststorePassword()).ifPresent(context -> clusterBuilder.withSSL((SSLOptions)JdkSSLOptions.builder().withSSLContext(context).build()));
        }
        clusterBuilder.withSocketOptions(socketOptions);
        if (config.getUsername() != null && config.getPassword() != null) {
            clusterBuilder.withCredentials(config.getUsername(), config.getPassword());
        }
        QueryOptions options = new QueryOptions();
        options.setFetchSize(config.getFetchSize());
        options.setConsistencyLevel(config.getConsistencyLevel());
        clusterBuilder.withQueryOptions(options);
        if (config.getSpeculativeExecutionLimit().isPresent()) {
            clusterBuilder.withSpeculativeExecutionPolicy((SpeculativeExecutionPolicy)new ConstantSpeculativeExecutionPolicy(config.getSpeculativeExecutionDelay().toMillis(), config.getSpeculativeExecutionLimit().get().intValue()));
        }
        return new CassandraSession(extraColumnMetadataCodec, (Cluster)new ReopeningCluster(() -> {
            contactPoints.forEach(arg_0 -> ((Cluster.Builder)clusterBuilder).addContactPoint(arg_0));
            return clusterBuilder.build();
        }), config.getNoHostAvailableRetryTimeout());
    }

    private static Optional<SSLContext> buildSslContext(Optional<File> keystorePath, Optional<String> keystorePassword, Optional<File> truststorePath, Optional<String> truststorePassword) {
        if (keystorePath.isEmpty() && truststorePath.isEmpty()) {
            return Optional.empty();
        }
        try {
            KeyStore keystore = null;
            KeyManager[] keyManagers = null;
            if (keystorePath.isPresent()) {
                char[] keyManagerPassword;
                try {
                    keystore = PemReader.loadKeyStore((File)keystorePath.get(), (File)keystorePath.get(), keystorePassword);
                    keyManagerPassword = new char[]{};
                }
                catch (IOException | GeneralSecurityException ignored) {
                    keyManagerPassword = keystorePassword.map(String::toCharArray).orElse(null);
                    keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                    try (FileInputStream in = new FileInputStream(keystorePath.get());){
                        keystore.load(in, keyManagerPassword);
                    }
                }
                CassandraClientModule.validateCertificates(keystore);
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyManagerFactory.init(keystore, keyManagerPassword);
                keyManagers = keyManagerFactory.getKeyManagers();
            }
            KeyStore truststore = keystore;
            if (truststorePath.isPresent()) {
                truststore = CassandraClientModule.loadTrustStore(truststorePath.get(), truststorePassword);
            }
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(truststore);
            Object[] trustManagers = trustManagerFactory.getTrustManagers();
            if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
                throw new RuntimeException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
            }
            SSLContext result = SSLContext.getInstance("SSL");
            result.init(keyManagers, (TrustManager[])trustManagers, null);
            return Optional.of(result);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new TrinoException((ErrorCodeSupplier)CassandraErrorCode.CASSANDRA_SSL_INITIALIZATION_FAILURE, (Throwable)e);
        }
    }

    private static KeyStore loadTrustStore(File trustStorePath, Optional<String> trustStorePassword) throws IOException, GeneralSecurityException {
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try {
            List certificateChain = PemReader.readCertificateChain((File)trustStorePath);
            if (!certificateChain.isEmpty()) {
                trustStore.load(null, null);
                for (X509Certificate certificate : certificateChain) {
                    X500Principal principal = certificate.getSubjectX500Principal();
                    trustStore.setCertificateEntry(principal.getName(), certificate);
                }
                return trustStore;
            }
        }
        catch (IOException | GeneralSecurityException certificateChain) {
            // empty catch block
        }
        try (FileInputStream in = new FileInputStream(trustStorePath);){
            trustStore.load(in, trustStorePassword.map(String::toCharArray).orElse(null));
        }
        return trustStore;
    }

    private static void validateCertificates(KeyStore keyStore) throws GeneralSecurityException {
        for (String alias : Collections.list(keyStore.aliases())) {
            Certificate certificate;
            if (!keyStore.isKeyEntry(alias) || !((certificate = keyStore.getCertificate(alias)) instanceof X509Certificate)) continue;
            try {
                ((X509Certificate)certificate).checkValidity();
            }
            catch (CertificateExpiredException e) {
                throw new CertificateExpiredException("KeyStore certificate is expired: " + e.getMessage());
            }
            catch (CertificateNotYetValidException e) {
                throw new CertificateNotYetValidException("KeyStore certificate is not yet valid: " + e.getMessage());
            }
        }
    }

    public static final class TypeDeserializer
    extends FromStringDeserializer<Type> {
        private final TypeManager typeManager;

        @Inject
        public TypeDeserializer(TypeManager typeManager) {
            super(Type.class);
            this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        }

        protected Type _deserialize(String value, DeserializationContext context) {
            return this.typeManager.getType(TypeId.of((String)value));
        }
    }
}

