/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra;

import com.datastax.driver.core.VersionNumber;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.trino.plugin.cassandra.CassandraColumnHandle;
import io.trino.plugin.cassandra.CassandraType;
import io.trino.plugin.cassandra.util.CassandraCqlUtils;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class CassandraClusteringPredicatesExtractor {
    private final ClusteringPushDownResult clusteringPushDownResult;
    private final TupleDomain<ColumnHandle> predicates;

    public CassandraClusteringPredicatesExtractor(List<CassandraColumnHandle> clusteringColumns, TupleDomain<ColumnHandle> predicates, VersionNumber cassandraVersion) {
        this.predicates = Objects.requireNonNull(predicates, "predicates is null");
        this.clusteringPushDownResult = CassandraClusteringPredicatesExtractor.getClusteringKeysSet(clusteringColumns, predicates, Objects.requireNonNull(cassandraVersion, "cassandraVersion is null"));
    }

    public String getClusteringKeyPredicates() {
        return this.clusteringPushDownResult.getDomainQuery();
    }

    public TupleDomain<ColumnHandle> getUnenforcedConstraints() {
        return this.predicates.filter((columnHandle, domain) -> !this.clusteringPushDownResult.hasBeenFullyPushed((ColumnHandle)columnHandle));
    }

    private static ClusteringPushDownResult getClusteringKeysSet(List<CassandraColumnHandle> clusteringColumns, TupleDomain<ColumnHandle> predicates, VersionNumber cassandraVersion) {
        ImmutableSet.Builder fullyPushedColumnPredicates = ImmutableSet.builder();
        ImmutableList.Builder clusteringColumnSql = ImmutableList.builder();
        int allProcessedClusteringColumns = 0;
        for (CassandraColumnHandle columnHandle : clusteringColumns) {
            Domain domain = (Domain)((Map)predicates.getDomains().get()).get(columnHandle);
            if (domain == null || domain.isNullAllowed()) break;
            int currentlyProcessedClusteringColumn = allProcessedClusteringColumns++;
            String predicateString = (String)domain.getValues().getValuesProcessor().transform(ranges -> {
                if (ranges.getRangeCount() == 1) {
                    fullyPushedColumnPredicates.add((Object)columnHandle);
                    return CassandraClusteringPredicatesExtractor.translateRangeIntoCql(columnHandle, (Range)Iterables.getOnlyElement((Iterable)ranges.getOrderedRanges()));
                }
                if (ranges.getOrderedRanges().stream().allMatch(Range::isSingleValue)) {
                    if (CassandraClusteringPredicatesExtractor.isInExpressionNotAllowed(clusteringColumns, cassandraVersion, currentlyProcessedClusteringColumn)) {
                        return CassandraClusteringPredicatesExtractor.translateRangeIntoCql(columnHandle, ranges.getSpan());
                    }
                    String inValues = ranges.getOrderedRanges().stream().map(range -> CassandraClusteringPredicatesExtractor.toCqlLiteral(columnHandle, range.getSingleValue())).collect(Collectors.joining(","));
                    fullyPushedColumnPredicates.add((Object)columnHandle);
                    return CassandraCqlUtils.validColumnName(columnHandle.getName()) + " IN (" + inValues + ")";
                }
                return CassandraClusteringPredicatesExtractor.translateRangeIntoCql(columnHandle, ranges.getSpan());
            }, discreteValues -> {
                if (discreteValues.isInclusive()) {
                    if (discreteValues.getValuesCount() == 0) {
                        return null;
                    }
                    if (discreteValues.getValuesCount() == 1) {
                        fullyPushedColumnPredicates.add((Object)columnHandle);
                        return String.format("%s = %s", CassandraCqlUtils.validColumnName(columnHandle.getName()), CassandraClusteringPredicatesExtractor.toCqlLiteral(columnHandle, Iterables.getOnlyElement((Iterable)discreteValues.getValues())));
                    }
                    if (CassandraClusteringPredicatesExtractor.isInExpressionNotAllowed(clusteringColumns, cassandraVersion, currentlyProcessedClusteringColumn)) {
                        return null;
                    }
                    String inValues = discreteValues.getValues().stream().map(columnHandle.getCassandraType()::toCqlLiteral).collect(Collectors.joining(","));
                    fullyPushedColumnPredicates.add((Object)columnHandle);
                    return CassandraCqlUtils.validColumnName(columnHandle.getName()) + " IN (" + inValues + " )";
                }
                return null;
            }, allOrNone -> null);
            if (predicateString == null) break;
            clusteringColumnSql.add((Object)predicateString);
            if (predicateString.contains(">") || predicateString.contains("<")) break;
        }
        ImmutableList clusteringColumnPredicates = clusteringColumnSql.build();
        return new ClusteringPushDownResult((Set<ColumnHandle>)fullyPushedColumnPredicates.build(), Joiner.on((String)" AND ").join((Iterable)clusteringColumnPredicates));
    }

    private static boolean isInExpressionNotAllowed(List<CassandraColumnHandle> clusteringColumns, VersionNumber cassandraVersion, int currentlyProcessedClusteringColumn) {
        return cassandraVersion.compareTo(VersionNumber.parse((String)"2.2.0")) < 0 && currentlyProcessedClusteringColumn != clusteringColumns.size() - 1;
    }

    private static String toCqlLiteral(CassandraColumnHandle columnHandle, Object value) {
        return columnHandle.getCassandraType().toCqlLiteral(value);
    }

    private static String translateRangeIntoCql(CassandraColumnHandle columnHandle, Range range) {
        if (columnHandle.getCassandraType().getKind() == CassandraType.Kind.TUPLE || columnHandle.getCassandraType().getKind() == CassandraType.Kind.UDT) {
            return null;
        }
        if (range.isAll()) {
            return null;
        }
        if (range.isSingleValue()) {
            return String.format("%s = %s", CassandraCqlUtils.validColumnName(columnHandle.getName()), CassandraClusteringPredicatesExtractor.toCqlLiteral(columnHandle, range.getSingleValue()));
        }
        String lowerBoundPredicate = null;
        String upperBoundPredicate = null;
        if (!range.isLowUnbounded()) {
            String lowBound = CassandraClusteringPredicatesExtractor.toCqlLiteral(columnHandle, range.getLowBoundedValue());
            lowerBoundPredicate = String.format("%s %s %s", CassandraCqlUtils.validColumnName(columnHandle.getName()), range.isLowInclusive() ? ">=" : ">", lowBound);
        }
        if (!range.isHighUnbounded()) {
            String highBound = CassandraClusteringPredicatesExtractor.toCqlLiteral(columnHandle, range.getHighBoundedValue());
            upperBoundPredicate = String.format("%s %s %s", CassandraCqlUtils.validColumnName(columnHandle.getName()), range.isHighInclusive() ? "<=" : "<", highBound);
        }
        if (lowerBoundPredicate != null && upperBoundPredicate != null) {
            return String.format("%s AND %s ", lowerBoundPredicate, upperBoundPredicate);
        }
        if (lowerBoundPredicate != null) {
            return lowerBoundPredicate;
        }
        return upperBoundPredicate;
    }

    private static class ClusteringPushDownResult {
        private final Set<ColumnHandle> fullyPushedColumnPredicates;
        private final String domainQuery;

        public ClusteringPushDownResult(Set<ColumnHandle> fullyPushedColumnPredicates, String domainQuery) {
            this.fullyPushedColumnPredicates = ImmutableSet.copyOf((Collection)Objects.requireNonNull(fullyPushedColumnPredicates, "fullyPushedColumnPredicates is null"));
            this.domainQuery = Objects.requireNonNull(domainQuery);
        }

        public boolean hasBeenFullyPushed(ColumnHandle column) {
            return this.fullyPushedColumnPredicates.contains(column);
        }

        public String getDomainQuery() {
            return this.domainQuery;
        }
    }
}

