/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra;

import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.json.JsonModule;
import io.trino.plugin.base.jmx.MBeanServerModule;
import io.trino.plugin.cassandra.CassandraClientModule;
import io.trino.plugin.cassandra.CassandraConnector;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import java.util.Map;
import java.util.Objects;
import org.weakref.jmx.guice.MBeanModule;

public class CassandraConnectorFactory
implements ConnectorFactory {
    public String getName() {
        return "cassandra";
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        Objects.requireNonNull(config, "config is null");
        Bootstrap app = new Bootstrap(new Module[]{new MBeanModule(), new JsonModule(), new CassandraClientModule(context.getTypeManager()), new MBeanServerModule()});
        Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
        return (Connector)injector.getInstance(CassandraConnector.class);
    }
}

