/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.LocalDate;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Shorts;
import com.google.common.primitives.SignedBytes;
import io.airlift.slice.Slice;
import io.trino.plugin.cassandra.CassandraSession;
import io.trino.plugin.cassandra.util.CassandraCqlUtils;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.UuidType;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class CassandraPageSink
implements ConnectorPageSink {
    private static final DateTimeFormatter DATE_FORMATTER = ISODateTimeFormat.date().withZoneUTC();
    private final CassandraSession cassandraSession;
    private final PreparedStatement insert;
    private final List<Type> columnTypes;
    private final boolean generateUuid;
    private final int batchSize;
    private final Function<Long, Object> toCassandraDate;
    private final BatchStatement batchStatement = new BatchStatement();

    public CassandraPageSink(CassandraSession cassandraSession, ProtocolVersion protocolVersion, String schemaName, String tableName, List<String> columnNames, List<Type> columnTypes, boolean generateUuid, int batchSize) {
        this.cassandraSession = Objects.requireNonNull(cassandraSession, "cassandraSession");
        Objects.requireNonNull(schemaName, "schemaName is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(columnNames, "columnNames is null");
        this.columnTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnTypes, "columnTypes is null"));
        this.generateUuid = generateUuid;
        this.batchSize = batchSize;
        this.toCassandraDate = protocolVersion.toInt() <= ProtocolVersion.V3.toInt() ? value -> DATE_FORMATTER.print(TimeUnit.DAYS.toMillis((long)value)) : value -> LocalDate.fromDaysSinceEpoch((int)Math.toIntExact(value));
        Insert insert = QueryBuilder.insertInto((String)CassandraCqlUtils.validSchemaName(schemaName), (String)CassandraCqlUtils.validTableName(tableName));
        if (generateUuid) {
            insert.value("id", (Object)QueryBuilder.bindMarker());
        }
        for (int i = 0; i < columnNames.size(); ++i) {
            String columnName = columnNames.get(i);
            Preconditions.checkArgument((columnName != null ? 1 : 0) != 0, (String)"columnName is null at position: %s", (int)i);
            insert.value(CassandraCqlUtils.validColumnName(columnName), (Object)QueryBuilder.bindMarker());
        }
        this.insert = cassandraSession.prepare((RegularStatement)insert);
    }

    public CompletableFuture<?> appendPage(Page page) {
        for (int position = 0; position < page.getPositionCount(); ++position) {
            ArrayList<Object> values = new ArrayList<Object>(this.columnTypes.size() + 1);
            if (this.generateUuid) {
                values.add(UUID.randomUUID());
            }
            for (int channel = 0; channel < page.getChannelCount(); ++channel) {
                this.appendColumn(values, page, position, channel);
            }
            this.batchStatement.add((Statement)this.insert.bind(values.toArray()));
            if (this.batchStatement.size() < this.batchSize) continue;
            this.cassandraSession.execute((Statement)this.batchStatement);
            this.batchStatement.clear();
        }
        return NOT_BLOCKED;
    }

    private void appendColumn(List<Object> values, Page page, int position, int channel) {
        Block block = page.getBlock(channel);
        Type type = this.columnTypes.get(channel);
        if (block.isNull(position)) {
            values.add(null);
        } else if (BooleanType.BOOLEAN.equals((Object)type)) {
            values.add(type.getBoolean(block, position));
        } else if (BigintType.BIGINT.equals((Object)type)) {
            values.add(type.getLong(block, position));
        } else if (IntegerType.INTEGER.equals((Object)type)) {
            values.add(Math.toIntExact(type.getLong(block, position)));
        } else if (SmallintType.SMALLINT.equals((Object)type)) {
            values.add(Shorts.checkedCast((long)type.getLong(block, position)));
        } else if (TinyintType.TINYINT.equals((Object)type)) {
            values.add(SignedBytes.checkedCast((long)type.getLong(block, position)));
        } else if (DoubleType.DOUBLE.equals((Object)type)) {
            values.add(type.getDouble(block, position));
        } else if (RealType.REAL.equals((Object)type)) {
            values.add(Float.valueOf(Float.intBitsToFloat(Math.toIntExact(type.getLong(block, position)))));
        } else if (DateType.DATE.equals((Object)type)) {
            values.add(this.toCassandraDate.apply(type.getLong(block, position)));
        } else if (TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS.equals((Object)type)) {
            values.add(new Timestamp(DateTimeEncoding.unpackMillisUtc((long)type.getLong(block, position))));
        } else if (type instanceof VarcharType) {
            values.add(type.getSlice(block, position).toStringUtf8());
        } else if (VarbinaryType.VARBINARY.equals((Object)type)) {
            values.add(type.getSlice(block, position).toByteBuffer());
        } else if (UuidType.UUID.equals((Object)type)) {
            values.add(UuidType.trinoUuidToJavaUuid((Slice)type.getSlice(block, position)));
        } else {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported column type: " + type.getDisplayName());
        }
    }

    public CompletableFuture<Collection<Slice>> finish() {
        if (this.batchStatement.size() > 0) {
            this.cassandraSession.execute((Statement)this.batchStatement);
            this.batchStatement.clear();
        }
        return CompletableFuture.completedFuture(ImmutableList.of());
    }

    public void abort() {
    }
}

