/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra;

import com.google.common.base.Preconditions;
import io.trino.plugin.cassandra.CassandraClientConfig;
import io.trino.plugin.cassandra.CassandraInsertTableHandle;
import io.trino.plugin.cassandra.CassandraOutputTableHandle;
import io.trino.plugin.cassandra.CassandraPageSink;
import io.trino.plugin.cassandra.CassandraSession;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTransactionHandle;
import java.util.Objects;
import javax.inject.Inject;

public class CassandraPageSinkProvider
implements ConnectorPageSinkProvider {
    private final CassandraSession cassandraSession;
    private final int batchSize;

    @Inject
    public CassandraPageSinkProvider(CassandraSession cassandraSession, CassandraClientConfig cassandraClientConfig) {
        this.cassandraSession = Objects.requireNonNull(cassandraSession, "cassandraSession is null");
        this.batchSize = Objects.requireNonNull(cassandraClientConfig, "cassandraClientConfig is null").getBatchSize();
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorOutputTableHandle tableHandle) {
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof CassandraOutputTableHandle), (Object)"tableHandle is not an instance of CassandraOutputTableHandle");
        CassandraOutputTableHandle handle = (CassandraOutputTableHandle)tableHandle;
        return new CassandraPageSink(this.cassandraSession, this.cassandraSession.getProtocolVersion(), handle.getSchemaName(), handle.getTableName(), handle.getColumnNames(), handle.getColumnTypes(), true, this.batchSize);
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorInsertTableHandle tableHandle) {
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof CassandraInsertTableHandle), (Object)"tableHandle is not an instance of ConnectorInsertTableHandle");
        CassandraInsertTableHandle handle = (CassandraInsertTableHandle)tableHandle;
        return new CassandraPageSink(this.cassandraSession, this.cassandraSession.getProtocolVersion(), handle.getSchemaName(), handle.getTableName(), handle.getColumnNames(), handle.getColumnTypes(), handle.isGenerateUuid(), this.batchSize);
    }
}

