/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.cassandra.CassandraColumnHandle;
import io.trino.plugin.cassandra.CassandraRecordCursor;
import io.trino.plugin.cassandra.CassandraSession;
import io.trino.plugin.cassandra.CassandraType;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.RecordSet;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CassandraRecordSet
implements RecordSet {
    private final CassandraSession cassandraSession;
    private final String cql;
    private final List<CassandraType> cassandraTypes;
    private final List<Type> columnTypes;

    public CassandraRecordSet(CassandraSession cassandraSession, String cql, List<CassandraColumnHandle> cassandraColumns) {
        this.cassandraSession = Objects.requireNonNull(cassandraSession, "cassandraSession is null");
        this.cql = Objects.requireNonNull(cql, "cql is null");
        Objects.requireNonNull(cassandraColumns, "cassandraColumns is null");
        this.cassandraTypes = CassandraRecordSet.transformList(cassandraColumns, CassandraColumnHandle::getCassandraType);
        this.columnTypes = CassandraRecordSet.transformList(cassandraColumns, CassandraColumnHandle::getType);
    }

    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    public RecordCursor cursor() {
        return new CassandraRecordCursor(this.cassandraSession, this.cassandraTypes, this.cql);
    }

    private static <T, R> List<R> transformList(List<T> list, Function<T, R> function) {
        return ImmutableList.copyOf((Collection)list.stream().map(function).collect(Collectors.toList()));
    }
}

