/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra;

import io.airlift.log.Logger;
import io.trino.plugin.cassandra.CassandraColumnHandle;
import io.trino.plugin.cassandra.CassandraRecordSet;
import io.trino.plugin.cassandra.CassandraSession;
import io.trino.plugin.cassandra.CassandraSplit;
import io.trino.plugin.cassandra.CassandraTableHandle;
import io.trino.plugin.cassandra.util.CassandraCqlUtils;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorRecordSetProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.RecordSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class CassandraRecordSetProvider
implements ConnectorRecordSetProvider {
    private static final Logger log = Logger.get(CassandraRecordSetProvider.class);
    private final CassandraSession cassandraSession;

    @Inject
    public CassandraRecordSetProvider(CassandraSession cassandraSession) {
        this.cassandraSession = Objects.requireNonNull(cassandraSession, "cassandraSession is null");
    }

    public RecordSet getRecordSet(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<? extends ColumnHandle> columns) {
        CassandraSplit cassandraSplit = (CassandraSplit)split;
        CassandraTableHandle cassandraTable = (CassandraTableHandle)table;
        List<CassandraColumnHandle> cassandraColumns = columns.stream().map(column -> (CassandraColumnHandle)column).collect(Collectors.toList());
        String selectCql = CassandraCqlUtils.selectFrom(cassandraTable, cassandraColumns).getQueryString();
        StringBuilder sb = new StringBuilder(selectCql);
        if (sb.charAt(sb.length() - 1) == ';') {
            sb.setLength(sb.length() - 1);
        }
        sb.append(cassandraSplit.getWhereClause());
        String cql = sb.toString();
        log.debug("Creating record set: %s", new Object[]{cql});
        return new CassandraRecordSet(this.cassandraSession, cql, cassandraColumns);
    }
}

