/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.SizeOf;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ConnectorSplit;
import java.util.List;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class CassandraSplit
implements ConnectorSplit {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(CassandraSplit.class).instanceSize();
    private final String partitionId;
    private final List<HostAddress> addresses;
    private final String splitCondition;

    @JsonCreator
    public CassandraSplit(@JsonProperty(value="partitionId") String partitionId, @JsonProperty(value="splitCondition") String splitCondition, @JsonProperty(value="addresses") List<HostAddress> addresses) {
        Objects.requireNonNull(partitionId, "partitionId is null");
        Objects.requireNonNull(addresses, "addresses is null");
        this.partitionId = partitionId;
        this.addresses = ImmutableList.copyOf(addresses);
        this.splitCondition = splitCondition;
    }

    @JsonProperty
    public String getSplitCondition() {
        return this.splitCondition;
    }

    @JsonProperty
    public String getPartitionId() {
        return this.partitionId;
    }

    @JsonProperty
    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    public boolean isRemotelyAccessible() {
        return true;
    }

    public Object getInfo() {
        return ImmutableMap.builder().put((Object)"hosts", this.addresses).put((Object)"partitionId", (Object)this.partitionId).buildOrThrow();
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.partitionId) + SizeOf.estimatedSizeOf(this.addresses, HostAddress::getRetainedSizeInBytes) + SizeOf.estimatedSizeOf((String)this.splitCondition);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.partitionId).toString();
    }

    public String getWhereClause() {
        if (this.partitionId.equals("<UNPARTITIONED>")) {
            if (this.splitCondition != null) {
                return " WHERE " + this.splitCondition;
            }
            return "";
        }
        if (this.splitCondition != null) {
            return " WHERE " + this.partitionId + " AND " + this.splitCondition;
        }
        return " WHERE " + this.partitionId;
    }
}

