/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra;

import com.datastax.driver.core.Host;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.log.Logger;
import io.trino.plugin.cassandra.CassandraClientConfig;
import io.trino.plugin.cassandra.CassandraClusteringPredicatesExtractor;
import io.trino.plugin.cassandra.CassandraPartition;
import io.trino.plugin.cassandra.CassandraPartitionManager;
import io.trino.plugin.cassandra.CassandraPartitionResult;
import io.trino.plugin.cassandra.CassandraSession;
import io.trino.plugin.cassandra.CassandraSessionProperties;
import io.trino.plugin.cassandra.CassandraSplit;
import io.trino.plugin.cassandra.CassandraTable;
import io.trino.plugin.cassandra.CassandraTableHandle;
import io.trino.plugin.cassandra.CassandraTokenSplitManager;
import io.trino.plugin.cassandra.util.HostAddressFactory;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedSplitSource;
import io.trino.spi.predicate.TupleDomain;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;

public class CassandraSplitManager
implements ConnectorSplitManager {
    private static final Logger log = Logger.get(CassandraSplitManager.class);
    private final CassandraSession cassandraSession;
    private final int partitionSizeForBatchSelect;
    private final CassandraTokenSplitManager tokenSplitMgr;
    private final CassandraPartitionManager partitionManager;

    @Inject
    public CassandraSplitManager(CassandraClientConfig cassandraClientConfig, CassandraSession cassandraSession, CassandraTokenSplitManager tokenSplitMgr, CassandraPartitionManager partitionManager) {
        this.cassandraSession = Objects.requireNonNull(cassandraSession, "cassandraSession is null");
        this.partitionSizeForBatchSelect = cassandraClientConfig.getPartitionSizeForBatchSelect();
        this.tokenSplitMgr = tokenSplitMgr;
        this.partitionManager = Objects.requireNonNull(partitionManager, "partitionManager is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle tableHandle, ConnectorSplitManager.SplitSchedulingStrategy splitSchedulingStrategy, DynamicFilter dynamicFilter) {
        CassandraPartition cassandraPartition;
        String clusteringKeyPredicates;
        List<CassandraPartition> partitions;
        CassandraTableHandle cassandraTableHandle = (CassandraTableHandle)tableHandle;
        if (cassandraTableHandle.getPartitions().isPresent()) {
            partitions = cassandraTableHandle.getPartitions().get();
            clusteringKeyPredicates = cassandraTableHandle.getClusteringKeyPredicates();
        } else {
            CassandraPartitionResult partitionResult = this.partitionManager.getPartitions(cassandraTableHandle, (TupleDomain<ColumnHandle>)TupleDomain.all());
            partitions = partitionResult.getPartitions();
            clusteringKeyPredicates = CassandraSplitManager.extractClusteringKeyPredicates(partitionResult, cassandraTableHandle, this.cassandraSession);
        }
        if (partitions.isEmpty()) {
            log.debug("No partitions matched predicates for table %s", new Object[]{tableHandle});
            return new FixedSplitSource((Iterable)ImmutableList.of());
        }
        if (partitions.size() == 1 && ((cassandraPartition = partitions.get(0)).isUnpartitioned() || cassandraPartition.isIndexedColumnPredicatePushdown())) {
            CassandraTable table = this.cassandraSession.getTable(cassandraTableHandle.getSchemaTableName());
            List<ConnectorSplit> splits = this.getSplitsByTokenRange(table, cassandraPartition.getPartitionId(), CassandraSessionProperties.getSplitsPerNode(session));
            log.debug("One partition matched predicates for table %s, creating %s splits by token ranges", new Object[]{tableHandle, splits.size()});
            return new FixedSplitSource(splits);
        }
        List<ConnectorSplit> splits = this.getSplitsForPartitions(cassandraTableHandle, partitions, clusteringKeyPredicates);
        log.debug("%s partitions matched predicates for table %s, creating %s splits", new Object[]{partitions.size(), tableHandle, splits.size()});
        return new FixedSplitSource(splits);
    }

    private static String extractClusteringKeyPredicates(CassandraPartitionResult partitionResult, CassandraTableHandle tableHandle, CassandraSession session) {
        if (partitionResult.isUnpartitioned()) {
            return "";
        }
        CassandraClusteringPredicatesExtractor clusteringPredicatesExtractor = new CassandraClusteringPredicatesExtractor(session.getTable(tableHandle.getSchemaTableName()).getClusteringKeyColumns(), partitionResult.getUnenforcedConstraint(), session.getCassandraVersion());
        return clusteringPredicatesExtractor.getClusteringKeyPredicates();
    }

    private List<ConnectorSplit> getSplitsByTokenRange(CassandraTable table, String partitionId, Optional<Long> sessionSplitsPerNode) {
        String schema = table.getTableHandle().getSchemaName();
        String tableName = table.getTableHandle().getTableName();
        String tokenExpression = table.getTokenExpression();
        ImmutableList.Builder builder = ImmutableList.builder();
        List<CassandraTokenSplitManager.TokenSplit> tokenSplits = this.tokenSplitMgr.getSplits(schema, tableName, sessionSplitsPerNode);
        for (CassandraTokenSplitManager.TokenSplit tokenSplit : tokenSplits) {
            String condition = CassandraSplitManager.buildTokenCondition(tokenExpression, tokenSplit.getStartToken(), tokenSplit.getEndToken());
            List<HostAddress> addresses = new HostAddressFactory().hostAddressNamesToHostAddressList(tokenSplit.getHosts());
            CassandraSplit split = new CassandraSplit(partitionId, condition, addresses);
            builder.add((Object)split);
        }
        return builder.build();
    }

    private static String buildTokenCondition(String tokenExpression, String startToken, String endToken) {
        return tokenExpression + " > " + startToken + " AND " + tokenExpression + " <= " + endToken;
    }

    private List<ConnectorSplit> getSplitsForPartitions(CassandraTableHandle cassTableHandle, List<CassandraPartition> partitions, String clusteringPredicates) {
        String schema = cassTableHandle.getSchemaName();
        HostAddressFactory hostAddressFactory = new HostAddressFactory();
        ImmutableList.Builder builder = ImmutableList.builder();
        boolean singlePartitionKeyColumn = true;
        String partitionKeyColumnName = null;
        if (!partitions.isEmpty()) {
            boolean bl = singlePartitionKeyColumn = ((Map)partitions.get(0).getTupleDomain().getDomains().get()).size() == 1;
            if (singlePartitionKeyColumn) {
                String partitionId = partitions.get(0).getPartitionId();
                partitionKeyColumnName = partitionId.substring(0, partitionId.lastIndexOf(61) - 1);
            }
        }
        HashMap hostsToPartitionKeys = new HashMap();
        HashMap<ImmutableSet, List<HostAddress>> hostMap = new HashMap<ImmutableSet, List<HostAddress>>();
        for (CassandraPartition cassandraPartition : partitions) {
            Set<Host> hosts = this.cassandraSession.getReplicas(schema, cassandraPartition.getKeyAsByteBuffer());
            List<HostAddress> addresses = hostAddressFactory.toHostAddressList(hosts);
            if (singlePartitionKeyColumn) {
                ImmutableSet.Builder sb = ImmutableSet.builder();
                for (HostAddress address : addresses) {
                    sb.add((Object)address.getHostText());
                }
                ImmutableSet hostAddresses = sb.build();
                HashSet<String> values = (HashSet<String>)hostsToPartitionKeys.get(hostAddresses);
                if (values == null) {
                    values = new HashSet<String>();
                }
                String partitionId = cassandraPartition.getPartitionId();
                values.add(partitionId.substring(partitionId.lastIndexOf(61) + 2));
                hostsToPartitionKeys.put(hostAddresses, values);
                hostMap.put(hostAddresses, addresses);
                continue;
            }
            builder.add((Object)this.createSplitForClusteringPredicates(cassandraPartition.getPartitionId(), addresses, clusteringPredicates));
        }
        if (singlePartitionKeyColumn) {
            for (Map.Entry entry : hostsToPartitionKeys.entrySet()) {
                StringBuilder sb = new StringBuilder(this.partitionSizeForBatchSelect);
                int size = 0;
                for (String value : (Set)entry.getValue()) {
                    if (size > 0) {
                        sb.append(",");
                    }
                    sb.append(value);
                    if (++size <= this.partitionSizeForBatchSelect) continue;
                    String partitionId = String.format("%s in (%s)", partitionKeyColumnName, sb);
                    builder.add((Object)this.createSplitForClusteringPredicates(partitionId, (List)hostMap.get(entry.getKey()), clusteringPredicates));
                    size = 0;
                    sb.setLength(0);
                    sb.trimToSize();
                }
                if (size <= 0) continue;
                String partitionId = String.format("%s in (%s)", partitionKeyColumnName, sb);
                builder.add((Object)this.createSplitForClusteringPredicates(partitionId, (List)hostMap.get(entry.getKey()), clusteringPredicates));
            }
        }
        return builder.build();
    }

    private CassandraSplit createSplitForClusteringPredicates(String partitionId, List<HostAddress> hosts, String clusteringPredicates) {
        if (clusteringPredicates.isEmpty()) {
            return new CassandraSplit(partitionId, null, hosts);
        }
        return new CassandraSplit(partitionId, clusteringPredicates, hosts);
    }
}

