/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.GettableByIndexData;
import com.datastax.driver.core.LocalDate;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.utils.Bytes;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.net.InetAddresses;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.cassandra.CassandraTypes;
import io.trino.plugin.cassandra.util.CassandraCqlUtils;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.block.SingleRowBlockWriter;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeUtils;
import io.trino.spi.type.UuidType;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;

public class CassandraType {
    private final Kind kind;
    private final Type trinoType;
    private final List<CassandraType> argumentTypes;

    public CassandraType(Kind kind, Type trinoType) {
        this(kind, trinoType, (List<CassandraType>)ImmutableList.of());
    }

    @JsonCreator
    public CassandraType(@JsonProperty(value="kind") Kind kind, @JsonProperty(value="trinoType") Type trinoType, @JsonProperty(value="argumentTypes") List<CassandraType> argumentTypes) {
        this.kind = Objects.requireNonNull(kind, "kind is null");
        this.trinoType = Objects.requireNonNull(trinoType, "trinoType is null");
        this.argumentTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentTypes, "argumentTypes is null"));
    }

    @JsonProperty
    public Kind getKind() {
        return this.kind;
    }

    @JsonProperty
    public Type getTrinoType() {
        return this.trinoType;
    }

    @JsonProperty
    public List<CassandraType> getArgumentTypes() {
        return this.argumentTypes;
    }

    public String getName() {
        return this.kind.name();
    }

    public static Optional<CassandraType> toCassandraType(DataType dataType) {
        switch (dataType.getName()) {
            case ASCII: {
                return Optional.of(CassandraTypes.ASCII);
            }
            case BIGINT: {
                return Optional.of(CassandraTypes.BIGINT);
            }
            case BLOB: {
                return Optional.of(CassandraTypes.BLOB);
            }
            case BOOLEAN: {
                return Optional.of(CassandraTypes.BOOLEAN);
            }
            case COUNTER: {
                return Optional.of(CassandraTypes.COUNTER);
            }
            case CUSTOM: {
                return Optional.of(CassandraTypes.CUSTOM);
            }
            case DATE: {
                return Optional.of(CassandraTypes.DATE);
            }
            case DECIMAL: {
                return Optional.of(CassandraTypes.DECIMAL);
            }
            case DOUBLE: {
                return Optional.of(CassandraTypes.DOUBLE);
            }
            case FLOAT: {
                return Optional.of(CassandraTypes.FLOAT);
            }
            case INET: {
                return Optional.of(CassandraTypes.INET);
            }
            case INT: {
                return Optional.of(CassandraTypes.INT);
            }
            case LIST: {
                return Optional.of(CassandraTypes.LIST);
            }
            case MAP: {
                return Optional.of(CassandraTypes.MAP);
            }
            case SET: {
                return Optional.of(CassandraTypes.SET);
            }
            case SMALLINT: {
                return Optional.of(CassandraTypes.SMALLINT);
            }
            case TEXT: {
                return Optional.of(CassandraTypes.TEXT);
            }
            case TIMESTAMP: {
                return Optional.of(CassandraTypes.TIMESTAMP);
            }
            case TIMEUUID: {
                return Optional.of(CassandraTypes.TIMEUUID);
            }
            case TINYINT: {
                return Optional.of(CassandraTypes.TINYINT);
            }
            case TUPLE: {
                return CassandraType.createTypeForTuple(dataType);
            }
            case UDT: {
                return CassandraType.createTypeForUserType(dataType);
            }
            case UUID: {
                return Optional.of(CassandraTypes.UUID);
            }
            case VARCHAR: {
                return Optional.of(CassandraTypes.VARCHAR);
            }
            case VARINT: {
                return Optional.of(CassandraTypes.VARINT);
            }
        }
        return Optional.empty();
    }

    private static Optional<CassandraType> createTypeForTuple(DataType dataType) {
        TupleType tupleType = (TupleType)dataType;
        List argumentTypesOptionals = (List)tupleType.getComponentTypes().stream().map(CassandraType::toCassandraType).collect(ImmutableList.toImmutableList());
        if (argumentTypesOptionals.stream().anyMatch(Optional::isEmpty)) {
            return Optional.empty();
        }
        List argumentTypes = (List)argumentTypesOptionals.stream().map(Optional::get).collect(ImmutableList.toImmutableList());
        RowType trinoType = RowType.anonymous((List)((List)argumentTypes.stream().map(CassandraType::getTrinoType).collect(ImmutableList.toImmutableList())));
        return Optional.of(new CassandraType(Kind.TUPLE, (Type)trinoType, argumentTypes));
    }

    private static Optional<CassandraType> createTypeForUserType(DataType dataType) {
        UserType userType = (UserType)dataType;
        ImmutableMap.Builder argumentTypes = ImmutableMap.builder();
        for (UserType.Field field2 : userType) {
            Optional<CassandraType> cassandraType = CassandraType.toCassandraType(field2.getType());
            if (cassandraType.isEmpty()) {
                return Optional.empty();
            }
            argumentTypes.put((Object)field2.getName(), (Object)cassandraType.get());
        }
        RowType trinoType = RowType.from((List)((List)argumentTypes.buildOrThrow().entrySet().stream().map(field -> new RowType.Field(Optional.of((String)field.getKey()), ((CassandraType)field.getValue()).getTrinoType())).collect(ImmutableList.toImmutableList())));
        return Optional.of(new CassandraType(Kind.UDT, (Type)trinoType, (List)argumentTypes.buildOrThrow().values().stream().collect(ImmutableList.toImmutableList())));
    }

    public NullableValue getColumnValue(Row row, int position) {
        return this.getColumnValue((GettableByIndexData)row, position, () -> row.getColumnDefinitions().getType(position));
    }

    public NullableValue getColumnValue(GettableByIndexData row, int position, Supplier<DataType> dataTypeSupplier) {
        if (row.isNull(position)) {
            return NullableValue.asNull((Type)this.trinoType);
        }
        switch (this.kind) {
            case ASCII: 
            case TEXT: 
            case VARCHAR: {
                return NullableValue.of((Type)this.trinoType, (Object)Slices.utf8Slice((String)row.getString(position)));
            }
            case INT: {
                return NullableValue.of((Type)this.trinoType, (Object)row.getInt(position));
            }
            case SMALLINT: {
                return NullableValue.of((Type)this.trinoType, (Object)row.getShort(position));
            }
            case TINYINT: {
                return NullableValue.of((Type)this.trinoType, (Object)row.getByte(position));
            }
            case BIGINT: 
            case COUNTER: {
                return NullableValue.of((Type)this.trinoType, (Object)row.getLong(position));
            }
            case BOOLEAN: {
                return NullableValue.of((Type)this.trinoType, (Object)row.getBool(position));
            }
            case DOUBLE: {
                return NullableValue.of((Type)this.trinoType, (Object)row.getDouble(position));
            }
            case FLOAT: {
                return NullableValue.of((Type)this.trinoType, (Object)Float.floatToRawIntBits(row.getFloat(position)));
            }
            case DECIMAL: {
                return NullableValue.of((Type)this.trinoType, (Object)row.getDecimal(position).doubleValue());
            }
            case UUID: 
            case TIMEUUID: {
                return NullableValue.of((Type)this.trinoType, (Object)UuidType.javaUuidToTrinoUuid((UUID)row.getUUID(position)));
            }
            case TIMESTAMP: {
                return NullableValue.of((Type)this.trinoType, (Object)DateTimeEncoding.packDateTimeWithZone((long)row.getTimestamp(position).getTime(), (TimeZoneKey)TimeZoneKey.UTC_KEY));
            }
            case DATE: {
                return NullableValue.of((Type)this.trinoType, (Object)row.getDate(position).getDaysSinceEpoch());
            }
            case INET: {
                return NullableValue.of((Type)this.trinoType, (Object)Slices.utf8Slice((String)InetAddresses.toAddrString((InetAddress)row.getInet(position))));
            }
            case VARINT: {
                return NullableValue.of((Type)this.trinoType, (Object)Slices.utf8Slice((String)row.getVarint(position).toString()));
            }
            case BLOB: 
            case CUSTOM: {
                return NullableValue.of((Type)this.trinoType, (Object)Slices.wrappedBuffer((ByteBuffer)row.getBytesUnsafe(position)));
            }
            case SET: 
            case LIST: {
                return NullableValue.of((Type)this.trinoType, (Object)Slices.utf8Slice((String)CassandraType.buildArrayValue(row, position, dataTypeSupplier.get())));
            }
            case MAP: {
                return NullableValue.of((Type)this.trinoType, (Object)Slices.utf8Slice((String)CassandraType.buildMapValue(row, position, dataTypeSupplier.get())));
            }
            case TUPLE: {
                return NullableValue.of((Type)this.trinoType, (Object)this.buildTupleValue(row, position));
            }
            case UDT: {
                return NullableValue.of((Type)this.trinoType, (Object)this.buildUserTypeValue(row, position));
            }
        }
        throw new IllegalStateException("Handling of type " + this + " is not implemented");
    }

    private static String buildMapValue(GettableByIndexData row, int position, DataType dataType) {
        Preconditions.checkArgument((dataType.getTypeArguments().size() == 2 ? 1 : 0) != 0, (String)"Expected two type arguments, got: %s", (Object)dataType.getTypeArguments());
        DataType keyType = (DataType)dataType.getTypeArguments().get(0);
        DataType valueType = (DataType)dataType.getTypeArguments().get(1);
        return CassandraType.buildMapValue((Map)row.getObject(position), keyType, valueType);
    }

    private static String buildMapValue(Map<?, ?> cassandraMap, DataType keyType, DataType valueType) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (Map.Entry<?, ?> entry : cassandraMap.entrySet()) {
            if (sb.length() > 1) {
                sb.append(",");
            }
            sb.append(CassandraType.objectToJson(entry.getKey(), keyType));
            sb.append(":");
            sb.append(CassandraType.objectToJson(entry.getValue(), valueType));
        }
        sb.append("}");
        return sb.toString();
    }

    private static String buildArrayValue(GettableByIndexData row, int position, DataType dataType) {
        DataType elementType = (DataType)Iterables.getOnlyElement((Iterable)dataType.getTypeArguments());
        return CassandraType.buildArrayValue((Collection)row.getObject(position), elementType);
    }

    @VisibleForTesting
    static String buildArrayValue(Collection<?> cassandraCollection, DataType elementType) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (Object value : cassandraCollection) {
            if (sb.length() > 1) {
                sb.append(",");
            }
            sb.append(CassandraType.objectToJson(value, elementType));
        }
        sb.append("]");
        return sb.toString();
    }

    private Block buildTupleValue(GettableByIndexData row, int position) {
        Verify.verify((this.kind == Kind.TUPLE ? 1 : 0) != 0, (String)"Not a TUPLE type", (Object[])new Object[0]);
        TupleValue tupleValue = row.getTupleValue(position);
        RowBlockBuilder blockBuilder = (RowBlockBuilder)this.trinoType.createBlockBuilder(null, 1);
        SingleRowBlockWriter singleRowBlockWriter = blockBuilder.beginBlockEntry();
        int tuplePosition = 0;
        for (CassandraType argumentType : this.getArgumentTypes()) {
            int finalTuplePosition = tuplePosition;
            NullableValue value = argumentType.getColumnValue((GettableByIndexData)tupleValue, tuplePosition, () -> (DataType)tupleValue.getType().getComponentTypes().get(finalTuplePosition));
            TypeUtils.writeNativeValue((Type)argumentType.getTrinoType(), (BlockBuilder)singleRowBlockWriter, (Object)value.getValue());
            ++tuplePosition;
        }
        blockBuilder.closeEntry();
        return (Block)this.trinoType.getObject((Block)blockBuilder, 0);
    }

    private Block buildUserTypeValue(GettableByIndexData row, int position) {
        Verify.verify((this.kind == Kind.UDT ? 1 : 0) != 0, (String)"Not a user defined type: %s", (Object)((Object)this.kind));
        UDTValue udtValue = row.getUDTValue(position);
        String[] fieldNames = (String[])udtValue.getType().getFieldNames().toArray(String[]::new);
        RowBlockBuilder blockBuilder = (RowBlockBuilder)this.trinoType.createBlockBuilder(null, 1);
        SingleRowBlockWriter singleRowBlockWriter = blockBuilder.beginBlockEntry();
        int tuplePosition = 0;
        for (CassandraType argumentType : this.getArgumentTypes()) {
            int finalTuplePosition = tuplePosition;
            NullableValue value = argumentType.getColumnValue((GettableByIndexData)udtValue, tuplePosition, () -> udtValue.getType().getFieldType(fieldNames[finalTuplePosition]));
            TypeUtils.writeNativeValue((Type)argumentType.getTrinoType(), (BlockBuilder)singleRowBlockWriter, (Object)value.getValue());
            ++tuplePosition;
        }
        blockBuilder.closeEntry();
        return (Block)this.trinoType.getObject((Block)blockBuilder, 0);
    }

    public String getColumnValueForCql(Row row, int position) {
        if (row.isNull(position)) {
            return null;
        }
        switch (this.kind) {
            case ASCII: 
            case TEXT: 
            case VARCHAR: {
                return CassandraCqlUtils.quoteStringLiteral(row.getString(position));
            }
            case INT: {
                return Integer.toString(row.getInt(position));
            }
            case SMALLINT: {
                return Short.toString(row.getShort(position));
            }
            case TINYINT: {
                return Byte.toString(row.getByte(position));
            }
            case BIGINT: 
            case COUNTER: {
                return Long.toString(row.getLong(position));
            }
            case BOOLEAN: {
                return Boolean.toString(row.getBool(position));
            }
            case DOUBLE: {
                return Double.toString(row.getDouble(position));
            }
            case FLOAT: {
                return Float.toString(row.getFloat(position));
            }
            case DECIMAL: {
                return row.getDecimal(position).toString();
            }
            case UUID: 
            case TIMEUUID: {
                return row.getUUID(position).toString();
            }
            case TIMESTAMP: {
                return Long.toString(row.getTimestamp(position).getTime());
            }
            case DATE: {
                return CassandraCqlUtils.quoteStringLiteral(row.getDate(position).toString());
            }
            case INET: {
                return CassandraCqlUtils.quoteStringLiteral(InetAddresses.toAddrString((InetAddress)row.getInet(position)));
            }
            case VARINT: {
                return row.getVarint(position).toString();
            }
            case BLOB: 
            case CUSTOM: {
                return Bytes.toHexString((ByteBuffer)row.getBytesUnsafe(position));
            }
        }
        throw new IllegalStateException("Handling of type " + this + " is not implemented");
    }

    public String toCqlLiteral(Object trinoNativeValue) {
        if (this.kind == Kind.DATE) {
            LocalDate date = LocalDate.fromDaysSinceEpoch((int)Math.toIntExact((Long)trinoNativeValue));
            return CassandraCqlUtils.quoteStringLiteral(date.toString());
        }
        if (this.kind == Kind.TIMESTAMP) {
            return String.valueOf(DateTimeEncoding.unpackMillisUtc((long)((Long)trinoNativeValue)));
        }
        String value = trinoNativeValue instanceof Slice ? ((Slice)trinoNativeValue).toStringUtf8() : trinoNativeValue.toString();
        switch (this.kind) {
            case ASCII: 
            case TEXT: 
            case VARCHAR: {
                return CassandraCqlUtils.quoteStringLiteral(value);
            }
            case INET: {
                return CassandraCqlUtils.quoteStringLiteral(value.substring(1));
            }
        }
        return value;
    }

    private static String objectToJson(Object cassandraValue, DataType dataType) {
        CassandraType cassandraType = CassandraType.toCassandraType(dataType).orElseThrow(() -> new IllegalStateException("Unsupported type: " + dataType));
        switch (cassandraType.kind) {
            case ASCII: 
            case TEXT: 
            case VARCHAR: 
            case UUID: 
            case TIMEUUID: 
            case TIMESTAMP: 
            case DATE: 
            case INET: 
            case VARINT: 
            case TUPLE: 
            case UDT: {
                return CassandraCqlUtils.quoteStringLiteralForJson(cassandraValue.toString());
            }
            case BLOB: 
            case CUSTOM: {
                return CassandraCqlUtils.quoteStringLiteralForJson(Bytes.toHexString((ByteBuffer)((ByteBuffer)cassandraValue)));
            }
            case INT: 
            case SMALLINT: 
            case TINYINT: 
            case BIGINT: 
            case COUNTER: 
            case BOOLEAN: 
            case DOUBLE: 
            case FLOAT: 
            case DECIMAL: {
                return cassandraValue.toString();
            }
            case SET: 
            case LIST: {
                return CassandraType.buildArrayValue((Collection)cassandraValue, (DataType)Iterables.getOnlyElement((Iterable)dataType.getTypeArguments()));
            }
            case MAP: {
                return CassandraType.buildMapValue((Map)cassandraValue, (DataType)dataType.getTypeArguments().get(0), (DataType)dataType.getTypeArguments().get(1));
            }
        }
        throw new IllegalStateException("Unsupported type: " + cassandraType);
    }

    public Object getJavaValue(Object trinoNativeValue) {
        switch (this.kind) {
            case ASCII: 
            case TEXT: 
            case VARCHAR: {
                return ((Slice)trinoNativeValue).toStringUtf8();
            }
            case BIGINT: 
            case COUNTER: 
            case BOOLEAN: 
            case DOUBLE: {
                return trinoNativeValue;
            }
            case INET: {
                return InetAddresses.forString((String)((Slice)trinoNativeValue).toStringUtf8());
            }
            case INT: 
            case SMALLINT: 
            case TINYINT: {
                return ((Long)trinoNativeValue).intValue();
            }
            case FLOAT: {
                return Float.valueOf(Float.intBitsToFloat(((Long)trinoNativeValue).intValue()));
            }
            case DECIMAL: {
                return new BigDecimal(trinoNativeValue.toString());
            }
            case TIMESTAMP: {
                return new Date(DateTimeEncoding.unpackMillisUtc((long)((Long)trinoNativeValue)));
            }
            case DATE: {
                return LocalDate.fromDaysSinceEpoch((int)((Long)trinoNativeValue).intValue());
            }
            case UUID: 
            case TIMEUUID: {
                return UuidType.trinoUuidToJavaUuid((Slice)((Slice)trinoNativeValue));
            }
            case BLOB: 
            case CUSTOM: 
            case TUPLE: 
            case UDT: {
                return ((Slice)trinoNativeValue).toStringUtf8();
            }
            case VARINT: {
                return new BigInteger(((Slice)trinoNativeValue).toStringUtf8());
            }
        }
        throw new IllegalStateException("Back conversion not implemented for " + this);
    }

    public boolean isSupportedPartitionKey() {
        switch (this.kind) {
            case ASCII: 
            case TEXT: 
            case VARCHAR: 
            case INT: 
            case SMALLINT: 
            case TINYINT: 
            case BIGINT: 
            case BOOLEAN: 
            case DOUBLE: 
            case FLOAT: 
            case DECIMAL: 
            case UUID: 
            case TIMEUUID: 
            case TIMESTAMP: 
            case DATE: 
            case INET: {
                return true;
            }
        }
        return false;
    }

    public static boolean isFullySupported(DataType dataType) {
        if (CassandraType.toCassandraType(dataType).isEmpty()) {
            return false;
        }
        return dataType.getTypeArguments().stream().allMatch(CassandraType::isFullySupported);
    }

    public static CassandraType toCassandraType(Type type, ProtocolVersion protocolVersion) {
        if (type.equals(BooleanType.BOOLEAN)) {
            return CassandraTypes.BOOLEAN;
        }
        if (type.equals(BigintType.BIGINT)) {
            return CassandraTypes.BIGINT;
        }
        if (type.equals(IntegerType.INTEGER)) {
            return CassandraTypes.INT;
        }
        if (type.equals(SmallintType.SMALLINT)) {
            return CassandraTypes.SMALLINT;
        }
        if (type.equals(TinyintType.TINYINT)) {
            return CassandraTypes.TINYINT;
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return CassandraTypes.DOUBLE;
        }
        if (type.equals(RealType.REAL)) {
            return CassandraTypes.FLOAT;
        }
        if (type instanceof VarcharType) {
            return CassandraTypes.TEXT;
        }
        if (type.equals(DateType.DATE)) {
            return protocolVersion.toInt() <= ProtocolVersion.V3.toInt() ? CassandraTypes.TEXT : CassandraTypes.DATE;
        }
        if (type.equals(VarbinaryType.VARBINARY)) {
            return CassandraTypes.BLOB;
        }
        if (type.equals(TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS)) {
            return CassandraTypes.TIMESTAMP;
        }
        if (type.equals(UuidType.UUID)) {
            return CassandraTypes.UUID;
        }
        throw new IllegalArgumentException("unsupported type: " + type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CassandraType that = (CassandraType)o;
        return this.kind == that.kind && Objects.equals(this.trinoType, that.trinoType) && Objects.equals(this.argumentTypes, that.argumentTypes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.kind, this.trinoType, this.argumentTypes});
    }

    public static enum Kind {
        BOOLEAN,
        TINYINT,
        SMALLINT,
        INT,
        BIGINT,
        FLOAT,
        DOUBLE,
        DECIMAL,
        DATE,
        TIMESTAMP,
        ASCII,
        TEXT,
        VARCHAR,
        BLOB,
        UUID,
        TIMEUUID,
        COUNTER,
        VARINT,
        INET,
        CUSTOM,
        LIST,
        SET,
        MAP,
        TUPLE,
        UDT;

    }
}

