/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra;

import io.trino.plugin.cassandra.CassandraType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.UuidType;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;

public final class CassandraTypes {
    private static final int IP_ADDRESS_STRING_MAX_LENGTH = 45;
    public static final CassandraType ASCII = new CassandraType(CassandraType.Kind.ASCII, (Type)VarcharType.createUnboundedVarcharType());
    public static final CassandraType BIGINT = new CassandraType(CassandraType.Kind.BIGINT, (Type)BigintType.BIGINT);
    public static final CassandraType BLOB = new CassandraType(CassandraType.Kind.BLOB, (Type)VarbinaryType.VARBINARY);
    public static final CassandraType BOOLEAN = new CassandraType(CassandraType.Kind.BOOLEAN, (Type)BooleanType.BOOLEAN);
    public static final CassandraType COUNTER = new CassandraType(CassandraType.Kind.COUNTER, (Type)BigintType.BIGINT);
    public static final CassandraType CUSTOM = new CassandraType(CassandraType.Kind.CUSTOM, (Type)VarbinaryType.VARBINARY);
    public static final CassandraType DATE = new CassandraType(CassandraType.Kind.DATE, (Type)DateType.DATE);
    public static final CassandraType DECIMAL = new CassandraType(CassandraType.Kind.DECIMAL, (Type)DoubleType.DOUBLE);
    public static final CassandraType DOUBLE = new CassandraType(CassandraType.Kind.DOUBLE, (Type)DoubleType.DOUBLE);
    public static final CassandraType FLOAT = new CassandraType(CassandraType.Kind.FLOAT, (Type)RealType.REAL);
    public static final CassandraType INET = new CassandraType(CassandraType.Kind.INET, (Type)VarcharType.createVarcharType((int)45));
    public static final CassandraType INT = new CassandraType(CassandraType.Kind.INT, (Type)IntegerType.INTEGER);
    public static final CassandraType LIST = new CassandraType(CassandraType.Kind.LIST, (Type)VarcharType.createUnboundedVarcharType());
    public static final CassandraType MAP = new CassandraType(CassandraType.Kind.MAP, (Type)VarcharType.createUnboundedVarcharType());
    public static final CassandraType SET = new CassandraType(CassandraType.Kind.SET, (Type)VarcharType.createUnboundedVarcharType());
    public static final CassandraType SMALLINT = new CassandraType(CassandraType.Kind.SMALLINT, (Type)SmallintType.SMALLINT);
    public static final CassandraType TEXT = new CassandraType(CassandraType.Kind.TEXT, (Type)VarcharType.createUnboundedVarcharType());
    public static final CassandraType TIMESTAMP = new CassandraType(CassandraType.Kind.TIMESTAMP, (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS);
    public static final CassandraType TIMEUUID = new CassandraType(CassandraType.Kind.TIMEUUID, (Type)UuidType.UUID);
    public static final CassandraType TINYINT = new CassandraType(CassandraType.Kind.TINYINT, (Type)TinyintType.TINYINT);
    public static final CassandraType UUID = new CassandraType(CassandraType.Kind.UUID, (Type)UuidType.UUID);
    public static final CassandraType VARCHAR = new CassandraType(CassandraType.Kind.VARCHAR, (Type)VarcharType.createUnboundedVarcharType());
    public static final CassandraType VARINT = new CassandraType(CassandraType.Kind.VARINT, (Type)VarcharType.createUnboundedVarcharType());

    private CassandraTypes() {
    }
}

