/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra;

import io.trino.plugin.cassandra.TokenRing;
import java.math.BigInteger;

public final class Murmur3PartitionerTokenRing
implements TokenRing {
    public static final Murmur3PartitionerTokenRing INSTANCE = new Murmur3PartitionerTokenRing();
    private static final long MIN_TOKEN = Long.MIN_VALUE;
    private static final long MAX_TOKEN = Long.MAX_VALUE;
    private static final BigInteger TOTAL_TOKEN_COUNT = BigInteger.valueOf(Long.MAX_VALUE).subtract(BigInteger.valueOf(Long.MIN_VALUE));

    private Murmur3PartitionerTokenRing() {
    }

    @Override
    public double getRingFraction(String start, String end) {
        return this.getTokenCountInRange(start, end).doubleValue() / TOTAL_TOKEN_COUNT.doubleValue();
    }

    @Override
    public BigInteger getTokenCountInRange(String startToken, String endToken) {
        long end;
        long start = Long.parseLong(startToken);
        if (start == (end = Long.parseLong(endToken))) {
            if (start == Long.MIN_VALUE) {
                return TOTAL_TOKEN_COUNT;
            }
            return BigInteger.ZERO;
        }
        BigInteger result = BigInteger.valueOf(end).subtract(BigInteger.valueOf(start));
        if (end <= start) {
            result = result.add(TOTAL_TOKEN_COUNT);
        }
        return result;
    }
}

