/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra;

import com.datastax.driver.core.CloseFuture;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.DelegatingCluster;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import io.airlift.log.Logger;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ReopeningCluster
extends DelegatingCluster {
    private static final Logger log = Logger.get(ReopeningCluster.class);
    @GuardedBy(value="this")
    private Cluster delegate;
    @GuardedBy(value="this")
    private boolean closed;
    private final Supplier<Cluster> supplier;

    public ReopeningCluster(Supplier<Cluster> supplier) {
        this.supplier = Objects.requireNonNull(supplier, "supplier is null");
    }

    protected synchronized Cluster delegate() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cluster has been closed");
        if (this.delegate == null) {
            this.delegate = this.supplier.get();
        }
        if (this.delegate.isClosed()) {
            log.warn("Cluster has been closed internally");
            this.delegate = this.supplier.get();
        }
        Verify.verify((!this.delegate.isClosed() ? 1 : 0) != 0, (String)"Newly created cluster has been immediately closed", (Object[])new Object[0]);
        return this.delegate;
    }

    public synchronized void close() {
        this.closed = true;
        if (this.delegate != null) {
            this.delegate.close();
            this.delegate = null;
        }
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public synchronized CloseFuture closeAsync() {
        throw new UnsupportedOperationException();
    }
}

