/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra;

import io.trino.plugin.cassandra.Murmur3PartitionerTokenRing;
import io.trino.plugin.cassandra.RandomPartitionerTokenRing;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;

public interface TokenRing {
    public double getRingFraction(String var1, String var2);

    public BigInteger getTokenCountInRange(String var1, String var2);

    public static Optional<TokenRing> createForPartitioner(String partitioner) {
        Objects.requireNonNull(partitioner, "partitioner is null");
        switch (partitioner) {
            case "org.apache.cassandra.dht.Murmur3Partitioner": {
                return Optional.of(Murmur3PartitionerTokenRing.INSTANCE);
            }
            case "org.apache.cassandra.dht.RandomPartitioner": {
                return Optional.of(RandomPartitionerTokenRing.INSTANCE);
            }
        }
        return Optional.empty();
    }
}

