/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra.util;

import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.fasterxml.jackson.core.io.JsonStringEncoder;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.cassandra.CassandraColumnHandle;
import io.trino.plugin.cassandra.CassandraPartition;
import io.trino.plugin.cassandra.CassandraTableHandle;
import io.trino.spi.connector.ColumnHandle;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public final class CassandraCqlUtils {
    public static final String ID_COLUMN_NAME = "id";
    public static final String EMPTY_COLUMN_NAME = "__empty__";

    private CassandraCqlUtils() {
    }

    public static String validSchemaName(String identifier) {
        return Metadata.quote((String)identifier);
    }

    public static String validTableName(String identifier) {
        return Metadata.quote((String)identifier);
    }

    public static String validColumnName(String identifier) {
        if (identifier.isEmpty() || identifier.equals(EMPTY_COLUMN_NAME)) {
            return "\"\"";
        }
        return Metadata.quote((String)identifier);
    }

    public static String quoteStringLiteral(String string) {
        return "'" + string.replace("'", "''") + "'";
    }

    public static String quoteStringLiteralForJson(String string) {
        return "\"" + new String(JsonStringEncoder.getInstance().quoteAsUTF8(string), StandardCharsets.UTF_8) + "\"";
    }

    public static void appendSelectColumns(StringBuilder stringBuilder, List<? extends ColumnHandle> columns) {
        CassandraCqlUtils.appendSelectColumns(stringBuilder, columns, true);
    }

    private static void appendSelectColumns(StringBuilder stringBuilder, List<? extends ColumnHandle> columns, boolean first) {
        for (ColumnHandle columnHandle : columns) {
            if (first) {
                first = false;
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append(CassandraCqlUtils.validColumnName(((CassandraColumnHandle)columnHandle).getName()));
        }
    }

    public static String cqlNameToSqlName(String name) {
        if (name.isEmpty()) {
            return EMPTY_COLUMN_NAME;
        }
        return name;
    }

    public static String sqlNameToCqlName(String name) {
        if (name.equals(EMPTY_COLUMN_NAME)) {
            return "";
        }
        return name;
    }

    public static Select.Selection select(List<CassandraColumnHandle> columns) {
        Select.Selection selection = QueryBuilder.select();
        for (CassandraColumnHandle column : columns) {
            selection.column(CassandraCqlUtils.validColumnName(column.getName()));
        }
        return selection;
    }

    public static Select selectFrom(CassandraTableHandle tableHandle, List<CassandraColumnHandle> columns) {
        return CassandraCqlUtils.from(CassandraCqlUtils.select(columns), tableHandle);
    }

    public static Select from(Select.Selection selection, CassandraTableHandle tableHandle) {
        String schema = CassandraCqlUtils.validSchemaName(tableHandle.getSchemaName());
        String table = CassandraCqlUtils.validTableName(tableHandle.getTableName());
        return selection.from(schema, table);
    }

    public static Select selectDistinctFrom(CassandraTableHandle tableHandle, List<CassandraColumnHandle> columns) {
        return CassandraCqlUtils.from(CassandraCqlUtils.select(columns).distinct(), tableHandle);
    }

    private static String getWhereCondition(String partition, String clusteringKeyPredicates) {
        ArrayList<String> conditions = new ArrayList<String>();
        conditions.add(partition);
        if (!clusteringKeyPredicates.isEmpty()) {
            conditions.add(clusteringKeyPredicates);
        }
        return String.join((CharSequence)" AND ", conditions);
    }

    private static String deleteFrom(String schemaName, String tableName, CassandraPartition partition, String clusteringKeyPredicates) {
        return String.format("DELETE FROM \"%s\".\"%s\" WHERE %s", schemaName, tableName, CassandraCqlUtils.getWhereCondition(partition.getPartitionId(), clusteringKeyPredicates));
    }

    public static List<String> getDeleteQueries(CassandraTableHandle handle) {
        ImmutableList.Builder queries = ImmutableList.builder();
        for (CassandraPartition partition : handle.getPartitions().orElse((List<CassandraPartition>)ImmutableList.of())) {
            queries.add((Object)CassandraCqlUtils.deleteFrom(handle.getSchemaName(), handle.getTableName(), partition, handle.getClusteringKeyPredicates()));
        }
        return queries.build();
    }
}

