/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra.util;

import com.datastax.driver.core.Host;
import io.trino.spi.HostAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HostAddressFactory {
    private final Map<String, HostAddress> hostMap = new HashMap<String, HostAddress>();

    public HostAddress toHostAddress(Host host) {
        return this.toHostAddress(host.getAddress().getHostAddress());
    }

    public List<HostAddress> toHostAddressList(Collection<Host> hosts) {
        ArrayList<HostAddress> list = new ArrayList<HostAddress>(hosts.size());
        for (Host host : hosts) {
            list.add(this.toHostAddress(host));
        }
        return list;
    }

    public HostAddress toHostAddress(String hostAddressName) {
        HostAddress address = this.hostMap.get(hostAddressName);
        if (address == null) {
            address = HostAddress.fromString((String)hostAddressName);
            this.hostMap.put(hostAddressName, address);
        }
        return address;
    }

    public List<HostAddress> hostAddressNamesToHostAddressList(Collection<String> hosts) {
        ArrayList<HostAddress> list = new ArrayList<HostAddress>(hosts.size());
        for (String host : hosts) {
            list.add(this.toHostAddress(host));
        }
        return list;
    }
}

