/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.localfile;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.plugin.localfile.LocalFileColumnHandle;
import io.trino.plugin.localfile.LocalFileRecordCursor;
import io.trino.plugin.localfile.LocalFileSplit;
import io.trino.plugin.localfile.LocalFileTableHandle;
import io.trino.plugin.localfile.LocalFileTables;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.RecordSet;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;

public class LocalFileRecordSet
implements RecordSet {
    private final List<LocalFileColumnHandle> columns;
    private final List<Type> columnTypes;
    private final HostAddress address;
    private final TupleDomain<LocalFileColumnHandle> effectivePredicate;
    private final SchemaTableName tableName;
    private final LocalFileTables localFileTables;

    public LocalFileRecordSet(LocalFileTables localFileTables, LocalFileSplit split, LocalFileTableHandle table, List<LocalFileColumnHandle> columns) {
        this.columns = Objects.requireNonNull(columns, "columns is null");
        Objects.requireNonNull(split, "split is null");
        ImmutableList.Builder types = ImmutableList.builder();
        for (LocalFileColumnHandle column : columns) {
            types.add((Object)column.getColumnType());
        }
        this.columnTypes = types.build();
        this.address = (HostAddress)Iterables.getOnlyElement(split.getAddresses());
        this.effectivePredicate = table.getConstraint().transformKeys(LocalFileColumnHandle.class::cast);
        this.tableName = table.getSchemaTableName();
        this.localFileTables = Objects.requireNonNull(localFileTables, "localFileTables is null");
    }

    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    public RecordCursor cursor() {
        return new LocalFileRecordCursor(this.localFileTables, this.columns, this.tableName, this.address, this.effectivePredicate);
    }
}

