/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.fate;

import java.io.Serializable;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import org.apache.accumulo.fate.ReadOnlyRepo;
import org.apache.accumulo.fate.ReadOnlyTStore;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.fate.TStore;

public class ReadOnlyStore<T>
implements ReadOnlyTStore<T> {
    private final TStore<T> store;

    public ReadOnlyStore(TStore<T> store) {
        Objects.requireNonNull(store);
        this.store = store;
    }

    @Override
    public long reserve() {
        return this.store.reserve();
    }

    @Override
    public void reserve(long tid) {
        this.store.reserve(tid);
    }

    @Override
    public void unreserve(long tid, long deferTime) {
        this.store.unreserve(tid, deferTime);
    }

    @Override
    public ReadOnlyRepo<T> top(long tid) {
        return new ReadOnlyRepoWrapper<T>(this.store.top(tid));
    }

    @Override
    public ReadOnlyTStore.TStatus getStatus(long tid) {
        return this.store.getStatus(tid);
    }

    @Override
    public ReadOnlyTStore.TStatus waitForStatusChange(long tid, EnumSet<ReadOnlyTStore.TStatus> expected) {
        return this.store.waitForStatusChange(tid, expected);
    }

    @Override
    public Serializable getProperty(long tid, String prop) {
        return this.store.getProperty(tid, prop);
    }

    @Override
    public List<Long> list() {
        return this.store.list();
    }

    protected static class ReadOnlyRepoWrapper<X>
    implements ReadOnlyRepo<X> {
        private final Repo<X> repo;

        public ReadOnlyRepoWrapper(Repo<X> repo) {
            Objects.requireNonNull(repo);
            this.repo = repo;
        }

        @Override
        public long isReady(long tid, X environment) throws Exception {
            return this.repo.isReady(tid, environment);
        }

        @Override
        public String getDescription() {
            return this.repo.getDescription();
        }
    }
}

