/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.google.sheets;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.trino.plugin.google.sheets.SheetsClient;
import io.trino.plugin.google.sheets.SheetsColumnHandle;
import io.trino.plugin.google.sheets.SheetsErrorCode;
import io.trino.plugin.google.sheets.SheetsTable;
import io.trino.plugin.google.sheets.SheetsTableHandle;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.connector.TableNotFoundException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class SheetsMetadata
implements ConnectorMetadata {
    private final SheetsClient sheetsClient;
    private static final List<String> SCHEMAS = ImmutableList.of((Object)"default");

    @Inject
    public SheetsMetadata(SheetsClient sheetsClient) {
        this.sheetsClient = Objects.requireNonNull(sheetsClient, "sheetsClient is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return this.listSchemaNames();
    }

    public List<String> listSchemaNames() {
        return SCHEMAS;
    }

    public SheetsTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        Objects.requireNonNull(tableName, "tableName is null");
        if (!this.listSchemaNames(session).contains(tableName.getSchemaName())) {
            return null;
        }
        Optional<SheetsTable> table = this.sheetsClient.getTable(tableName.getTableName());
        if (table.isEmpty()) {
            return null;
        }
        return new SheetsTableHandle(tableName.getSchemaName(), tableName.getTableName());
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        Optional<ConnectorTableMetadata> connectorTableMetadata = this.getTableMetadata(((SheetsTableHandle)table).toSchemaTableName());
        if (connectorTableMetadata.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)SheetsErrorCode.SHEETS_UNKNOWN_TABLE_ERROR, "Metadata not found for table " + ((SheetsTableHandle)table).getTableName());
        }
        return connectorTableMetadata.get();
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        SheetsTableHandle sheetsTableHandle = (SheetsTableHandle)tableHandle;
        Optional<SheetsTable> table = this.sheetsClient.getTable(sheetsTableHandle.getTableName());
        if (table.isEmpty()) {
            throw new TableNotFoundException(sheetsTableHandle.toSchemaTableName());
        }
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        int index = 0;
        for (ColumnMetadata column : table.get().getColumnsMetadata()) {
            columnHandles.put((Object)column.getName(), (Object)new SheetsColumnHandle(column.getName(), column.getType(), index));
            ++index;
        }
        return columnHandles.buildOrThrow();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName tableName : this.listTables(session, prefix.getSchema())) {
            Optional<ConnectorTableMetadata> tableMetadata = this.getTableMetadata(tableName);
            if (!tableMetadata.isPresent()) continue;
            columns.put((Object)tableName, (Object)tableMetadata.get().getColumns());
        }
        return columns.buildOrThrow();
    }

    private Optional<ConnectorTableMetadata> getTableMetadata(SchemaTableName tableName) {
        if (!this.listSchemaNames().contains(tableName.getSchemaName())) {
            return Optional.empty();
        }
        Optional<SheetsTable> table = this.sheetsClient.getTable(tableName.getTableName());
        if (table.isPresent()) {
            return Optional.of(new ConnectorTableMetadata(tableName, table.get().getColumnsMetadata()));
        }
        return Optional.empty();
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        String schema = schemaName.orElse((String)Iterables.getOnlyElement(SCHEMAS));
        if (this.listSchemaNames().contains(schema)) {
            return (List)this.sheetsClient.getTableNames().stream().map(tableName -> new SchemaTableName(schema, tableName)).collect(ImmutableList.toImmutableList());
        }
        return ImmutableList.of();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return ((SheetsColumnHandle)columnHandle).getColumnMetadata();
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle table) {
        return new ConnectorTableProperties();
    }
}

