/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.connector.BucketFunction;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeUtils;
import java.lang.invoke.MethodHandle;
import java.util.List;

public class DeltaLakeBucketFunction
implements BucketFunction {
    private final List<Type> types;
    private final int bucketCount;
    private final List<MethodHandle> hashCodeInvokers;

    public DeltaLakeBucketFunction(TypeOperators typeOperators, List<DeltaLakeColumnHandle> partitioningColumns, int bucketCount) {
        this.types = (List)partitioningColumns.stream().map(DeltaLakeColumnHandle::getType).collect(ImmutableList.toImmutableList());
        this.hashCodeInvokers = (List)partitioningColumns.stream().map(DeltaLakeColumnHandle::getType).map(type -> typeOperators.getHashCodeOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL}))).collect(ImmutableList.toImmutableList());
        this.bucketCount = bucketCount;
    }

    public int getBucket(Page page, int position) {
        long result = 0L;
        for (int channel = 0; channel < page.getChannelCount(); ++channel) {
            Block block = page.getBlock(channel);
            Object value = TypeUtils.readNativeValue((Type)this.types.get(channel), (Block)block, (int)position);
            result += DeltaLakeBucketFunction.hashValue(this.hashCodeInvokers.get(channel), value);
        }
        return (int)((result & Long.MAX_VALUE) % (long)this.bucketCount);
    }

    private static long hashValue(MethodHandle method, Object value) {
        if (value == null) {
            return 0L;
        }
        try {
            return method.invoke(value);
        }
        catch (Throwable throwable) {
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(throwable);
        }
    }
}

