/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.base.Throwables;
import com.google.inject.Module;
import io.trino.plugin.deltalake.InternalDeltaLakeConnectorFactory;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DeltaLakeConnectorFactory
implements ConnectorFactory {
    public static final String CONNECTOR_NAME = "delta-lake";
    private final Optional<Module> extensions;

    public DeltaLakeConnectorFactory(Optional<Module> extensions) {
        this.extensions = Objects.requireNonNull(extensions, "extensions is null");
    }

    public String getName() {
        return CONNECTOR_NAME;
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        ClassLoader classLoader = context.duplicatePluginClassLoader();
        try {
            return (Connector)classLoader.loadClass(InternalDeltaLakeConnectorFactory.class.getName()).getMethod("createConnector", String.class, Map.class, ConnectorContext.class, Optional.class).invoke(null, catalogName, config, context, this.extensions);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            Throwables.throwIfUnchecked((Throwable)targetException);
            throw new RuntimeException(targetException);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

