/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.Comparators;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.stats.cardinality.HyperLogLog;
import io.airlift.units.DataSize;
import io.trino.plugin.deltalake.AnalyzeHandle;
import io.trino.plugin.deltalake.DataFileInfo;
import io.trino.plugin.deltalake.DeltaLakeAnalyzeProperties;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnType;
import io.trino.plugin.deltalake.DeltaLakeErrorCode;
import io.trino.plugin.deltalake.DeltaLakeInsertTableHandle;
import io.trino.plugin.deltalake.DeltaLakeOutputTableHandle;
import io.trino.plugin.deltalake.DeltaLakePartitioningHandle;
import io.trino.plugin.deltalake.DeltaLakeSchemaProperties;
import io.trino.plugin.deltalake.DeltaLakeSessionProperties;
import io.trino.plugin.deltalake.DeltaLakeTableHandle;
import io.trino.plugin.deltalake.DeltaLakeTableProperties;
import io.trino.plugin.deltalake.DeltaLakeUpdateResult;
import io.trino.plugin.deltalake.metastore.DeltaLakeMetastore;
import io.trino.plugin.deltalake.metastore.NotADeltaLakeTableException;
import io.trino.plugin.deltalake.procedure.DeltaLakeTableExecuteHandle;
import io.trino.plugin.deltalake.procedure.DeltaLakeTableProcedureId;
import io.trino.plugin.deltalake.procedure.DeltaTableOptimizeHandle;
import io.trino.plugin.deltalake.statistics.DeltaLakeColumnStatistics;
import io.trino.plugin.deltalake.statistics.DeltaLakeStatistics;
import io.trino.plugin.deltalake.statistics.DeltaLakeStatisticsAccess;
import io.trino.plugin.deltalake.transactionlog.AddFileEntry;
import io.trino.plugin.deltalake.transactionlog.CommitInfoEntry;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeSchemaSupport;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.deltalake.transactionlog.ProtocolEntry;
import io.trino.plugin.deltalake.transactionlog.RemoveFileEntry;
import io.trino.plugin.deltalake.transactionlog.TableSnapshot;
import io.trino.plugin.deltalake.transactionlog.TransactionLogParser;
import io.trino.plugin.deltalake.transactionlog.TransactionLogUtil;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointWriterManager;
import io.trino.plugin.deltalake.transactionlog.statistics.DeltaLakeFileStatistics;
import io.trino.plugin.deltalake.transactionlog.writer.TransactionConflictException;
import io.trino.plugin.deltalake.transactionlog.writer.TransactionLogWriter;
import io.trino.plugin.deltalake.transactionlog.writer.TransactionLogWriterFactory;
import io.trino.plugin.hive.HdfsEnvironment;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.PrincipalPrivileges;
import io.trino.plugin.hive.metastore.StorageFormat;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.plugin.hive.util.HiveWriteUtils;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.NodeManager;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.connector.Assignment;
import io.trino.spi.connector.BeginTableExecuteResult;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorOutputMetadata;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableExecuteHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableLayout;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.ProjectionApplicationResult;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.connector.TableColumnsMetadata;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Variable;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.statistics.ColumnStatisticMetadata;
import io.trino.spi.statistics.ColumnStatisticType;
import io.trino.spi.statistics.ComputedStatistics;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.statistics.TableStatisticsMetadata;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.HyperLogLogType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeUtils;
import io.trino.spi.type.VarcharType;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hive.metastore.TableType;

public class DeltaLakeMetadata
implements ConnectorMetadata {
    public static final Logger LOG = Logger.get(DeltaLakeMetadata.class);
    public static final String PATH_PROPERTY = "path";
    public static final StorageFormat DELTA_STORAGE_FORMAT = StorageFormat.create((String)"org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe", (String)"org.apache.hadoop.mapred.SequenceFileInputFormat", (String)"org.apache.hadoop.hive.ql.io.HiveSequenceFileOutputFormat");
    public static final String CREATE_TABLE_AS_OPERATION = "CREATE TABLE AS SELECT";
    public static final String CREATE_TABLE_OPERATION = "CREATE TABLE";
    public static final String INSERT_OPERATION = "WRITE";
    public static final String DELETE_OPERATION = "DELETE";
    public static final String UPDATE_OPERATION = "UPDATE";
    public static final String OPTIMIZE_OPERATION = "OPTIMIZE";
    public static final String ISOLATION_LEVEL = "WriteSerializable";
    private static final int READER_VERSION = 1;
    private static final int WRITER_VERSION = 2;
    private static final List<Column> DUMMY_DATA_COLUMNS = ImmutableList.of((Object)new Column("col", HiveType.toHiveType((Type)new ArrayType((Type)VarcharType.createUnboundedVarcharType())), Optional.empty()));
    private final DeltaLakeMetastore metastore;
    private final HdfsEnvironment hdfsEnvironment;
    private final TypeManager typeManager;
    private final CheckpointWriterManager checkpointWriterManager;
    private final long defaultCheckpointInterval;
    private final boolean ignoreCheckpointWriteFailures;
    private final int domainCompactionThreshold;
    private final boolean hideNonDeltaLakeTables;
    private final boolean unsafeWritesEnabled;
    private final JsonCodec<DataFileInfo> dataFileInfoCodec;
    private final JsonCodec<DeltaLakeUpdateResult> deleteResultJsonCodec;
    private final TransactionLogWriterFactory transactionLogWriterFactory;
    private final String nodeVersion;
    private final String nodeId;
    private final AtomicReference<Runnable> rollbackAction = new AtomicReference();
    private final DeltaLakeStatisticsAccess statisticsAccess;
    private final boolean deleteSchemaLocationsFallback;

    public DeltaLakeMetadata(DeltaLakeMetastore metastore, HdfsEnvironment hdfsEnvironment, TypeManager typeManager, int domainCompactionThreshold, boolean hideNonDeltaLakeTables, boolean unsafeWritesEnabled, JsonCodec<DataFileInfo> dataFileInfoCodec, JsonCodec<DeltaLakeUpdateResult> deleteResultJsonCodec, TransactionLogWriterFactory transactionLogWriterFactory, NodeManager nodeManager, CheckpointWriterManager checkpointWriterManager, long defaultCheckpointInterval, boolean ignoreCheckpointWriteFailures, boolean deleteSchemaLocationsFallback, DeltaLakeStatisticsAccess statisticsAccess) {
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.domainCompactionThreshold = domainCompactionThreshold;
        this.hideNonDeltaLakeTables = hideNonDeltaLakeTables;
        this.unsafeWritesEnabled = unsafeWritesEnabled;
        this.dataFileInfoCodec = Objects.requireNonNull(dataFileInfoCodec, "dataFileInfoCodec is null");
        this.deleteResultJsonCodec = Objects.requireNonNull(deleteResultJsonCodec, "deleteResultJsonCodec is null");
        this.transactionLogWriterFactory = Objects.requireNonNull(transactionLogWriterFactory, "transactionLogWriterFactory is null");
        this.nodeVersion = nodeManager.getCurrentNode().getVersion();
        this.nodeId = nodeManager.getCurrentNode().getNodeIdentifier();
        this.checkpointWriterManager = Objects.requireNonNull(checkpointWriterManager, "checkpointWriterManager is null");
        this.defaultCheckpointInterval = defaultCheckpointInterval;
        this.ignoreCheckpointWriteFailures = ignoreCheckpointWriteFailures;
        this.statisticsAccess = Objects.requireNonNull(statisticsAccess, "statisticsAccess is null");
        this.deleteSchemaLocationsFallback = deleteSchemaLocationsFallback;
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return (List)this.metastore.getAllDatabases().stream().filter(schema -> {
            String schemaName = schema.toLowerCase(Locale.ENGLISH);
            return !schemaName.equals("information_schema") && !schemaName.equals("sys");
        }).collect(ImmutableList.toImmutableList());
    }

    private static boolean isHiveTable(Table table) {
        return !HiveUtil.isDeltaLakeTable((Table)table);
    }

    public Optional<CatalogSchemaTableName> redirectTable(ConnectorSession session, SchemaTableName tableName) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Optional<String> targetCatalogName = DeltaLakeSessionProperties.getHiveCatalogName(session);
        if (targetCatalogName.isEmpty()) {
            return Optional.empty();
        }
        if (HiveUtil.isHiveSystemSchema((String)tableName.getSchemaName())) {
            return Optional.empty();
        }
        int metadataMarkerIndex = tableName.getTableName().lastIndexOf(36);
        SchemaTableName tableNameBase = metadataMarkerIndex == -1 ? tableName : SchemaTableName.schemaTableName((String)tableName.getSchemaName(), (String)tableName.getTableName().substring(0, metadataMarkerIndex));
        Optional table = this.metastore.getHiveMetastore().getTable(tableNameBase.getSchemaName(), tableNameBase.getTableName());
        if (table.isEmpty() || TableType.VIRTUAL_VIEW.name().equals(((Table)table.get()).getTableType())) {
            return Optional.empty();
        }
        if (DeltaLakeMetadata.isHiveTable((Table)table.get())) {
            return targetCatalogName.map(catalog -> new CatalogSchemaTableName(catalog, tableName));
        }
        return Optional.empty();
    }

    public DeltaLakeTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        Objects.requireNonNull(tableName, "tableName is null");
        Optional<Table> table = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName());
        if (table.isEmpty()) {
            return null;
        }
        TableSnapshot tableSnapshot = this.metastore.getSnapshot(tableName, session);
        Optional<MetadataEntry> metadata = this.metastore.getMetadata(tableSnapshot, session);
        return new DeltaLakeTableHandle(tableName.getSchemaName(), tableName.getTableName(), this.metastore.getTableLocation(tableName, session), metadata, (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.all(), (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.all(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), tableSnapshot.getVersion());
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return new ConnectorTableProperties();
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        DeltaLakeTableHandle tableHandle = (DeltaLakeTableHandle)table;
        String location = this.metastore.getTableLocation(tableHandle.getSchemaTableName(), session);
        List columns = (List)this.getColumns(tableHandle.getMetadataEntry()).stream().map(DeltaLakeMetadata::getColumnMetadata).collect(ImmutableList.toImmutableList());
        ImmutableMap.Builder properties = ImmutableMap.builder().put((Object)"location", (Object)location).put((Object)"partitioned_by", tableHandle.getMetadataEntry().getCanonicalPartitionColumns());
        Optional<Long> checkpointInterval = tableHandle.getMetadataEntry().getCheckpointInterval();
        checkpointInterval.ifPresent(value -> properties.put((Object)"checkpoint_interval", value));
        tableHandle.getAnalyzeHandle().flatMap(AnalyzeHandle::getColumns).ifPresent(analyzeColumns -> properties.put((Object)"$trino.analyze_columns", analyzeColumns));
        return new ConnectorTableMetadata(tableHandle.getSchemaTableName(), columns, (Map)properties.buildOrThrow(), Optional.empty());
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        if (schemaName.isPresent() && schemaName.get().equals("information_schema")) {
            return ImmutableList.of();
        }
        return (List)schemaName.map(Collections::singletonList).orElseGet(() -> this.listSchemaNames(session)).stream().flatMap(schema -> this.metastore.getAllTables((String)schema).stream().map(table -> new SchemaTableName(schema, table))).collect(ImmutableList.toImmutableList());
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        DeltaLakeTableHandle table = (DeltaLakeTableHandle)tableHandle;
        return (Map)this.getColumns(table.getMetadataEntry()).stream().collect(ImmutableMap.toImmutableMap(DeltaLakeColumnHandle::getName, Function.identity()));
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return DeltaLakeMetadata.getColumnMetadata((DeltaLakeColumnHandle)columnHandle);
    }

    public Optional<ConnectorTableLayout> getNewTableLayout(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        this.validateTableColumns(tableMetadata);
        List<String> partitionColumnNames = DeltaLakeTableProperties.getPartitionedBy(tableMetadata.getProperties());
        if (partitionColumnNames.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new ConnectorTableLayout(partitionColumnNames));
    }

    public Optional<ConnectorTableLayout> getInsertLayout(ConnectorSession session, ConnectorTableHandle tableHandle) {
        DeltaLakeTableHandle deltaLakeTableHandle = (DeltaLakeTableHandle)tableHandle;
        List<String> partitionColumnNames = deltaLakeTableHandle.getMetadataEntry().getCanonicalPartitionColumns();
        if (partitionColumnNames.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new ConnectorTableLayout(partitionColumnNames));
    }

    public Stream<TableColumnsMetadata> streamTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        if (prefix.getSchema().isPresent() && ((String)prefix.getSchema().get()).equals("information_schema")) {
            return Stream.empty();
        }
        List tables = prefix.getTable().map(ignored -> Collections.singletonList(prefix.toSchemaTableName())).orElseGet(() -> this.listTables(session, prefix.getSchema()));
        return tables.stream().flatMap(table -> {
            try {
                if (this.redirectTable(session, (SchemaTableName)table).isPresent()) {
                    return Stream.of(TableColumnsMetadata.forRedirectedTable((SchemaTableName)table));
                }
                return this.metastore.getMetadata(this.metastore.getSnapshot((SchemaTableName)table, session), session).stream().map(metadata -> {
                    List columnMetadata = (List)this.getColumns((MetadataEntry)metadata).stream().map(DeltaLakeMetadata::getColumnMetadata).collect(ImmutableList.toImmutableList());
                    return TableColumnsMetadata.forTable((SchemaTableName)table, (List)columnMetadata);
                });
            }
            catch (NotADeltaLakeTableException e) {
                if (!this.hideNonDeltaLakeTables) {
                    throw e;
                }
                return Stream.empty();
            }
            catch (RuntimeException e) {
                LOG.debug((Throwable)e, "Ignored exception when trying to list columns from %s", new Object[]{table});
                return Stream.empty();
            }
        });
    }

    private List<DeltaLakeColumnHandle> getColumns(MetadataEntry deltaMetadata) {
        ImmutableList.Builder columns = ImmutableList.builder();
        DeltaLakeSchemaSupport.extractSchema(deltaMetadata, this.typeManager).stream().map(column -> DeltaLakeMetadata.toColumnHandle(column, deltaMetadata.getCanonicalPartitionColumns())).forEach(arg_0 -> ((ImmutableList.Builder)columns).add(arg_0));
        columns.add((Object)DeltaLakeColumnHandle.pathColumnHandle());
        columns.add((Object)DeltaLakeColumnHandle.fileSizeColumnHandle());
        columns.add((Object)DeltaLakeColumnHandle.fileModifiedTimeColumnHandle());
        return columns.build();
    }

    public TableStatistics getTableStatistics(ConnectorSession session, ConnectorTableHandle tableHandle, Constraint constraint) {
        if (!DeltaLakeSessionProperties.isTableStatisticsEnabled(session)) {
            return TableStatistics.empty();
        }
        return this.metastore.getTableStatistics(session, (DeltaLakeTableHandle)tableHandle, constraint);
    }

    public void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties, TrinoPrincipal owner) {
        Optional<String> location = DeltaLakeSchemaProperties.getLocation(properties).map(locationUri -> {
            try {
                this.hdfsEnvironment.getFileSystem(new HdfsEnvironment.HdfsContext(session), new Path(locationUri));
            }
            catch (IOException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SCHEMA_PROPERTY, "Invalid location URI: " + locationUri, (Throwable)e);
            }
            return locationUri;
        });
        Database database = Database.builder().setDatabaseName(schemaName).setLocation(location).setOwnerType(Optional.of(owner.getType())).setOwnerName(Optional.of(owner.getName())).build();
        this.metastore.createDatabase(database);
    }

    public void dropSchema(ConnectorSession session, String schemaName) {
        Optional<Path> location = this.metastore.getDatabase(schemaName).orElseThrow(() -> new SchemaNotFoundException(schemaName)).getLocation().map(Path::new);
        boolean deleteData = location.map(path -> {
            Boolean bl;
            block8: {
                HdfsEnvironment.HdfsContext context = new HdfsEnvironment.HdfsContext(session);
                FileSystem fs = this.hdfsEnvironment.getFileSystem(context, path);
                try {
                    bl = !fs.listLocatedStatus(path).hasNext();
                    if (fs == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (fs != null) {
                            try {
                                fs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | RuntimeException e) {
                        LOG.warn((Throwable)e, "Could not check schema directory '%s'", new Object[]{path});
                        return this.deleteSchemaLocationsFallback;
                    }
                }
                fs.close();
            }
            return bl;
        }).orElse(this.deleteSchemaLocationsFallback);
        this.metastore.dropDatabase(schemaName, deleteData);
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        SchemaTableName schemaTableName = tableMetadata.getTable();
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        Database schema = this.metastore.getDatabase(schemaName).orElseThrow(() -> new SchemaNotFoundException(schemaName));
        boolean external = true;
        String location = DeltaLakeTableProperties.getLocation(tableMetadata.getProperties());
        if (location == null) {
            Optional<String> schemaLocation = this.getSchemaLocation(schema);
            if (schemaLocation.isEmpty()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "The 'location' property must be specified either for the table or the schema");
            }
            location = new Path(schemaLocation.get(), tableName).toString();
            this.checkPathContainsNoFiles(session, new Path(location));
            external = false;
        }
        Path targetPath = new Path(location);
        this.ensurePathExists(session, targetPath);
        Path deltaLogDirectory = TransactionLogUtil.getTransactionLogDir(targetPath);
        Optional<Long> checkpointInterval = DeltaLakeTableProperties.getCheckpointInterval(tableMetadata.getProperties());
        try {
            FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(new HdfsEnvironment.HdfsContext(session), targetPath);
            if (!fileSystem.exists(deltaLogDirectory)) {
                this.validateTableColumns(tableMetadata);
                List<String> partitionColumns = DeltaLakeTableProperties.getPartitionedBy(tableMetadata.getProperties());
                List deltaLakeColumns = (List)tableMetadata.getColumns().stream().map(column -> DeltaLakeMetadata.toColumnHandle(column, partitionColumns)).collect(ImmutableList.toImmutableList());
                TransactionLogWriter transactionLogWriter = this.transactionLogWriterFactory.newWriterWithoutTransactionIsolation(session, targetPath.toString());
                DeltaLakeMetadata.appendInitialTableEntries(transactionLogWriter, deltaLakeColumns, partitionColumns, MetadataEntry.buildDeltaMetadataConfiguration(checkpointInterval), CREATE_TABLE_OPERATION, session, this.nodeVersion, this.nodeId);
                this.setRollback(() -> DeltaLakeMetadata.deleteRecursivelyIfExists(new HdfsEnvironment.HdfsContext(session), this.hdfsEnvironment, deltaLogDirectory));
                transactionLogWriter.flush();
            }
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, "Unable to access file system for: " + location, (Throwable)e);
        }
        Table.Builder tableBuilder = Table.builder().setDatabaseName(schemaName).setTableName(tableName).setOwner(Optional.of(session.getUser())).setTableType(external ? TableType.EXTERNAL_TABLE.name() : TableType.MANAGED_TABLE.name()).setDataColumns(DUMMY_DATA_COLUMNS).setParameters(DeltaLakeMetadata.deltaTableProperties(session, location, external));
        DeltaLakeMetadata.setDeltaStorageFormat(tableBuilder, location, targetPath);
        Table table = tableBuilder.build();
        PrincipalPrivileges principalPrivileges = MetastoreUtil.buildInitialPrivilegeSet((String)((String)table.getOwner().orElseThrow()));
        this.metastore.createTable(session, table, principalPrivileges);
    }

    private static Map<String, String> deltaTableProperties(ConnectorSession session, String location, boolean external) {
        ImmutableMap.Builder properties = ImmutableMap.builder().put((Object)"presto_query_id", (Object)session.getQueryId()).put((Object)"location", (Object)location).put((Object)"spark.sql.sources.provider", (Object)"DELTA").put((Object)"numFiles", (Object)"-1").put((Object)"totalSize", (Object)"-1");
        if (external) {
            properties.put((Object)"EXTERNAL", (Object)"TRUE");
        }
        return properties.buildOrThrow();
    }

    private static void setDeltaStorageFormat(Table.Builder tableBuilder, String location, Path targetPath) {
        tableBuilder.getStorageBuilder().setStorageFormat(DELTA_STORAGE_FORMAT).setSerdeParameters((Map)ImmutableMap.of((Object)PATH_PROPERTY, (Object)location)).setLocation(targetPath.toString());
    }

    private Path getExternalPath(HdfsEnvironment.HdfsContext context, String location) {
        try {
            Path path = new Path(location);
            if (!HiveWriteUtils.isS3FileSystem((HdfsEnvironment.HdfsContext)context, (HdfsEnvironment)this.hdfsEnvironment, (Path)path) && !this.hdfsEnvironment.getFileSystem(context, path).getFileStatus(path).isDirectory()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "External location must be a directory: " + location);
            }
            return path;
        }
        catch (IOException | IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "External location is not a valid file system URI: " + location, (Throwable)e);
        }
    }

    public DeltaLakeOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorTableLayout> layout) {
        this.validateTableColumns(tableMetadata);
        SchemaTableName schemaTableName = tableMetadata.getTable();
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        Database schema = this.metastore.getDatabase(schemaName).orElseThrow(() -> new SchemaNotFoundException(schemaName));
        List<String> partitionedBy = DeltaLakeTableProperties.getPartitionedBy(tableMetadata.getProperties());
        boolean external = true;
        String location = DeltaLakeTableProperties.getLocation(tableMetadata.getProperties());
        if (location == null) {
            Optional<String> schemaLocation = this.getSchemaLocation(schema);
            if (schemaLocation.isEmpty()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "The 'location' property must be specified either for the table or the schema");
            }
            location = new Path(schemaLocation.get(), tableName).toString();
            external = false;
        }
        Path targetPath = new Path(location);
        this.ensurePathExists(session, targetPath);
        HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session);
        HiveWriteUtils.createDirectory((HdfsEnvironment.HdfsContext)hdfsContext, (HdfsEnvironment)this.hdfsEnvironment, (Path)targetPath);
        this.checkPathContainsNoFiles(session, targetPath);
        this.setRollback(() -> DeltaLakeMetadata.deleteRecursivelyIfExists(new HdfsEnvironment.HdfsContext(session), this.hdfsEnvironment, targetPath));
        return new DeltaLakeOutputTableHandle(schemaName, tableName, (List)tableMetadata.getColumns().stream().map(column -> DeltaLakeMetadata.toColumnHandle(column, partitionedBy)).collect(ImmutableList.toImmutableList()), location, DeltaLakeTableProperties.getCheckpointInterval(tableMetadata.getProperties()), external);
    }

    private Optional<String> getSchemaLocation(Database database) {
        Optional schemaLocation = database.getLocation();
        if (schemaLocation.isEmpty() || ((String)schemaLocation.get()).isEmpty()) {
            return Optional.empty();
        }
        return schemaLocation;
    }

    private void ensurePathExists(ConnectorSession session, Path directoryPath) {
        HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session);
        if (!HiveWriteUtils.pathExists((HdfsEnvironment.HdfsContext)hdfsContext, (HdfsEnvironment)this.hdfsEnvironment, (Path)directoryPath)) {
            HiveWriteUtils.createDirectory((HdfsEnvironment.HdfsContext)hdfsContext, (HdfsEnvironment)this.hdfsEnvironment, (Path)directoryPath);
        }
    }

    private void checkPathContainsNoFiles(ConnectorSession session, Path targetPath) {
        try {
            RemoteIterator filesIterator;
            FileSystem fs = this.hdfsEnvironment.getFileSystem(new HdfsEnvironment.HdfsContext(session), targetPath.getParent());
            if (fs.exists(targetPath) && (filesIterator = fs.listStatusIterator(targetPath)).hasNext()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Target location cannot contain any files: " + targetPath);
            }
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, "Unable to access file system for: " + targetPath, (Throwable)e);
        }
    }

    private void validateTableColumns(ConnectorTableMetadata tableMetadata) {
        DeltaLakeMetadata.checkPartitionColumns(tableMetadata.getColumns(), DeltaLakeTableProperties.getPartitionedBy(tableMetadata.getProperties()));
        this.checkColumnTypes(tableMetadata.getColumns());
    }

    private static void checkPartitionColumns(List<ColumnMetadata> columns, List<String> partitionColumnNames) {
        Set columnNames = (Set)columns.stream().map(ColumnMetadata::getName).collect(ImmutableSet.toImmutableSet());
        List invalidPartitionNames = (List)partitionColumnNames.stream().filter(partitionColumnName -> !columnNames.contains(partitionColumnName)).collect(ImmutableList.toImmutableList());
        if (!invalidPartitionNames.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, "Table property 'partition_by' contained column names which do not exist: " + invalidPartitionNames);
        }
    }

    private void checkColumnTypes(List<ColumnMetadata> columnMetadata) {
        for (ColumnMetadata column : columnMetadata) {
            Type type = column.getType();
            DeltaLakeSchemaSupport.validateType(type);
        }
    }

    private static boolean deleteRecursivelyIfExists(HdfsEnvironment.HdfsContext context, HdfsEnvironment hdfsEnvironment, Path path) {
        FileSystem fileSystem;
        try {
            fileSystem = hdfsEnvironment.getFileSystem(context, path);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "IOException while trying to delete '%s'", new Object[]{path});
            return false;
        }
        return DeltaLakeMetadata.deleteIfExists(fileSystem, path, true);
    }

    private static boolean deleteIfExists(FileSystem fileSystem, Path path, boolean recursive) {
        try {
            if (fileSystem.delete(path, recursive)) {
                return true;
            }
            return !fileSystem.exists(path);
        }
        catch (FileNotFoundException ignored) {
            return true;
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "IOException while trying to delete '%s'", new Object[]{path});
            return false;
        }
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        DeltaLakeOutputTableHandle handle = (DeltaLakeOutputTableHandle)tableHandle;
        String schemaName = handle.getSchemaName();
        String tableName = handle.getTableName();
        String location = handle.getLocation();
        List dataFileInfos = (List)fragments.stream().map(Slice::getBytes).map(arg_0 -> this.dataFileInfoCodec.fromJson(arg_0)).collect(ImmutableList.toImmutableList());
        Table.Builder tableBuilder = Table.builder().setDatabaseName(schemaName).setTableName(tableName).setOwner(Optional.of(session.getUser())).setTableType(handle.isExternal() ? TableType.EXTERNAL_TABLE.name() : TableType.MANAGED_TABLE.name()).setDataColumns(DUMMY_DATA_COLUMNS).setParameters(DeltaLakeMetadata.deltaTableProperties(session, location, handle.isExternal()));
        DeltaLakeMetadata.setDeltaStorageFormat(tableBuilder, location, this.getExternalPath(new HdfsEnvironment.HdfsContext(session), location));
        Table table = tableBuilder.build();
        try {
            TransactionLogWriter transactionLogWriter = this.transactionLogWriterFactory.newWriterWithoutTransactionIsolation(session, handle.getLocation());
            DeltaLakeMetadata.appendInitialTableEntries(transactionLogWriter, handle.getInputColumns(), handle.getPartitionedBy(), MetadataEntry.buildDeltaMetadataConfiguration(handle.getCheckpointInterval()), CREATE_TABLE_AS_OPERATION, session, this.nodeVersion, this.nodeId);
            DeltaLakeMetadata.appendAddFileEntries(transactionLogWriter, dataFileInfos, handle.getPartitionedBy(), true);
            transactionLogWriter.flush();
            PrincipalPrivileges principalPrivileges = MetastoreUtil.buildInitialPrivilegeSet((String)((String)table.getOwner().orElseThrow()));
            this.metastore.createTable(session, table, principalPrivileges);
        }
        catch (Exception e) {
            try {
                Path transactionLogLocation = TransactionLogUtil.getTransactionLogDir(new Path(handle.getLocation()));
                FileSystem fs = this.hdfsEnvironment.getFileSystem(new HdfsEnvironment.HdfsContext(session), transactionLogLocation);
                fs.delete(transactionLogLocation, true);
            }
            catch (IOException ioException) {
                LOG.error((Throwable)ioException, "Transaction log cleanup failed during CREATE TABLE rollback");
            }
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, "Failed to write Delta Lake transaction log entry", (Throwable)e);
        }
        return Optional.empty();
    }

    private static void appendInitialTableEntries(TransactionLogWriter transactionLogWriter, List<DeltaLakeColumnHandle> columns, List<String> partitionColumnNames, Map<String, String> configuration, String operation, ConnectorSession session, String nodeVersion, String nodeId) {
        long createdTime = System.currentTimeMillis();
        transactionLogWriter.appendCommitInfoEntry(new CommitInfoEntry(0L, createdTime, session.getUser(), session.getUser(), operation, (Map<String, String>)ImmutableMap.of((Object)"queryId", (Object)session.getQueryId()), null, null, "trino-" + nodeVersion + "-" + nodeId, 0L, ISOLATION_LEVEL, true));
        transactionLogWriter.appendProtocolEntry(new ProtocolEntry(1, 2));
        transactionLogWriter.appendMetadataEntry(new MetadataEntry(UUID.randomUUID().toString(), null, null, new MetadataEntry.Format("parquet", (Map<String, String>)ImmutableMap.of()), DeltaLakeSchemaSupport.serializeSchemaAsJson(columns), partitionColumnNames, (Map<String, String>)ImmutableMap.copyOf(configuration), createdTime));
    }

    private static void appendAddFileEntries(TransactionLogWriter transactionLogWriter, List<DataFileInfo> dataFileInfos, List<String> partitionColumnNames, boolean dataChange) throws JsonProcessingException {
        for (DataFileInfo info : dataFileInfos) {
            HashMap<String, String> partitionValues = new HashMap<String, String>();
            for (int i = 0; i < partitionColumnNames.size(); ++i) {
                partitionValues.put(partitionColumnNames.get(i), info.getPartitionValues().get(i));
            }
            partitionValues = Collections.unmodifiableMap(partitionValues);
            transactionLogWriter.appendAddFileEntry(new AddFileEntry(DeltaLakeMetadata.toUriFormat(info.getPath()), partitionValues, info.getSize(), info.getCreationTime(), dataChange, Optional.of(DeltaLakeSchemaSupport.serializeStatsAsJson(info.getStatistics())), Optional.empty(), (Map<String, String>)ImmutableMap.of()));
        }
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> columns) {
        DeltaLakeTableHandle table = (DeltaLakeTableHandle)tableHandle;
        if (!this.allowWrite(session, table)) {
            String fileSystem = new Path(table.getLocation()).toUri().getScheme();
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Inserts are not supported on the %s filesystem", fileSystem));
        }
        this.checkSupportedWriterVersion(session, table.getSchemaTableName());
        List inputColumns = (List)columns.stream().map(handle -> (DeltaLakeColumnHandle)handle).collect(ImmutableList.toImmutableList());
        ConnectorTableMetadata tableMetadata = this.getTableMetadata(session, table);
        this.checkAllColumnsPassedOnInsert(tableMetadata, inputColumns);
        String tableLocation = DeltaLakeTableProperties.getLocation(tableMetadata.getProperties());
        try {
            FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(new HdfsEnvironment.HdfsContext(session), new Path(tableLocation));
            return new DeltaLakeInsertTableHandle(table.getSchemaName(), table.getTableName(), tableLocation, table.getMetadataEntry(), inputColumns, TransactionLogParser.getMandatoryCurrentVersion(fileSystem, new Path(tableLocation)));
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, (Throwable)e);
        }
    }

    private void checkAllColumnsPassedOnInsert(ConnectorTableMetadata tableMetadata, List<DeltaLakeColumnHandle> insertColumns) {
        List allColumnNames = (List)tableMetadata.getColumns().stream().filter(Predicate.not(ColumnMetadata::isHidden)).map(ColumnMetadata::getName).collect(ImmutableList.toImmutableList());
        List insertColumnNames = (List)insertColumns.stream().map(DeltaLakeColumnHandle::getName).collect(ImmutableList.toImmutableList());
        Preconditions.checkArgument((boolean)allColumnNames.equals(insertColumnNames), (String)"Not all table columns passed on INSERT; table columns=%s; insert columns=%s", (Object)allColumnNames, (Object)insertColumnNames);
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        DeltaLakeInsertTableHandle handle = (DeltaLakeInsertTableHandle)insertHandle;
        List dataFileInfos = (List)fragments.stream().map(Slice::getBytes).map(arg_0 -> this.dataFileInfoCodec.fromJson(arg_0)).collect(ImmutableList.toImmutableList());
        boolean writeCommitted = false;
        try {
            TransactionLogWriter transactionLogWriter = this.transactionLogWriterFactory.newWriter(session, handle.getLocation());
            long createdTime = Instant.now().toEpochMilli();
            FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(new HdfsEnvironment.HdfsContext(session), new Path(handle.getLocation()));
            long commitVersion = TransactionLogParser.getMandatoryCurrentVersion(fileSystem, new Path(handle.getLocation())) + 1L;
            if (commitVersion != handle.getReadVersion() + 1L) {
                throw new TransactionConflictException(String.format("Conflicting concurrent writes found. Expected transaction log version: %s, actual version: %s", handle.getReadVersion(), commitVersion - 1L));
            }
            Optional<Long> checkpointInterval = handle.getMetadataEntry().getCheckpointInterval();
            transactionLogWriter.appendCommitInfoEntry(new CommitInfoEntry(commitVersion, createdTime, session.getUser(), session.getUser(), INSERT_OPERATION, (Map<String, String>)ImmutableMap.of((Object)"queryId", (Object)session.getQueryId()), null, null, "trino-" + this.nodeVersion + "-" + this.nodeId, handle.getReadVersion(), ISOLATION_LEVEL, true));
            List<String> partitionColumns = handle.getMetadataEntry().getOriginalPartitionColumns();
            DeltaLakeMetadata.appendAddFileEntries(transactionLogWriter, dataFileInfos, partitionColumns, true);
            transactionLogWriter.flush();
            writeCommitted = true;
            this.writeCheckpointIfNeeded(session, new SchemaTableName(handle.getSchemaName(), handle.getTableName()), checkpointInterval, commitVersion);
        }
        catch (Exception e) {
            if (!writeCommitted) {
                this.cleanupFailedWrite(session, handle.getLocation(), dataFileInfos);
            }
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, "Failed to write Delta Lake transaction log entry", (Throwable)e);
        }
        return Optional.empty();
    }

    public ColumnHandle getDeleteRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return new DeltaLakeColumnHandle("$row_id", DeltaLakeColumnHandle.ROW_ID_COLUMN_TYPE, DeltaLakeColumnType.SYNTHESIZED);
    }

    public ConnectorTableHandle beginDelete(ConnectorSession session, ConnectorTableHandle tableHandle) {
        DeltaLakeTableHandle handle = (DeltaLakeTableHandle)tableHandle;
        if (!this.allowWrite(session, handle)) {
            String fileSystem = new Path(handle.getLocation()).toUri().getScheme();
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Deletes are not supported on the %s filesystem", fileSystem));
        }
        this.checkSupportedWriterVersion(session, handle.getSchemaTableName());
        return DeltaLakeTableHandle.forDelete(handle.getSchemaName(), handle.getTableName(), handle.getLocation(), Optional.of(handle.getMetadataEntry()), handle.getEnforcedPartitionConstraint(), handle.getNonPartitionConstraint(), handle.getProjectedColumns(), handle.getReadVersion());
    }

    public void finishDelete(ConnectorSession session, ConnectorTableHandle tableHandle, Collection<Slice> fragments) {
        this.finishWrite(session, tableHandle, fragments);
    }

    public ColumnHandle getUpdateRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> updatedColumns) {
        RowType rowIdType;
        DeltaLakeTableHandle handle = (DeltaLakeTableHandle)tableHandle;
        List<DeltaLakeColumnHandle> unmodifiedColumns = this.getUnmodifiedColumns(handle, updatedColumns);
        if (unmodifiedColumns.isEmpty()) {
            rowIdType = RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((Type)BigintType.BIGINT)});
        } else {
            List unmodifiedColumnFields = (List)unmodifiedColumns.stream().map(columnMetadata -> RowType.field((String)columnMetadata.getName(), (Type)columnMetadata.getType())).collect(ImmutableList.toImmutableList());
            rowIdType = RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((Type)BigintType.BIGINT), RowType.field((Type)RowType.from((List)unmodifiedColumnFields))});
        }
        return new DeltaLakeColumnHandle("$row_id", (Type)rowIdType, DeltaLakeColumnType.SYNTHESIZED);
    }

    public ConnectorTableHandle beginUpdate(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> updatedColumns) {
        DeltaLakeTableHandle handle = (DeltaLakeTableHandle)tableHandle;
        if (!this.allowWrite(session, handle)) {
            String fileSystem = new Path(handle.getLocation()).toUri().getScheme();
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Updates are not supported on the %s filesystem", fileSystem));
        }
        this.checkSupportedWriterVersion(session, handle.getSchemaTableName());
        List updatedColumnHandles = (List)updatedColumns.stream().map(columnHandle -> (DeltaLakeColumnHandle)columnHandle).collect(ImmutableList.toImmutableList());
        ImmutableSet partitionColumnNames = ImmutableSet.copyOf(handle.getMetadataEntry().getCanonicalPartitionColumns());
        if (updatedColumnHandles.stream().map(DeltaLakeColumnHandle::getName).anyMatch(((Set)partitionColumnNames)::contains)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Updating table partition columns is not supported");
        }
        List<DeltaLakeColumnHandle> unmodifiedColumns = this.getUnmodifiedColumns(handle, updatedColumns);
        return DeltaLakeTableHandle.forUpdate(handle.getSchemaName(), handle.getTableName(), handle.getLocation(), Optional.of(handle.getMetadataEntry()), handle.getEnforcedPartitionConstraint(), handle.getNonPartitionConstraint(), handle.getProjectedColumns(), updatedColumnHandles, unmodifiedColumns, handle.getReadVersion());
    }

    public void finishUpdate(ConnectorSession session, ConnectorTableHandle tableHandle, Collection<Slice> fragments) {
        this.finishWrite(session, tableHandle, fragments);
    }

    public Optional<ConnectorTableExecuteHandle> getTableHandleForExecute(ConnectorSession session, ConnectorTableHandle connectorTableHandle, String procedureName, Map<String, Object> executeProperties) {
        DeltaLakeTableProcedureId procedureId;
        DeltaLakeTableHandle tableHandle = (DeltaLakeTableHandle)connectorTableHandle;
        try {
            procedureId = DeltaLakeTableProcedureId.valueOf(procedureName);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unknown procedure '" + procedureName + "'");
        }
        switch (procedureId) {
            case OPTIMIZE: {
                return this.getTableHandleForOptimize(tableHandle, executeProperties);
            }
        }
        throw new IllegalArgumentException("Unknown procedure: " + procedureId);
    }

    private Optional<ConnectorTableExecuteHandle> getTableHandleForOptimize(DeltaLakeTableHandle tableHandle, Map<String, Object> executeProperties) {
        DataSize maxScannedFileSize = (DataSize)executeProperties.get("file_size_threshold");
        List columns = (List)this.getColumns(tableHandle.getMetadataEntry()).stream().filter(column -> column.getColumnType() != DeltaLakeColumnType.SYNTHESIZED).collect(ImmutableList.toImmutableList());
        return Optional.of(new DeltaLakeTableExecuteHandle(tableHandle.getSchemaTableName(), DeltaLakeTableProcedureId.OPTIMIZE, new DeltaTableOptimizeHandle(tableHandle.getMetadataEntry(), columns, tableHandle.getMetadataEntry().getOriginalPartitionColumns(), maxScannedFileSize, Optional.empty()), tableHandle.getLocation()));
    }

    public Optional<ConnectorTableLayout> getLayoutForTableExecute(ConnectorSession session, ConnectorTableExecuteHandle tableExecuteHandle) {
        DeltaLakeTableExecuteHandle executeHandle = (DeltaLakeTableExecuteHandle)tableExecuteHandle;
        switch (executeHandle.getProcedureId()) {
            case OPTIMIZE: {
                return this.getLayoutForOptimize(executeHandle);
            }
        }
        throw new IllegalArgumentException("Unknown procedure '" + executeHandle.getProcedureId() + "'");
    }

    private Optional<ConnectorTableLayout> getLayoutForOptimize(DeltaLakeTableExecuteHandle executeHandle) {
        DeltaTableOptimizeHandle optimizeHandle = (DeltaTableOptimizeHandle)executeHandle.getProcedureHandle();
        List<String> partitionColumnNames = optimizeHandle.getMetadataEntry().getCanonicalPartitionColumns();
        if (partitionColumnNames.isEmpty()) {
            return Optional.empty();
        }
        Map columnsByName = (Map)optimizeHandle.getTableColumns().stream().collect(ImmutableMap.toImmutableMap(columnHandle -> columnHandle.getName().toLowerCase(Locale.ENGLISH), Function.identity()));
        ImmutableList.Builder partitioningColumns = ImmutableList.builder();
        for (String columnName : partitionColumnNames) {
            partitioningColumns.add((Object)((DeltaLakeColumnHandle)columnsByName.get(columnName)));
        }
        DeltaLakePartitioningHandle partitioningHandle = new DeltaLakePartitioningHandle((List<DeltaLakeColumnHandle>)partitioningColumns.build());
        return Optional.of(new ConnectorTableLayout((ConnectorPartitioningHandle)partitioningHandle, partitionColumnNames));
    }

    public BeginTableExecuteResult<ConnectorTableExecuteHandle, ConnectorTableHandle> beginTableExecute(ConnectorSession session, ConnectorTableExecuteHandle tableExecuteHandle, ConnectorTableHandle updatedSourceTableHandle) {
        DeltaLakeTableExecuteHandle executeHandle = (DeltaLakeTableExecuteHandle)tableExecuteHandle;
        DeltaLakeTableHandle table = (DeltaLakeTableHandle)updatedSourceTableHandle;
        switch (executeHandle.getProcedureId()) {
            case OPTIMIZE: {
                return this.beginOptimize(session, executeHandle, table);
            }
        }
        throw new IllegalArgumentException("Unknown procedure '" + executeHandle.getProcedureId() + "'");
    }

    private BeginTableExecuteResult<ConnectorTableExecuteHandle, ConnectorTableHandle> beginOptimize(ConnectorSession session, DeltaLakeTableExecuteHandle executeHandle, DeltaLakeTableHandle table) {
        DeltaTableOptimizeHandle optimizeHandle = (DeltaTableOptimizeHandle)executeHandle.getProcedureHandle();
        if (!this.allowWrite(session, table)) {
            String fileSystem = new Path(table.getLocation()).toUri().getScheme();
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Optimize is not supported on the %s filesystem", fileSystem));
        }
        this.checkSupportedWriterVersion(session, table.getSchemaTableName());
        return new BeginTableExecuteResult((Object)executeHandle.withProcedureHandle(optimizeHandle.withCurrentVersion(table.getReadVersion())), (Object)table.forOptimize(true, optimizeHandle.getMaxScannedFileSize()));
    }

    public void finishTableExecute(ConnectorSession session, ConnectorTableExecuteHandle tableExecuteHandle, Collection<Slice> fragments, List<Object> splitSourceInfo) {
        DeltaLakeTableExecuteHandle executeHandle = (DeltaLakeTableExecuteHandle)tableExecuteHandle;
        switch (executeHandle.getProcedureId()) {
            case OPTIMIZE: {
                this.finishOptimize(session, executeHandle, fragments, splitSourceInfo);
                return;
            }
        }
        throw new IllegalArgumentException("Unknown procedure '" + executeHandle.getProcedureId() + "'");
    }

    private void finishOptimize(ConnectorSession session, DeltaLakeTableExecuteHandle executeHandle, Collection<Slice> fragments, List<Object> splitSourceInfo) {
        DeltaTableOptimizeHandle optimizeHandle = (DeltaTableOptimizeHandle)executeHandle.getProcedureHandle();
        long readVersion = optimizeHandle.getCurrentVersion().orElseThrow(() -> new IllegalArgumentException("currentVersion not set"));
        Optional<Long> checkpointInterval = optimizeHandle.getMetadataEntry().getCheckpointInterval();
        String tableLocation = executeHandle.getTableLocation();
        Set scannedPaths = (Set)splitSourceInfo.stream().map(file -> new Path((String)file)).collect(ImmutableSet.toImmutableSet());
        List dataFileInfos = (List)fragments.stream().map(Slice::getBytes).map(arg_0 -> this.dataFileInfoCodec.fromJson(arg_0)).collect(ImmutableList.toImmutableList());
        boolean writeCommitted = false;
        try {
            TransactionLogWriter transactionLogWriter = this.transactionLogWriterFactory.newWriter(session, tableLocation);
            long createdTime = Instant.now().toEpochMilli();
            long commitVersion = readVersion + 1L;
            transactionLogWriter.appendCommitInfoEntry(new CommitInfoEntry(commitVersion, createdTime, session.getUser(), session.getUser(), OPTIMIZE_OPERATION, (Map<String, String>)ImmutableMap.of((Object)"queryId", (Object)session.getQueryId()), null, null, "trino-" + this.nodeVersion + "-" + this.nodeId, readVersion, ISOLATION_LEVEL, true));
            long writeTimestamp = Instant.now().toEpochMilli();
            for (Path scannedPath : scannedPaths) {
                String relativePath = new Path(tableLocation).toUri().relativize(scannedPath.toUri()).toString();
                transactionLogWriter.appendRemoveFileEntry(new RemoveFileEntry(relativePath, writeTimestamp, false));
            }
            List<String> partitionColumns = optimizeHandle.getMetadataEntry().getOriginalPartitionColumns();
            DeltaLakeMetadata.appendAddFileEntries(transactionLogWriter, dataFileInfos, partitionColumns, false);
            transactionLogWriter.flush();
            writeCommitted = true;
            this.writeCheckpointIfNeeded(session, executeHandle.getSchemaTableName(), checkpointInterval, commitVersion);
        }
        catch (Exception e) {
            if (!writeCommitted) {
                this.cleanupFailedWrite(session, tableLocation, dataFileInfos);
            }
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, "Failed to write Delta Lake transaction log entry", (Throwable)e);
        }
    }

    private boolean allowWrite(ConnectorSession session, DeltaLakeTableHandle tableHandle) {
        boolean requiresOptIn = this.transactionLogWriterFactory.newWriter(session, tableHandle.getLocation()).isUnsafe();
        return !requiresOptIn || this.unsafeWritesEnabled;
    }

    private void checkSupportedWriterVersion(ConnectorSession session, SchemaTableName schemaTableName) {
        int requiredWriterVersion = this.metastore.getProtocol(session, this.metastore.getSnapshot(schemaTableName, session)).getMinWriterVersion();
        if (requiredWriterVersion > 2) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Table %s requires Delta Lake writer version %d which is not supported", schemaTableName, requiredWriterVersion));
        }
    }

    private List<DeltaLakeColumnHandle> getUnmodifiedColumns(DeltaLakeTableHandle tableHandle, List<ColumnHandle> updatedColumns) {
        Set updatedColumnHandles = (Set)updatedColumns.stream().map(columnHandle -> (DeltaLakeColumnHandle)columnHandle).collect(ImmutableSet.toImmutableSet());
        ImmutableSet partitionColumnNames = ImmutableSet.copyOf(tableHandle.getMetadataEntry().getCanonicalPartitionColumns());
        List<ColumnMetadata> allColumns = DeltaLakeSchemaSupport.extractSchema(tableHandle.getMetadataEntry(), this.typeManager);
        return (List)allColumns.stream().map(arg_0 -> DeltaLakeMetadata.lambda$getUnmodifiedColumns$30((Set)partitionColumnNames, arg_0)).filter(columnHandle -> !updatedColumnHandles.contains(columnHandle)).filter(arg_0 -> DeltaLakeMetadata.lambda$getUnmodifiedColumns$32((Set)partitionColumnNames, arg_0)).collect(ImmutableList.toImmutableList());
    }

    private void finishWrite(ConnectorSession session, ConnectorTableHandle tableHandle, Collection<Slice> fragments) {
        String operation;
        DeltaLakeTableHandle handle = (DeltaLakeTableHandle)tableHandle;
        List updateResults = (List)fragments.stream().map(Slice::getBytes).map(arg_0 -> this.deleteResultJsonCodec.fromJson(arg_0)).collect(ImmutableList.toImmutableList());
        String tableLocation = this.metastore.getTableLocation(handle.getSchemaTableName(), session);
        DeltaLakeTableHandle.WriteType writeType = handle.getWriteType().orElseThrow();
        switch (writeType) {
            case DELETE: {
                operation = DELETE_OPERATION;
                break;
            }
            case UPDATE: {
                operation = UPDATE_OPERATION;
                break;
            }
            default: {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported write type: " + writeType);
            }
        }
        boolean writeCommitted = false;
        try {
            TransactionLogWriter transactionLogWriter = this.transactionLogWriterFactory.newWriter(session, tableLocation);
            long createdTime = Instant.now().toEpochMilli();
            FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(new HdfsEnvironment.HdfsContext(session), new Path(tableLocation));
            long commitVersion = TransactionLogParser.getMandatoryCurrentVersion(fileSystem, new Path(tableLocation)) + 1L;
            if (commitVersion != handle.getReadVersion() + 1L) {
                throw new TransactionConflictException(String.format("Conflicting concurrent writes found. Expected transaction log version: %s, actual version: %s", handle.getReadVersion(), commitVersion - 1L));
            }
            Optional<Long> checkpointInterval = handle.getMetadataEntry().getCheckpointInterval();
            transactionLogWriter.appendCommitInfoEntry(new CommitInfoEntry(commitVersion, createdTime, session.getUser(), session.getUser(), operation, (Map<String, String>)ImmutableMap.of((Object)"queryId", (Object)session.getQueryId()), null, null, "trino-" + this.nodeVersion + "-" + this.nodeId, 0L, ISOLATION_LEVEL, true));
            long writeTimestamp = Instant.now().toEpochMilli();
            for (DeltaLakeUpdateResult updateResult : updateResults) {
                transactionLogWriter.appendRemoveFileEntry(new RemoveFileEntry(updateResult.getOldFile(), writeTimestamp, true));
            }
            DeltaLakeMetadata.appendAddFileEntries(transactionLogWriter, (List)updateResults.stream().map(DeltaLakeUpdateResult::getNewFile).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList()), handle.getMetadataEntry().getOriginalPartitionColumns(), true);
            transactionLogWriter.flush();
            writeCommitted = true;
            this.writeCheckpointIfNeeded(session, new SchemaTableName(handle.getSchemaName(), handle.getTableName()), checkpointInterval, commitVersion);
        }
        catch (Exception e) {
            if (!writeCommitted) {
                this.cleanupFailedWrite(session, tableLocation, (List)updateResults.stream().map(DeltaLakeUpdateResult::getNewFile).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList()));
            }
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, "Failed to write Delta Lake transaction log entry", (Throwable)e);
        }
    }

    private void writeCheckpointIfNeeded(ConnectorSession session, SchemaTableName table, Optional<Long> checkpointInterval, long newVersion) {
        try {
            TableSnapshot snapshot = this.metastore.getSnapshot(table, session);
            long lastCheckpointVersion = snapshot.getLastCheckpointVersion().orElse(0L);
            if (newVersion - lastCheckpointVersion < checkpointInterval.orElse(this.defaultCheckpointInterval)) {
                return;
            }
            if (snapshot.getVersion() > newVersion) {
                LOG.info("Snapshot for table %s already at version %s when checkpoint requested for version %s", new Object[]{table, snapshot.getVersion(), newVersion});
            }
            this.checkpointWriterManager.writeCheckpoint(session, snapshot);
        }
        catch (Exception e) {
            if (this.ignoreCheckpointWriteFailures) {
                LOG.warn((Throwable)e, "Failed to write checkpoint for table %s for version %s", new Object[]{table, newVersion});
            }
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Failed to write checkpoint for table %s for version %s", table, newVersion), (Throwable)e);
        }
    }

    private void cleanupFailedWrite(ConnectorSession session, String tableLocation, List<DataFileInfo> dataFiles) {
        try {
            FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(new HdfsEnvironment.HdfsContext(session), new Path(tableLocation));
            for (DataFileInfo dataFile : dataFiles) {
                fileSystem.delete(new Path(tableLocation, dataFile.getPath()), false);
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e, "Failed cleanup of leftover files from failed write, files are: %s", new Object[]{dataFiles.stream().map(dataFileInfo -> new Path(tableLocation, dataFileInfo.getPath())).collect(ImmutableList.toImmutableList())});
        }
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        DeltaLakeTableHandle handle = (DeltaLakeTableHandle)tableHandle;
        Optional<Table> table = this.metastore.getTable(handle.getSchemaName(), handle.getTableName());
        if (table.isEmpty()) {
            throw new TableNotFoundException(handle.getSchemaTableName());
        }
        this.metastore.dropTable(session, handle.getSchemaName(), handle.getTableName());
    }

    public Map<String, Object> getSchemaProperties(ConnectorSession session, CatalogSchemaName schemaName) {
        String schema = schemaName.getSchemaName();
        Preconditions.checkState((!schema.equals("information_schema") && !schema.equals("sys") ? 1 : 0) != 0, (String)"Schema is not accessible: %s", (Object)schemaName);
        Optional<Database> db = this.metastore.getDatabase(schema);
        return db.map(DeltaLakeSchemaProperties::fromDatabase).orElseThrow(() -> new SchemaNotFoundException(schema));
    }

    private List<SchemaTableName> listTables(ConnectorSession session, SchemaTablePrefix prefix) {
        if (prefix.getTable().isEmpty()) {
            return this.listTables(session, prefix.getSchema());
        }
        SchemaTableName tableName = prefix.toSchemaTableName();
        return (List)this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName()).map(table -> ImmutableList.of((Object)tableName)).orElse(ImmutableList.of());
    }

    private void setRollback(Runnable action) {
        Preconditions.checkState((boolean)this.rollbackAction.compareAndSet(null, action), (Object)"rollback action is already set");
    }

    private static String toUriFormat(String path) {
        return new Path(path).toUri().toString();
    }

    public void rollback() {
        Optional.ofNullable(this.rollbackAction.getAndSet(null)).ifPresent(Runnable::run);
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle handle, Constraint constraint) {
        DeltaLakeTableHandle tableHandle = (DeltaLakeTableHandle)handle;
        SchemaTableName tableName = tableHandle.getSchemaTableName();
        ImmutableSet partitionColumns = ImmutableSet.copyOf(DeltaLakeSchemaSupport.extractPartitionColumns(tableHandle.getMetadataEntry(), this.typeManager));
        Verify.verify((!constraint.getSummary().isNone() ? 1 : 0) != 0, (String)"applyFilter constraint has summary NONE", (Object[])new Object[0]);
        Map constraintDomains = (Map)constraint.getSummary().getDomains().orElseThrow();
        ImmutableMap.Builder enforceableDomains = ImmutableMap.builder();
        ImmutableMap.Builder unenforceableDomains = ImmutableMap.builder();
        for (Map.Entry domainEntry : constraintDomains.entrySet()) {
            DeltaLakeColumnHandle column = (DeltaLakeColumnHandle)domainEntry.getKey();
            if (!partitionColumns.contains(column)) {
                unenforceableDomains.put((Object)column, (Object)((Domain)domainEntry.getValue()));
                continue;
            }
            enforceableDomains.put((Object)column, (Object)((Domain)domainEntry.getValue()));
        }
        TupleDomain newEnforcedConstraint = TupleDomain.withColumnDomains((Map)enforceableDomains.buildOrThrow());
        TupleDomain newUnenforcedConstraint = TupleDomain.withColumnDomains((Map)unenforceableDomains.buildOrThrow());
        DeltaLakeTableHandle newHandle = new DeltaLakeTableHandle(tableName.getSchemaName(), tableName.getTableName(), tableHandle.getLocation(), Optional.of(tableHandle.getMetadataEntry()), (TupleDomain<DeltaLakeColumnHandle>)tableHandle.getEnforcedPartitionConstraint().intersect(newEnforcedConstraint), (TupleDomain<DeltaLakeColumnHandle>)tableHandle.getNonPartitionConstraint().intersect(newUnenforcedConstraint).simplify(this.domainCompactionThreshold), tableHandle.getWriteType(), tableHandle.getProjectedColumns(), tableHandle.getUpdatedColumns(), tableHandle.getUpdateRowIdColumns(), Optional.empty(), tableHandle.getReadVersion());
        if (tableHandle.getEnforcedPartitionConstraint().equals(newHandle.getEnforcedPartitionConstraint()) && tableHandle.getNonPartitionConstraint().equals(newHandle.getNonPartitionConstraint())) {
            return Optional.empty();
        }
        return Optional.of(new ConstraintApplicationResult((Object)newHandle, newUnenforcedConstraint.transformKeys(ColumnHandle.class::cast), false));
    }

    public Optional<ProjectionApplicationResult<ConnectorTableHandle>> applyProjection(ConnectorSession session, ConnectorTableHandle tableHandle, List<ConnectorExpression> projections, Map<String, ColumnHandle> assignments) {
        DeltaLakeTableHandle deltaLakeTableHandle = (DeltaLakeTableHandle)tableHandle;
        ImmutableSet projectedColumns = ImmutableSet.copyOf(assignments.values());
        if (deltaLakeTableHandle.getProjectedColumns().isPresent() && deltaLakeTableHandle.getProjectedColumns().get().equals(projectedColumns)) {
            return Optional.empty();
        }
        List simpleProjections = (List)projections.stream().filter(projection -> projection instanceof Variable).collect(ImmutableList.toImmutableList());
        List newColumnAssignments = (List)assignments.entrySet().stream().map(assignment -> new Assignment((String)assignment.getKey(), (ColumnHandle)assignment.getValue(), ((DeltaLakeColumnHandle)assignment.getValue()).getType())).collect(ImmutableList.toImmutableList());
        return Optional.of(new ProjectionApplicationResult((Object)deltaLakeTableHandle.withProjectedColumns((Set<ColumnHandle>)projectedColumns), simpleProjections, newColumnAssignments, false));
    }

    @Nullable
    public ConnectorTableHandle getTableHandleForStatisticsCollection(ConnectorSession session, SchemaTableName tableName, Map<String, Object> analyzeProperties) {
        Optional oldAnalyzeColumnNames;
        Optional<Table> table = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName());
        if (table.isEmpty()) {
            return null;
        }
        if (!DeltaLakeSessionProperties.isExtendedStatisticsEnabled(session)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "ANALYZE not supported if extended statistics are disabled. Enable via delta.extended-statistics.enabled config property or extended_statistics_enabled session property.");
        }
        Optional<Instant> filesModifiedAfterFromProperties = DeltaLakeAnalyzeProperties.getFilesModifiedAfterProperty(analyzeProperties);
        TableSnapshot tableSnapshot = this.metastore.getSnapshot(tableName, session);
        long version = tableSnapshot.getVersion();
        String tableLocation = this.metastore.getTableLocation(tableName, session);
        Optional<DeltaLakeStatistics> statistics = this.statisticsAccess.readDeltaLakeStatistics(session, tableLocation);
        Optional<Instant> alreadyAnalyzedModifiedTimeMax = statistics.map(DeltaLakeStatistics::getAlreadyAnalyzedModifiedTimeMax);
        Optional<Instant> filesModifiedAfter = Optional.empty();
        if (filesModifiedAfterFromProperties.isPresent() || alreadyAnalyzedModifiedTimeMax.isPresent()) {
            filesModifiedAfter = Optional.of((Instant)Comparators.max((Comparable)filesModifiedAfterFromProperties.orElse(Instant.ofEpochMilli(0L)), (Comparable)alreadyAnalyzedModifiedTimeMax.orElse(Instant.ofEpochMilli(0L))));
        }
        MetadataEntry metadata = this.metastore.getMetadata(tableSnapshot, session).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, "Metadata not found in transaction log for " + table));
        Optional<Set<String>> analyzeColumnNames = DeltaLakeAnalyzeProperties.getColumnNames(analyzeProperties);
        if (analyzeColumnNames.isPresent()) {
            Set<String> columnNames = analyzeColumnNames.get();
            if (columnNames.isEmpty()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ANALYZE_PROPERTY, "Cannot specify empty list of columns for analysis");
            }
            Set allColumnNames = (Set)DeltaLakeSchemaSupport.extractSchema(metadata, this.typeManager).stream().map(ColumnMetadata::getName).collect(ImmutableSet.toImmutableSet());
            if (!allColumnNames.containsAll(columnNames)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ANALYZE_PROPERTY, String.format("Invalid columns specified for analysis: %s", Sets.difference(columnNames, (Set)allColumnNames)));
            }
        }
        if ((oldAnalyzeColumnNames = statistics.flatMap(DeltaLakeStatistics::getAnalyzedColumns)).isPresent() && (analyzeColumnNames.isEmpty() || !((Set)oldAnalyzeColumnNames.get()).containsAll((Collection)analyzeColumnNames.get()))) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ANALYZE_PROPERTY, "List of columns to be analyzed must be a subset of previously used. To extend list of analyzed columns drop table statistics");
        }
        AnalyzeHandle analyzeHandle = new AnalyzeHandle(version, statistics.isEmpty(), filesModifiedAfter, analyzeColumnNames);
        return new DeltaLakeTableHandle(tableName.getSchemaName(), tableName.getTableName(), tableLocation, Optional.of(metadata), (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.all(), (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.all(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(analyzeHandle), version);
    }

    public TableStatisticsMetadata getStatisticsCollectionMetadata(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        ImmutableSet.Builder columnStatistics = ImmutableSet.builder();
        Optional<Set<String>> analyzeColumnNames = DeltaLakeTableProperties.getAnalyzeColumns(tableMetadata.getProperties());
        tableMetadata.getColumns().stream().filter(DeltaLakeMetadata::shouldCollectExtendedStatistics).filter(columnMetadata -> analyzeColumnNames.map(columnNames -> columnNames.contains(columnMetadata.getName())).orElse(true)).map(columnMetadata -> new ColumnStatisticMetadata(columnMetadata.getName(), ColumnStatisticType.NUMBER_OF_DISTINCT_VALUES_SUMMARY)).forEach(arg_0 -> ((ImmutableSet.Builder)columnStatistics).add(arg_0));
        columnStatistics.add((Object)new ColumnStatisticMetadata("$file_modified_time", ColumnStatisticType.MAX_VALUE));
        return new TableStatisticsMetadata((Set)columnStatistics.build(), (Set)ImmutableSet.of(), (List)ImmutableList.of());
    }

    private static boolean shouldCollectExtendedStatistics(ColumnMetadata columnMetadata) {
        if (columnMetadata.isHidden()) {
            return false;
        }
        Type type = columnMetadata.getType();
        return !(type instanceof MapType) && !(type instanceof RowType) && !(type instanceof ArrayType);
    }

    public ConnectorTableHandle beginStatisticsCollection(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return tableHandle;
    }

    public void finishStatisticsCollection(ConnectorSession session, ConnectorTableHandle table, Collection<ComputedStatistics> computedStatistics) {
        DeltaLakeTableHandle tableHandle = (DeltaLakeTableHandle)table;
        AnalyzeHandle analyzeHandle = tableHandle.getAnalyzeHandle().orElseThrow(() -> new IllegalArgumentException("analyzeHandle not set"));
        String location = this.metastore.getTableLocation(tableHandle.getSchemaTableName(), session);
        Optional<DeltaLakeStatistics> oldStatistics = this.statisticsAccess.readDeltaLakeStatistics(session, location);
        oldStatistics.ifPresent(statistics -> Preconditions.checkArgument((statistics.getModelVersion() == 4L ? 1 : 0) != 0, (Object)"Existing table statistics are incompatible, run the drop statistics procedure on this table before re-analyzing"));
        Map oldColumnStatistics = oldStatistics.map(DeltaLakeStatistics::getColumnStatistics).orElseGet(ImmutableMap::of);
        Map<String, DeltaLakeColumnStatistics> newColumnStatistics = DeltaLakeMetadata.toDeltaLakeColumnStatistics(computedStatistics);
        HashMap<String, DeltaLakeColumnStatistics> mergedColumnStatistics = new HashMap<String, DeltaLakeColumnStatistics>();
        Set<String> newColumns = newColumnStatistics.keySet();
        oldColumnStatistics.entrySet().stream().filter(entry -> newColumns.contains(entry.getKey())).forEach(entry -> mergedColumnStatistics.put((String)entry.getKey(), (DeltaLakeColumnStatistics)entry.getValue()));
        newColumnStatistics.forEach((columnName, columnStatistics) -> mergedColumnStatistics.merge((String)columnName, (DeltaLakeColumnStatistics)columnStatistics, DeltaLakeColumnStatistics::update));
        Optional<Instant> maxFileModificationTime = DeltaLakeMetadata.getMaxFileModificationTime(computedStatistics);
        Instant finalAlreadyAnalyzedModifiedTimeMax = Instant.now();
        if (maxFileModificationTime.isPresent()) {
            finalAlreadyAnalyzedModifiedTimeMax = (Instant)Comparators.min((Comparable)maxFileModificationTime.get(), (Comparable)finalAlreadyAnalyzedModifiedTimeMax);
        }
        if (oldStatistics.isPresent()) {
            finalAlreadyAnalyzedModifiedTimeMax = (Instant)Comparators.max((Comparable)oldStatistics.get().getAlreadyAnalyzedModifiedTimeMax(), (Comparable)finalAlreadyAnalyzedModifiedTimeMax);
        }
        if (analyzeHandle.getColumns().isPresent() && !mergedColumnStatistics.keySet().equals(analyzeHandle.getColumns().get())) {
            throw new IllegalStateException(String.format("Unexpected columns in in mergedColumnStatistics %s; expected %s", mergedColumnStatistics.keySet(), analyzeHandle.getColumns().get()));
        }
        DeltaLakeStatistics mergedDeltaLakeStatistics = new DeltaLakeStatistics(finalAlreadyAnalyzedModifiedTimeMax, mergedColumnStatistics, analyzeHandle.getColumns());
        this.statisticsAccess.updateDeltaLakeStatistics(session, location, mergedDeltaLakeStatistics);
    }

    private static Map<String, DeltaLakeColumnStatistics> toDeltaLakeColumnStatistics(Collection<ComputedStatistics> computedStatistics) {
        ComputedStatistics singleStatistics = (ComputedStatistics)Iterables.getOnlyElement(computedStatistics);
        return (Map)singleStatistics.getColumnStatistics().entrySet().stream().filter(Predicate.not(entry -> ((ColumnStatisticMetadata)entry.getKey()).getColumnName().equals("$file_modified_time"))).collect(ImmutableMap.toImmutableMap(entry -> ((ColumnStatisticMetadata)entry.getKey()).getColumnName(), entry -> {
            ColumnStatisticMetadata columnStatisticMetadata = (ColumnStatisticMetadata)entry.getKey();
            if (columnStatisticMetadata.getStatisticType() != ColumnStatisticType.NUMBER_OF_DISTINCT_VALUES_SUMMARY) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unexpected statistics type " + columnStatisticMetadata.getStatisticType() + " found for column " + columnStatisticMetadata.getColumnName());
            }
            if (((Block)entry.getValue()).isNull(0)) {
                return DeltaLakeColumnStatistics.create(HyperLogLog.newInstance((int)4096));
            }
            Slice serializedSummary = HyperLogLogType.HYPER_LOG_LOG.getSlice((Block)entry.getValue(), 0);
            return DeltaLakeColumnStatistics.create(HyperLogLog.newInstance((Slice)serializedSummary));
        }));
    }

    private static Optional<Instant> getMaxFileModificationTime(Collection<ComputedStatistics> computedStatistics) {
        ComputedStatistics singleStatistics = (ComputedStatistics)Iterables.getOnlyElement(computedStatistics);
        return singleStatistics.getColumnStatistics().entrySet().stream().filter(entry -> ((ColumnStatisticMetadata)entry.getKey()).getColumnName().equals("$file_modified_time")).map(entry -> {
            ColumnStatisticMetadata columnStatisticMetadata = (ColumnStatisticMetadata)entry.getKey();
            if (columnStatisticMetadata.getStatisticType() != ColumnStatisticType.MAX_VALUE) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unexpected statistics type " + columnStatisticMetadata.getStatisticType() + " found for column " + columnStatisticMetadata.getColumnName());
            }
            if (((Block)entry.getValue()).isNull(0)) {
                return Optional.empty();
            }
            return Optional.of(Instant.ofEpochMilli(DateTimeEncoding.unpackMillisUtc((long)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS.getLong((Block)entry.getValue(), 0))));
        }).findFirst().orElseThrow();
    }

    public DeltaLakeMetastore getMetastore() {
        return this.metastore;
    }

    private static ColumnMetadata getColumnMetadata(DeltaLakeColumnHandle column) {
        return ColumnMetadata.builder().setName(column.getName()).setType(column.getType()).setHidden(column.getColumnType() == DeltaLakeColumnType.SYNTHESIZED).build();
    }

    public static TupleDomain<DeltaLakeColumnHandle> createStatisticsPredicate(AddFileEntry addFileEntry, List<ColumnMetadata> schema, List<String> canonicalPartitionColumns) {
        return addFileEntry.getStats().map(deltaLakeFileStatistics -> TupleDomain.withColumnDomains((Map)((Map)schema.stream().filter(DeltaLakeMetadata::canUseInPredicate).collect(ImmutableMap.toImmutableMap(column -> DeltaLakeMetadata.toColumnHandle(column, canonicalPartitionColumns), column -> DeltaLakeMetadata.buildColumnDomain(column, deltaLakeFileStatistics, canonicalPartitionColumns)))))).orElseGet(TupleDomain::all);
    }

    private static boolean canUseInPredicate(ColumnMetadata column) {
        Type type = column.getType();
        return type.equals(TinyintType.TINYINT) || type.equals(SmallintType.SMALLINT) || type.equals(IntegerType.INTEGER) || type.equals(BigintType.BIGINT) || type.equals(RealType.REAL) || type.equals(DoubleType.DOUBLE) || type.equals(BooleanType.BOOLEAN) || type.equals(DateType.DATE) || type instanceof TimestampWithTimeZoneType || type instanceof DecimalType || type.equals(VarcharType.VARCHAR);
    }

    private static Domain buildColumnDomain(ColumnMetadata column, DeltaLakeFileStatistics stats, List<String> canonicalPartitionColumns) {
        Optional<Object> maxValue;
        Optional<Long> nullCount = stats.getNullCount(column.getName());
        if (nullCount.isEmpty()) {
            return Domain.all((Type)column.getType());
        }
        if (stats.getNumRecords().equals(nullCount)) {
            return Domain.onlyNull((Type)column.getType());
        }
        boolean hasNulls = nullCount.get() > 0L;
        Optional<Object> minValue = stats.getMinColumnValue(DeltaLakeMetadata.toColumnHandle(column, canonicalPartitionColumns));
        if (minValue.isPresent() && TypeUtils.isFloatingPointNaN((Type)column.getType(), (Object)minValue.get())) {
            return DeltaLakeMetadata.allValues(column.getType(), hasNulls);
        }
        if (DeltaLakeMetadata.isNotFinite(minValue, column.getType())) {
            minValue = Optional.empty();
        }
        if ((maxValue = stats.getMaxColumnValue(DeltaLakeMetadata.toColumnHandle(column, canonicalPartitionColumns))).isPresent() && TypeUtils.isFloatingPointNaN((Type)column.getType(), (Object)maxValue.get())) {
            return DeltaLakeMetadata.allValues(column.getType(), hasNulls);
        }
        if (DeltaLakeMetadata.isNotFinite(maxValue, column.getType())) {
            maxValue = Optional.empty();
        }
        if (minValue.isPresent() && maxValue.isPresent()) {
            return Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)column.getType(), (Object)minValue.get(), (boolean)true, (Object)maxValue.get(), (boolean)true), (Range[])new Range[0]), (boolean)hasNulls);
        }
        if (minValue.isPresent()) {
            return Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)column.getType(), (Object)minValue.get()), (Range[])new Range[0]), (boolean)hasNulls);
        }
        return maxValue.map(value -> Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)column.getType(), (Object)value), (Range[])new Range[0]), (boolean)hasNulls)).orElseGet(() -> Domain.all((Type)column.getType()));
    }

    private static boolean isNotFinite(Optional<Object> value, Type type) {
        if (type.equals(DoubleType.DOUBLE)) {
            return value.map(Double.class::cast).filter(val -> !Double.isFinite(val)).isPresent();
        }
        if (type.equals(RealType.REAL)) {
            return value.map(Long.class::cast).map(Math::toIntExact).map(Float::intBitsToFloat).filter(val -> !Float.isFinite(val.floatValue())).isPresent();
        }
        return false;
    }

    private static Domain allValues(Type type, boolean includeNull) {
        if (includeNull) {
            return Domain.all((Type)type);
        }
        return Domain.notNull((Type)type);
    }

    private static DeltaLakeColumnHandle toColumnHandle(ColumnMetadata column, Collection<String> partitionColumns) {
        boolean isPartitionKey = partitionColumns.stream().anyMatch(partition -> partition.equalsIgnoreCase(column.getName()));
        return new DeltaLakeColumnHandle(column.getName(), column.getType(), isPartitionKey ? DeltaLakeColumnType.PARTITION_KEY : DeltaLakeColumnType.REGULAR);
    }

    private static /* synthetic */ boolean lambda$getUnmodifiedColumns$32(Set partitionColumnNames, DeltaLakeColumnHandle columnHandle) {
        return !partitionColumnNames.contains(columnHandle.getName());
    }

    private static /* synthetic */ DeltaLakeColumnHandle lambda$getUnmodifiedColumns$30(Set partitionColumnNames, ColumnMetadata columnMetadata) {
        return DeltaLakeMetadata.toColumnHandle(columnMetadata, partitionColumnNames);
    }
}

