/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import io.airlift.json.JsonCodec;
import io.trino.plugin.deltalake.DataFileInfo;
import io.trino.plugin.deltalake.DeltaLakeConfig;
import io.trino.plugin.deltalake.DeltaLakeMetadata;
import io.trino.plugin.deltalake.DeltaLakeUpdateResult;
import io.trino.plugin.deltalake.HideNonDeltaLakeTables;
import io.trino.plugin.deltalake.metastore.HiveMetastoreBackedDeltaLakeMetastore;
import io.trino.plugin.deltalake.statistics.CachingDeltaLakeStatisticsAccess;
import io.trino.plugin.deltalake.transactionlog.TransactionLogAccess;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointWriterManager;
import io.trino.plugin.deltalake.transactionlog.writer.TransactionLogWriterFactory;
import io.trino.plugin.hive.HdfsEnvironment;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.HiveMetastoreFactory;
import io.trino.plugin.hive.metastore.cache.CachingHiveMetastore;
import io.trino.spi.NodeManager;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.TypeManager;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class DeltaLakeMetadataFactory {
    private final HiveMetastoreFactory hiveMetastoreFactory;
    private final HdfsEnvironment hdfsEnvironment;
    private final TransactionLogAccess transactionLogAccess;
    private final TypeManager typeManager;
    private final JsonCodec<DataFileInfo> dataFileInfoCodec;
    private final JsonCodec<DeltaLakeUpdateResult> deleteResultJsonCodec;
    private final TransactionLogWriterFactory transactionLogWriterFactory;
    private final NodeManager nodeManager;
    private final CheckpointWriterManager checkpointWriterManager;
    private final CachingDeltaLakeStatisticsAccess statisticsAccess;
    private final int domainCompactionThreshold;
    private final boolean hideNonDeltaLakeTables;
    private final boolean unsafeWritesEnabled;
    private final long checkpointWritingInterval;
    private final boolean ignoreCheckpointWriteFailures;
    private final long perTransactionMetastoreCacheMaximumSize;
    private final boolean deleteSchemaLocationsFallback;

    @Inject
    public DeltaLakeMetadataFactory(HiveMetastoreFactory hiveMetastoreFactory, HdfsEnvironment hdfsEnvironment, TransactionLogAccess transactionLogAccess, TypeManager typeManager, DeltaLakeConfig deltaLakeConfig, @HideNonDeltaLakeTables boolean hideNonDeltaLakeTables, JsonCodec<DataFileInfo> dataFileInfoCodec, JsonCodec<DeltaLakeUpdateResult> deleteResultJsonCodec, TransactionLogWriterFactory transactionLogWriterFactory, NodeManager nodeManager, CheckpointWriterManager checkpointWriterManager, CachingDeltaLakeStatisticsAccess statisticsAccess, HiveConfig hiveConfig) {
        this.hiveMetastoreFactory = Objects.requireNonNull(hiveMetastoreFactory, "hiveMetastore is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.transactionLogAccess = Objects.requireNonNull(transactionLogAccess, "transactionLogAccess is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.dataFileInfoCodec = Objects.requireNonNull(dataFileInfoCodec, "dataFileInfoCodec is null");
        this.deleteResultJsonCodec = Objects.requireNonNull(deleteResultJsonCodec, "deleteResultJsonCodec is null");
        this.transactionLogWriterFactory = Objects.requireNonNull(transactionLogWriterFactory, "transactionLogWriterFactory is null");
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.checkpointWriterManager = Objects.requireNonNull(checkpointWriterManager, "checkpointWriterManager is null");
        this.statisticsAccess = Objects.requireNonNull(statisticsAccess, "statisticsAccess is null");
        Objects.requireNonNull(deltaLakeConfig, "deltaLakeConfig is null");
        this.domainCompactionThreshold = deltaLakeConfig.getDomainCompactionThreshold();
        this.hideNonDeltaLakeTables = hideNonDeltaLakeTables;
        this.unsafeWritesEnabled = deltaLakeConfig.getUnsafeWritesEnabled();
        this.checkpointWritingInterval = deltaLakeConfig.getDefaultCheckpointWritingInterval();
        this.ignoreCheckpointWriteFailures = deltaLakeConfig.isIgnoreCheckpointWriteFailures();
        this.perTransactionMetastoreCacheMaximumSize = hiveConfig.getPerTransactionMetastoreCacheMaximumSize();
        this.deleteSchemaLocationsFallback = hiveConfig.isDeleteSchemaLocationsFallback();
    }

    public DeltaLakeMetadata create(ConnectorIdentity identity) {
        CachingHiveMetastore cachingHiveMetastore = CachingHiveMetastore.memoizeMetastore((HiveMetastore)this.hiveMetastoreFactory.createMetastore(Optional.of(identity)), (long)this.perTransactionMetastoreCacheMaximumSize);
        HiveMetastoreBackedDeltaLakeMetastore deltaLakeMetastore = new HiveMetastoreBackedDeltaLakeMetastore((HiveMetastore)cachingHiveMetastore, this.transactionLogAccess, this.typeManager, this.statisticsAccess);
        return new DeltaLakeMetadata(deltaLakeMetastore, this.hdfsEnvironment, this.typeManager, this.domainCompactionThreshold, this.hideNonDeltaLakeTables, this.unsafeWritesEnabled, this.dataFileInfoCodec, this.deleteResultJsonCodec, this.transactionLogWriterFactory, this.nodeManager, this.checkpointWriterManager, this.checkpointWritingInterval, this.ignoreCheckpointWriteFailures, this.deleteSchemaLocationsFallback, this.statisticsAccess);
    }
}

