/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.inject.Binder;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import io.airlift.concurrent.Threads;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.json.JsonCodecBinder;
import io.trino.plugin.base.CatalogName;
import io.trino.plugin.deltalake.DataFileInfo;
import io.trino.plugin.deltalake.DeltaLakeAnalyzeProperties;
import io.trino.plugin.deltalake.DeltaLakeConfig;
import io.trino.plugin.deltalake.DeltaLakeMetadataFactory;
import io.trino.plugin.deltalake.DeltaLakeNodePartitioningProvider;
import io.trino.plugin.deltalake.DeltaLakePageSinkProvider;
import io.trino.plugin.deltalake.DeltaLakePageSourceProvider;
import io.trino.plugin.deltalake.DeltaLakeSessionProperties;
import io.trino.plugin.deltalake.DeltaLakeSplitManager;
import io.trino.plugin.deltalake.DeltaLakeTableProperties;
import io.trino.plugin.deltalake.DeltaLakeTransactionManager;
import io.trino.plugin.deltalake.DeltaLakeUpdateResult;
import io.trino.plugin.deltalake.DeltaLakeWriterStats;
import io.trino.plugin.deltalake.metastore.DeltaLakeMetastore;
import io.trino.plugin.deltalake.procedure.DropExtendedStatsProcedure;
import io.trino.plugin.deltalake.procedure.VacuumProcedure;
import io.trino.plugin.deltalake.statistics.CachingDeltaLakeStatisticsAccess;
import io.trino.plugin.deltalake.statistics.DeltaLakeStatistics;
import io.trino.plugin.deltalake.statistics.DeltaLakeStatisticsAccess;
import io.trino.plugin.deltalake.statistics.MetaDirStatisticsAccess;
import io.trino.plugin.deltalake.transactionlog.TransactionLogAccess;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointSchemaManager;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointWriterManager;
import io.trino.plugin.deltalake.transactionlog.checkpoint.LastCheckpoint;
import io.trino.plugin.deltalake.transactionlog.writer.AzureTransactionLogSynchronizer;
import io.trino.plugin.deltalake.transactionlog.writer.NoIsolationSynchronizer;
import io.trino.plugin.deltalake.transactionlog.writer.S3TransactionLogSynchronizer;
import io.trino.plugin.deltalake.transactionlog.writer.TransactionLogSynchronizer;
import io.trino.plugin.deltalake.transactionlog.writer.TransactionLogSynchronizerManager;
import io.trino.plugin.deltalake.transactionlog.writer.TransactionLogWriterFactory;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveLocationService;
import io.trino.plugin.hive.HiveTransactionHandle;
import io.trino.plugin.hive.HiveTransactionManager;
import io.trino.plugin.hive.LocationService;
import io.trino.plugin.hive.PropertiesSystemTableProvider;
import io.trino.plugin.hive.SystemTableProvider;
import io.trino.plugin.hive.TransactionalMetadata;
import io.trino.plugin.hive.TransactionalMetadataFactory;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.MetastoreConfig;
import io.trino.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.trino.plugin.hive.parquet.ParquetReaderConfig;
import io.trino.plugin.hive.parquet.ParquetWriterConfig;
import io.trino.plugin.hive.procedure.OptimizeTableProcedure;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.TableProcedureMetadata;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.security.ConnectorIdentity;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BiFunction;
import javax.inject.Singleton;
import org.weakref.jmx.guice.ExportBinder;

public class DeltaLakeModule
extends AbstractConfigurationAwareModule {
    public void setup(Binder binder) {
        Provider catalogName = binder.getProvider(CatalogName.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(DeltaLakeConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(HiveConfig.class);
        binder.bind(MetastoreConfig.class).toInstance((Object)new MetastoreConfig());
        ConfigBinder.configBinder((Binder)binder).bindConfig(ParquetReaderConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(ParquetWriterConfig.class);
        Multibinder systemTableProviders = Multibinder.newSetBinder((Binder)binder, SystemTableProvider.class);
        systemTableProviders.addBinding().to(PropertiesSystemTableProvider.class).in(Scopes.SINGLETON);
        binder.bind(DeltaLakeSessionProperties.class).in(Scopes.SINGLETON);
        binder.bind(DeltaLakeTableProperties.class).in(Scopes.SINGLETON);
        binder.bind(DeltaLakeAnalyzeProperties.class).in(Scopes.SINGLETON);
        binder.bind(DeltaLakeTransactionManager.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorSplitManager.class).to(DeltaLakeSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorPageSourceProvider.class).to(DeltaLakePageSourceProvider.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorPageSinkProvider.class).to(DeltaLakePageSinkProvider.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorNodePartitioningProvider.class).to(DeltaLakeNodePartitioningProvider.class).in(Scopes.SINGLETON);
        binder.bind(LocationService.class).to(HiveLocationService.class).in(Scopes.SINGLETON);
        binder.bind(DeltaLakeMetadataFactory.class).in(Scopes.SINGLETON);
        binder.bind(CachingDeltaLakeStatisticsAccess.class).in(Scopes.SINGLETON);
        binder.bind(DeltaLakeStatisticsAccess.class).to(CachingDeltaLakeStatisticsAccess.class).in(Scopes.SINGLETON);
        binder.bind(DeltaLakeStatisticsAccess.class).annotatedWith(CachingDeltaLakeStatisticsAccess.ForCachingDeltaLakeStatisticsAccess.class).to(MetaDirStatisticsAccess.class).in(Scopes.SINGLETON);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(DeltaLakeStatistics.class);
        binder.bind(HiveTransactionManager.class).in(Scopes.SINGLETON);
        binder.bind(CheckpointSchemaManager.class).in(Scopes.SINGLETON);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(LastCheckpoint.class);
        binder.bind(CheckpointWriterManager.class).in(Scopes.SINGLETON);
        binder.bind(TransactionLogAccess.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(TransactionLogAccess.class).as(generator -> generator.generatedNameOf(TransactionLogAccess.class, ((CatalogName)catalogName.get()).toString()));
        binder.bind(TransactionLogWriterFactory.class).in(Scopes.SINGLETON);
        binder.bind(TransactionLogSynchronizerManager.class).in(Scopes.SINGLETON);
        binder.bind(NoIsolationSynchronizer.class).in(Scopes.SINGLETON);
        MapBinder logSynchronizerMapBinder = MapBinder.newMapBinder((Binder)binder, String.class, TransactionLogSynchronizer.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(S3TransactionLogSynchronizer.LockFileContents.class);
        logSynchronizerMapBinder.addBinding((Object)"s3").to(S3TransactionLogSynchronizer.class).in(Scopes.SINGLETON);
        logSynchronizerMapBinder.addBinding((Object)"s3a").to(S3TransactionLogSynchronizer.class).in(Scopes.SINGLETON);
        logSynchronizerMapBinder.addBinding((Object)"s3n").to(S3TransactionLogSynchronizer.class).in(Scopes.SINGLETON);
        logSynchronizerMapBinder.addBinding((Object)"abfs").to(AzureTransactionLogSynchronizer.class).in(Scopes.SINGLETON);
        logSynchronizerMapBinder.addBinding((Object)"abfss").to(AzureTransactionLogSynchronizer.class).in(Scopes.SINGLETON);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(DataFileInfo.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(DeltaLakeUpdateResult.class);
        binder.bind(DeltaLakeWriterStats.class).in(Scopes.SINGLETON);
        binder.bind(FileFormatDataSourceStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(FileFormatDataSourceStats.class).as(generator -> generator.generatedNameOf(FileFormatDataSourceStats.class, ((CatalogName)catalogName.get()).toString()));
        Multibinder procedures = Multibinder.newSetBinder((Binder)binder, Procedure.class);
        procedures.addBinding().toProvider(DropExtendedStatsProcedure.class).in(Scopes.SINGLETON);
        procedures.addBinding().toProvider(VacuumProcedure.class).in(Scopes.SINGLETON);
        Multibinder tableProcedures = Multibinder.newSetBinder((Binder)binder, TableProcedureMetadata.class);
        tableProcedures.addBinding().toProvider(OptimizeTableProcedure.class).in(Scopes.SINGLETON);
    }

    @Singleton
    @Provides
    public BiFunction<ConnectorIdentity, HiveTransactionHandle, HiveMetastore> createHiveMetastoreGetter(DeltaLakeTransactionManager transactionManager) {
        return (identity, transactionHandle) -> transactionManager.get((ConnectorTransactionHandle)transactionHandle, (ConnectorIdentity)identity).getMetastore().getHiveMetastore();
    }

    @Singleton
    @Provides
    public BiFunction<ConnectorSession, HiveTransactionHandle, DeltaLakeMetastore> createMetastoreGetter(DeltaLakeTransactionManager transactionManager) {
        return (connectorSession, transactionHandle) -> transactionManager.get((ConnectorTransactionHandle)transactionHandle, connectorSession.getIdentity()).getMetastore();
    }

    @Singleton
    @Provides
    public TransactionalMetadataFactory createTransactionalMetadataFactory() {
        return (identity, autoCommit) -> new TransactionalMetadata(){

            public SemiTransactionalHiveMetastore getMetastore() {
                throw new RuntimeException("SemiTransactionalHiveMetastore is not used by Delta");
            }

            public void commit() {
            }

            public void rollback() {
            }
        };
    }

    @Singleton
    @Provides
    public ExecutorService createDeltaLakeExecutor(CatalogName catalogName) {
        return Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)("delta-" + catalogName + "-%s")));
    }
}

