/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnType;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DeltaLakeOutputTableHandle
implements ConnectorOutputTableHandle {
    private final String schemaName;
    private final String tableName;
    private final List<DeltaLakeColumnHandle> inputColumns;
    private final String location;
    private final Optional<Long> checkpointInterval;
    private final boolean external;

    @JsonCreator
    public DeltaLakeOutputTableHandle(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="inputColumns") List<DeltaLakeColumnHandle> inputColumns, @JsonProperty(value="location") String location, @JsonProperty(value="checkpointInterval") Optional<Long> checkpointInterval, @JsonProperty(value="external") boolean external) {
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.inputColumns = ImmutableList.copyOf(inputColumns);
        this.location = Objects.requireNonNull(location, "location is null");
        this.checkpointInterval = checkpointInterval;
        this.external = external;
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public List<DeltaLakeColumnHandle> getInputColumns() {
        return this.inputColumns;
    }

    @JsonProperty
    public String getLocation() {
        return this.location;
    }

    @JsonIgnore
    public List<String> getPartitionedBy() {
        return (List)this.getInputColumns().stream().filter(column -> column.getColumnType() == DeltaLakeColumnType.PARTITION_KEY).map(DeltaLakeColumnHandle::getName).collect(ImmutableList.toImmutableList());
    }

    @JsonProperty
    public Optional<Long> getCheckpointInterval() {
        return this.checkpointInterval;
    }

    @JsonProperty
    public boolean isExternal() {
        return this.external;
    }
}

