/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import io.airlift.json.JsonCodec;
import io.trino.plugin.deltalake.DataFileInfo;
import io.trino.plugin.deltalake.DeltaLakeConfig;
import io.trino.plugin.deltalake.DeltaLakeInsertTableHandle;
import io.trino.plugin.deltalake.DeltaLakeOutputTableHandle;
import io.trino.plugin.deltalake.DeltaLakePageSink;
import io.trino.plugin.deltalake.DeltaLakeWriterStats;
import io.trino.plugin.deltalake.procedure.DeltaLakeTableExecuteHandle;
import io.trino.plugin.deltalake.procedure.DeltaTableOptimizeHandle;
import io.trino.plugin.hive.HdfsEnvironment;
import io.trino.plugin.hive.NodeVersion;
import io.trino.spi.PageIndexerFactory;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableExecuteHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.type.TypeManager;
import java.util.Objects;
import javax.inject.Inject;

public class DeltaLakePageSinkProvider
implements ConnectorPageSinkProvider {
    private final PageIndexerFactory pageIndexerFactory;
    private final HdfsEnvironment hdfsEnvironment;
    private final JsonCodec<DataFileInfo> dataFileInfoCodec;
    private final DeltaLakeWriterStats stats;
    private final int maxPartitionsPerWriter;
    private final TypeManager typeManager;
    private final String trinoVersion;

    @Inject
    public DeltaLakePageSinkProvider(PageIndexerFactory pageIndexerFactory, HdfsEnvironment hdfsEnvironment, JsonCodec<DataFileInfo> dataFileInfoCodec, DeltaLakeWriterStats stats, DeltaLakeConfig deltalakeConfig, TypeManager typeManager, NodeVersion nodeVersion) {
        this.pageIndexerFactory = pageIndexerFactory;
        this.hdfsEnvironment = hdfsEnvironment;
        this.dataFileInfoCodec = dataFileInfoCodec;
        this.stats = stats;
        this.maxPartitionsPerWriter = deltalakeConfig.getMaxPartitionsPerWriter();
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.trinoVersion = Objects.requireNonNull(nodeVersion, "nodeVersion is null").toString();
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorOutputTableHandle outputTableHandle) {
        DeltaLakeOutputTableHandle tableHandle = (DeltaLakeOutputTableHandle)outputTableHandle;
        return new DeltaLakePageSink(tableHandle.getInputColumns(), tableHandle.getPartitionedBy(), this.pageIndexerFactory, this.hdfsEnvironment, this.maxPartitionsPerWriter, this.dataFileInfoCodec, tableHandle.getLocation(), session, this.stats, this.typeManager, this.trinoVersion);
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorInsertTableHandle insertTableHandle) {
        DeltaLakeInsertTableHandle tableHandle = (DeltaLakeInsertTableHandle)insertTableHandle;
        return new DeltaLakePageSink(tableHandle.getInputColumns(), tableHandle.getMetadataEntry().getOriginalPartitionColumns(), this.pageIndexerFactory, this.hdfsEnvironment, this.maxPartitionsPerWriter, this.dataFileInfoCodec, tableHandle.getLocation(), session, this.stats, this.typeManager, this.trinoVersion);
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorTableExecuteHandle tableExecuteHandle) {
        DeltaLakeTableExecuteHandle executeHandle = (DeltaLakeTableExecuteHandle)tableExecuteHandle;
        switch (executeHandle.getProcedureId()) {
            case OPTIMIZE: {
                DeltaTableOptimizeHandle optimizeHandle = (DeltaTableOptimizeHandle)executeHandle.getProcedureHandle();
                return new DeltaLakePageSink(optimizeHandle.getTableColumns(), optimizeHandle.getOriginalPartitionColumns(), this.pageIndexerFactory, this.hdfsEnvironment, this.maxPartitionsPerWriter, this.dataFileInfoCodec, executeHandle.getTableLocation(), session, this.stats, this.typeManager, this.trinoVersion);
            }
        }
        throw new IllegalArgumentException("Unknown procedure: " + executeHandle.getProcedureId());
    }
}

