/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.hive.metastore.Database;
import io.trino.spi.session.PropertyMetadata;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class DeltaLakeSchemaProperties {
    public static final String LOCATION_PROPERTY = "location";
    public static final List<PropertyMetadata<?>> SCHEMA_PROPERTIES = ImmutableList.of((Object)PropertyMetadata.stringProperty((String)"location", (String)"URI for the default location to store tables created in this schema", null, (boolean)false));

    private DeltaLakeSchemaProperties() {
    }

    public static Map<String, Object> fromDatabase(Database db) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        db.getLocation().ifPresent(location -> result.put((Object)LOCATION_PROPERTY, location));
        return result.buildOrThrow();
    }

    public static Optional<String> getLocation(Map<String, Object> schemaProperties) {
        return Optional.ofNullable((String)schemaProperties.get(LOCATION_PROPERTY));
    }
}

