/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.MoreFutures;
import io.airlift.log.Logger;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnType;
import io.trino.plugin.deltalake.DeltaLakeSplit;
import io.trino.plugin.deltalake.DeltaLakeSplitManager;
import io.trino.plugin.hive.util.AsyncQueue;
import io.trino.plugin.hive.util.ThrottledAsyncQueue;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorPartitionHandle;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.TupleDomain;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.stream.Stream;

public class DeltaLakeSplitSource
implements ConnectorSplitSource {
    private static final Logger LOG = Logger.get(DeltaLakeSplitSource.class);
    private final SchemaTableName tableName;
    private final AsyncQueue<ConnectorSplit> queue;
    private final boolean recordScannedFiles;
    private final ImmutableSet.Builder<String> scannedFilePaths = ImmutableSet.builder();
    private final DynamicFilter dynamicFilter;
    private volatile TrinoException trinoException;

    public DeltaLakeSplitSource(SchemaTableName tableName, Stream<DeltaLakeSplit> splits, ExecutorService executor, int maxSplitsPerSecond, int maxOutstandingSplits, DynamicFilter dynamicFilter, boolean recordScannedFiles) {
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.queue = new ThrottledAsyncQueue(maxSplitsPerSecond, maxOutstandingSplits, (Executor)executor);
        this.recordScannedFiles = recordScannedFiles;
        this.dynamicFilter = Objects.requireNonNull(dynamicFilter, "dynamicFilter is null");
        DeltaLakeSplitSource.queueSplits(splits, this.queue, executor).exceptionally(throwable -> {
            this.trinoException = new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed to generate splits for " + this.tableName, throwable);
            try {
                this.queue.finish();
            }
            catch (Exception e) {
                LOG.error((Throwable)e, "Could not communicate split generation error for %s to query; this may cause it to be blocked", new Object[]{tableName});
            }
            return null;
        });
    }

    public CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> getNextBatch(ConnectorPartitionHandle partitionHandle, int maxSize) {
        boolean noMoreSplits = this.isFinished();
        if (this.trinoException != null) {
            return MoreFutures.toCompletableFuture((ListenableFuture)Futures.immediateFailedFuture((Throwable)this.trinoException));
        }
        return MoreFutures.toCompletableFuture((ListenableFuture)Futures.transform((ListenableFuture)this.queue.getBatchAsync(maxSize), splits -> {
            TupleDomain dynamicFilterPredicate = this.dynamicFilter.getCurrentPredicate().transformKeys(DeltaLakeColumnHandle.class::cast);
            if (dynamicFilterPredicate.isNone()) {
                return new ConnectorSplitSource.ConnectorSplitBatch((List)ImmutableList.of(), noMoreSplits);
            }
            Map partitionColumnDomains = (Map)((Map)dynamicFilterPredicate.getDomains().orElseThrow()).entrySet().stream().filter(entry -> ((DeltaLakeColumnHandle)entry.getKey()).getColumnType() == DeltaLakeColumnType.PARTITION_KEY).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
            List filteredSplits = (List)splits.stream().map(DeltaLakeSplit.class::cast).filter(split -> split.getStatisticsPredicate().overlaps(dynamicFilterPredicate) && DeltaLakeSplitManager.partitionMatchesPredicate(split.getPartitionKeys(), partitionColumnDomains)).collect(ImmutableList.toImmutableList());
            if (this.recordScannedFiles) {
                filteredSplits.forEach(split -> this.scannedFilePaths.add((Object)((DeltaLakeSplit)split).getPath()));
            }
            return new ConnectorSplitSource.ConnectorSplitBatch(filteredSplits, noMoreSplits);
        }, (Executor)MoreExecutors.directExecutor()));
    }

    public Optional<List<Object>> getTableExecuteSplitsInfo() {
        Preconditions.checkState((boolean)this.isFinished(), (Object)"Split source must be finished before TableExecuteSplitsInfo is read");
        if (!this.recordScannedFiles) {
            return Optional.empty();
        }
        return Optional.of(ImmutableList.copyOf((Collection)this.scannedFilePaths.build()));
    }

    public void close() {
        this.queue.finish();
    }

    public boolean isFinished() {
        if (this.queue.isFinished()) {
            return this.trinoException == null;
        }
        return false;
    }

    private static CompletableFuture<Void> queueSplits(Stream<DeltaLakeSplit> splits, AsyncQueue<ConnectorSplit> queue, ExecutorService executor) {
        Objects.requireNonNull(splits, "splits is null");
        return CompletableFuture.runAsync(() -> {
            splits.map(arg_0 -> ((AsyncQueue)queue).offer(arg_0)).forEachOrdered(MoreFutures::getFutureValue);
            queue.finish();
        }, executor);
    }
}

