/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.json.JsonCodec;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.parquet.ParquetReaderOptions;
import io.trino.plugin.deltalake.DataFileInfo;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnType;
import io.trino.plugin.deltalake.DeltaLakeErrorCode;
import io.trino.plugin.deltalake.DeltaLakePageSink;
import io.trino.plugin.deltalake.DeltaLakePageSource;
import io.trino.plugin.deltalake.DeltaLakeSessionProperties;
import io.trino.plugin.deltalake.DeltaLakeTableHandle;
import io.trino.plugin.deltalake.DeltaLakeUpdateResult;
import io.trino.plugin.deltalake.DeltaLakeWriter;
import io.trino.plugin.deltalake.DeltaLakeWriterStats;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeSchemaSupport;
import io.trino.plugin.deltalake.transactionlog.TransactionLogParser;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.plugin.hive.FileWriter;
import io.trino.plugin.hive.HdfsEnvironment;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveCompressionCodec;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.ReaderPageSource;
import io.trino.plugin.hive.RecordFileWriter;
import io.trino.plugin.hive.metastore.StorageFormat;
import io.trino.plugin.hive.parquet.ParquetPageSourceFactory;
import io.trino.plugin.hive.util.CompressionConfigUtil;
import io.trino.plugin.hive.util.ConfigurationUtils;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.RowBlock;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.UpdatablePageSource;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.Utils;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import java.io.IOException;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.io.InputFile;
import org.joda.time.DateTimeZone;

public class DeltaLakeUpdatablePageSource
implements UpdatablePageSource {
    private final int rowIdColumnIndex;
    private final List<DeltaLakeColumnHandle> queryColumns;
    private final DeltaLakeTableHandle tableHandle;
    private final Map<String, Optional<String>> partitionKeys;
    private final String path;
    private final long fileSize;
    private final ConnectorSession session;
    private final ExecutorService executorService;
    private final HdfsEnvironment hdfsEnvironment;
    private final HdfsEnvironment.HdfsContext hdfsContext;
    private final DateTimeZone parquetDateTimeZone;
    private final ParquetReaderOptions parquetReaderOptions;
    private final TypeManager typeManager;
    private final JsonCodec<DeltaLakeUpdateResult> updateResultJsonCodec;
    private final BitSet rowsToDelete;
    private final DeltaLakePageSource pageSourceDelegate;
    private final int totalRecordCount;
    private final List<DeltaLakeColumnHandle> allDataColumns;
    private final DeltaLakeTableHandle.WriteType writeType;
    private final DeltaLakeWriter updatedFileWriter;
    private final Optional<int[]> queryColumnMapping;
    private final Optional<int[]> rowIdColumnMapping;
    private final Set<DeltaLakeColumnHandle> updatedColumns;

    public DeltaLakeUpdatablePageSource(DeltaLakeTableHandle tableHandle, List<DeltaLakeColumnHandle> queryColumns, Map<String, Optional<String>> partitionKeys, String path, long fileSize, long fileModifiedTime, ConnectorSession session, ExecutorService executorService, HdfsEnvironment hdfsEnvironment, HdfsEnvironment.HdfsContext hdfsContext, DateTimeZone parquetDateTimeZone, ParquetReaderOptions parquetReaderOptions, TupleDomain<HiveColumnHandle> parquetPredicate, TypeManager typeManager, JsonCodec<DeltaLakeUpdateResult> updateResultJsonCodec) {
        List delegatedColumns;
        this.tableHandle = Objects.requireNonNull(tableHandle, "tableHandle is null");
        this.queryColumns = Objects.requireNonNull(queryColumns, "queryColumns is null");
        this.partitionKeys = Objects.requireNonNull(partitionKeys, "partitionKeys is null");
        this.path = Objects.requireNonNull(path, "path is null");
        this.fileSize = fileSize;
        this.session = Objects.requireNonNull(session, "session is null");
        this.executorService = Objects.requireNonNull(executorService, "executorService is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.hdfsContext = Objects.requireNonNull(hdfsContext, "hdfsContext is null");
        this.parquetDateTimeZone = Objects.requireNonNull(parquetDateTimeZone, "parquetDateTimeZone is null");
        this.parquetReaderOptions = Objects.requireNonNull(parquetReaderOptions, "parquetReaderOptions is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.updateResultJsonCodec = Objects.requireNonNull(updateResultJsonCodec, "deleteResultJsonCodec is null");
        List<ColumnMetadata> columnMetadata = DeltaLakeSchemaSupport.extractSchema(tableHandle.getMetadataEntry(), typeManager);
        List allColumns = (List)columnMetadata.stream().map(metadata -> new DeltaLakeColumnHandle(metadata.getName(), metadata.getType(), partitionKeys.containsKey(metadata.getName()) ? DeltaLakeColumnType.PARTITION_KEY : DeltaLakeColumnType.REGULAR)).collect(ImmutableList.toImmutableList());
        this.allDataColumns = (List)allColumns.stream().filter(columnHandle -> columnHandle.getColumnType() == DeltaLakeColumnType.REGULAR).collect(ImmutableList.toImmutableList());
        this.writeType = tableHandle.getWriteType().orElseThrow();
        List nonRowIdQueryColumns = (List)queryColumns.stream().filter(column -> !column.getName().equals("$row_id")).collect(ImmutableList.toImmutableList());
        switch (this.writeType) {
            case UPDATE: {
                delegatedColumns = allColumns;
                int queryColumnIndex = 0;
                ImmutableSet queryColumnSet = ImmutableSet.copyOf((Collection)nonRowIdQueryColumns);
                int[] queryColumnMapping = new int[nonRowIdQueryColumns.size()];
                int rowIdColumnIndex = 0;
                ImmutableSet rowIdUnmodifiedColumns = ImmutableSet.copyOf((Collection)tableHandle.getUpdateRowIdColumns().orElseThrow());
                int[] rowIdColumnMapping = new int[rowIdUnmodifiedColumns.size()];
                for (int delegatedColumnIndex = 0; delegatedColumnIndex < delegatedColumns.size(); ++delegatedColumnIndex) {
                    DeltaLakeColumnHandle delegatedColumn = (DeltaLakeColumnHandle)delegatedColumns.get(delegatedColumnIndex);
                    if (rowIdUnmodifiedColumns.contains(delegatedColumn)) {
                        rowIdColumnMapping[rowIdColumnIndex] = delegatedColumnIndex;
                        ++rowIdColumnIndex;
                    }
                    if (!queryColumnSet.contains(delegatedColumn)) continue;
                    queryColumnMapping[queryColumnIndex] = delegatedColumnIndex;
                    ++queryColumnIndex;
                }
                this.queryColumnMapping = Optional.of(queryColumnMapping);
                this.rowIdColumnMapping = Optional.of(rowIdColumnMapping);
                this.updatedColumns = ImmutableSet.copyOf((Collection)tableHandle.getUpdatedColumns().orElseThrow());
                break;
            }
            case DELETE: {
                delegatedColumns = nonRowIdQueryColumns;
                this.queryColumnMapping = Optional.empty();
                this.rowIdColumnMapping = Optional.empty();
                this.updatedColumns = ImmutableSet.of();
                break;
            }
            default: {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unsupported write type: " + this.writeType);
            }
        }
        DeltaLakeColumnHandle rowIndexColumn = DeltaLakeUpdatablePageSource.rowIndexColumn();
        delegatedColumns = ImmutableList.builder().addAll((Iterable)delegatedColumns).add((Object)rowIndexColumn).build();
        ReaderPageSource parquetPageSource = this.createParquetPageSource(parquetPredicate, (List)delegatedColumns.stream().filter(column -> column.getColumnType() == DeltaLakeColumnType.REGULAR || column == rowIndexColumn).map(DeltaLakeColumnHandle::toHiveColumnHandle).collect(ImmutableList.toImmutableList()));
        this.pageSourceDelegate = new DeltaLakePageSource(delegatedColumns, partitionKeys, parquetPageSource.get(), path, fileSize, fileModifiedTime);
        Path updatedFileLocation = this.getPathForNewFile();
        try {
            this.updatedFileWriter = this.createWriter(updatedFileLocation, columnMetadata, this.allDataColumns);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, "Unable to create writer for location: " + updatedFileLocation, (Throwable)e);
        }
        OptionalInt rowIdColumnIndex = IntStream.range(0, queryColumns.size()).filter(columnIndex -> ((DeltaLakeColumnHandle)queryColumns.get(columnIndex)).getName().equals("$row_id")).findFirst();
        Preconditions.checkArgument((boolean)rowIdColumnIndex.isPresent(), (Object)"RowId column was not provided during delete operation");
        this.rowIdColumnIndex = rowIdColumnIndex.getAsInt();
        try {
            Path fsPath = new Path(path);
            ParquetFileReader parquetReader = ParquetFileReader.open((InputFile)HadoopInputFile.fromPath((Path)fsPath, (Configuration)hdfsEnvironment.getConfiguration(hdfsContext, fsPath)));
            Preconditions.checkArgument((parquetReader.getRecordCount() <= Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"Deletes from files with more than Integer.MAX_VALUE rows is not supported");
            this.totalRecordCount = Math.toIntExact(parquetReader.getRecordCount());
            this.rowsToDelete = new BitSet(this.totalRecordCount);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_DATA, "Unable to read parquet metadata for file: " + path, (Throwable)e);
        }
    }

    public long getCompletedBytes() {
        return this.pageSourceDelegate.getCompletedBytes();
    }

    public long getReadTimeNanos() {
        return this.pageSourceDelegate.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.pageSourceDelegate.isFinished();
    }

    public long getMemoryUsage() {
        return this.pageSourceDelegate.getMemoryUsage() + (long)(this.rowsToDelete.size() / 8);
    }

    public void close() {
        this.pageSourceDelegate.close();
    }

    public Page getNextPage() {
        Page basePage = this.pageSourceDelegate.getNextPage();
        if (basePage == null) {
            return null;
        }
        int writeColumnCount = this.queryColumns.size();
        Block[] blocks = new Block[writeColumnCount];
        int readIndex = 0;
        for (int writeIndex = 0; writeIndex < writeColumnCount; ++writeIndex) {
            if (writeIndex == this.rowIdColumnIndex) {
                blocks[writeIndex] = this.getRowIdBlock(basePage);
                continue;
            }
            int mappedReadChannel = this.queryColumnMapping.isEmpty() ? readIndex : this.queryColumnMapping.get()[readIndex];
            blocks[writeIndex] = basePage.getBlock(mappedReadChannel);
            ++readIndex;
        }
        return new Page(basePage.getPositionCount(), blocks);
    }

    private static DeltaLakeColumnHandle rowIndexColumn() {
        return new DeltaLakeColumnHandle("$delta$dummy_row_index", (Type)BigintType.BIGINT, DeltaLakeColumnType.SYNTHESIZED){

            @Override
            public HiveColumnHandle toHiveColumnHandle() {
                return ParquetPageSourceFactory.PARQUET_ROW_INDEX_COLUMN;
            }
        };
    }

    private Block getRowIdBlock(Page basePage) {
        switch (this.writeType) {
            case UPDATE: {
                return this.getUpdateRowIdBlock(basePage);
            }
            case DELETE: {
                return this.getRowIndexBlock(basePage);
            }
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unsupported write type: " + this.writeType);
    }

    private Block getUpdateRowIdBlock(Page basePage) {
        Block[] rowIdBlocks;
        int[] columnMapping = this.rowIdColumnMapping.orElseThrow();
        if (columnMapping.length > 0) {
            Block[] unmodifiedColumns = new Block[columnMapping.length];
            for (int channel = 0; channel < columnMapping.length; ++channel) {
                unmodifiedColumns[channel] = basePage.getBlock(columnMapping[channel]);
            }
            rowIdBlocks = new Block[]{this.getRowIndexBlock(basePage), RowBlock.fromFieldBlocks((int)basePage.getPositionCount(), Optional.empty(), (Block[])unmodifiedColumns)};
        } else {
            rowIdBlocks = new Block[]{this.getRowIndexBlock(basePage)};
        }
        return RowBlock.fromFieldBlocks((int)basePage.getPositionCount(), Optional.empty(), (Block[])rowIdBlocks);
    }

    private Block getRowIndexBlock(Page page) {
        return page.getBlock(page.getChannelCount() - 1);
    }

    public void deleteRows(Block rowIds) {
        for (int position = 0; position < rowIds.getPositionCount(); ++position) {
            long rowId = BigintType.BIGINT.getLong(rowIds, position);
            this.rowsToDelete.set(Math.toIntExact(rowId));
        }
    }

    public void updateRows(Page page, List<Integer> columnValueAndRowIdChannels) {
        int rowIdChannel = columnValueAndRowIdChannels.get(columnValueAndRowIdChannels.size() - 1);
        List<Integer> columnChannelMapping = columnValueAndRowIdChannels.subList(0, columnValueAndRowIdChannels.size() - 1);
        Block rowIdBlock = page.getBlock(rowIdChannel);
        for (int position = 0; position < rowIdBlock.getPositionCount(); ++position) {
            Block rowNumberBlock = (Block)rowIdBlock.getObject(position, Block.class);
            long rowId = rowNumberBlock.getLong(0, 0);
            this.rowsToDelete.set(Math.toIntExact(rowId));
        }
        int unmodifiedColumnIndex = 0;
        int updatedColumnIndex = 0;
        Block[] fullPage = new Block[this.allDataColumns.size()];
        for (int targetChannel = 0; targetChannel < this.allDataColumns.size(); ++targetChannel) {
            if (this.updatedColumns.contains(this.allDataColumns.get(targetChannel))) {
                fullPage[targetChannel] = page.getBlock(columnChannelMapping.get(updatedColumnIndex).intValue());
                ++updatedColumnIndex;
                continue;
            }
            Block unmodifiedColumns = (Block)rowIdBlock.getChildren().get(1);
            fullPage[targetChannel] = (Block)unmodifiedColumns.getChildren().get(unmodifiedColumnIndex);
            ++unmodifiedColumnIndex;
        }
        this.updatedFileWriter.appendRows(new Page(page.getPositionCount(), fullPage));
    }

    public CompletableFuture<Collection<Slice>> finish() {
        switch (this.writeType) {
            case UPDATE: {
                return this.finishUpdate();
            }
            case DELETE: {
                return this.finishDelete();
            }
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported write type: " + this.writeType);
    }

    private CompletableFuture<Collection<Slice>> finishUpdate() {
        if (this.rowsToDelete.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return CompletableFuture.supplyAsync(this::doFinishUpdate, this.executorService);
    }

    private Collection<Slice> doFinishUpdate() {
        String relativePath = new Path(this.tableHandle.getLocation()).toUri().relativize(new Path(this.path).toUri()).toString();
        try {
            int firstRetainedRow = this.rowsToDelete.nextClearBit(0);
            if (firstRetainedRow == -1 || firstRetainedRow >= this.totalRecordCount) {
                this.updatedFileWriter.commit();
                DataFileInfo newFileInfo = this.updatedFileWriter.getDataFileInfo();
                DeltaLakeUpdateResult deleteResult = new DeltaLakeUpdateResult(relativePath, Optional.of(newFileInfo));
                return ImmutableList.of((Object)Slices.utf8Slice((String)this.updateResultJsonCodec.toJson((Object)deleteResult)));
            }
            DataFileInfo newFileInfo = this.copyParquetPageSource(this.updatedFileWriter);
            DeltaLakeUpdateResult deleteResult = new DeltaLakeUpdateResult(relativePath, Optional.of(newFileInfo));
            return ImmutableList.of((Object)Slices.utf8Slice((String)this.updateResultJsonCodec.toJson((Object)deleteResult)));
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, "Unable to write new Parquet file for UPDATE operation", (Throwable)e);
        }
    }

    private CompletableFuture<Collection<Slice>> finishDelete() {
        if (this.rowsToDelete.isEmpty()) {
            return CompletableFuture.completedFuture(ImmutableList.of());
        }
        return CompletableFuture.supplyAsync(this::doFinishDelete, this.executorService);
    }

    private Collection<Slice> doFinishDelete() {
        try {
            String relativePath = new Path(this.tableHandle.getLocation()).toUri().relativize(new Path(this.path).toUri()).toString();
            int firstRetainedRow = this.rowsToDelete.nextClearBit(0);
            if (firstRetainedRow == -1 || firstRetainedRow >= this.totalRecordCount) {
                return ImmutableList.of((Object)Slices.utf8Slice((String)this.updateResultJsonCodec.toJson((Object)new DeltaLakeUpdateResult(relativePath, Optional.empty()))));
            }
            DataFileInfo newFileInfo = this.copyParquetPageSource(this.updatedFileWriter);
            DeltaLakeUpdateResult deleteResult = new DeltaLakeUpdateResult(relativePath, Optional.of(newFileInfo));
            return ImmutableList.of((Object)Slices.utf8Slice((String)this.updateResultJsonCodec.toJson((Object)deleteResult)));
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, "Unable to write new Parquet file for DELETE operation", (Throwable)e);
        }
    }

    private Path getPathForNewFile() {
        String targetFilename = this.session.getQueryId() + "_" + UUID.randomUUID();
        Path dataDirectory = new Path(this.path).getParent();
        return new Path(dataDirectory, targetFilename);
    }

    private DataFileInfo copyParquetPageSource(DeltaLakeWriter fileWriter) throws IOException {
        ReaderPageSource readerPageSource = this.createParquetPageSource((TupleDomain<HiveColumnHandle>)TupleDomain.all(), (List)this.allDataColumns.stream().map(DeltaLakeColumnHandle::toHiveColumnHandle).collect(ImmutableList.toImmutableList()));
        ConnectorPageSource connectorPageSource = readerPageSource.get();
        boolean successfulWrite = true;
        try {
            int pageStart = 0;
            while (!connectorPageSource.isFinished()) {
                Page page = connectorPageSource.getNextPage();
                if (page == null) continue;
                int pagePositionCount = page.getPositionCount();
                int nextToDelete = this.rowsToDelete.nextSetBit(pageStart);
                if (nextToDelete != -1 && nextToDelete < pageStart + pagePositionCount) {
                    int[] retainedPositions = new int[pagePositionCount];
                    int retainedPositionsCount = 0;
                    for (int position = 0; position < pagePositionCount; ++position) {
                        if (this.rowsToDelete.get(pageStart + position)) continue;
                        retainedPositions[retainedPositionsCount] = position;
                        ++retainedPositionsCount;
                    }
                    page = page.getPositions(retainedPositions, 0, retainedPositionsCount);
                }
                fileWriter.appendRows(page);
                pageStart += pagePositionCount;
            }
        }
        catch (Exception e) {
            block12: {
                successfulWrite = false;
                try {
                    fileWriter.rollback();
                }
                catch (Exception rollbackException) {
                    if (e == rollbackException) break block12;
                    e.addSuppressed(rollbackException);
                }
            }
            throw e;
        }
        finally {
            if (successfulWrite) {
                fileWriter.commit();
            }
            connectorPageSource.close();
        }
        return fileWriter.getDataFileInfo();
    }

    private ReaderPageSource createParquetPageSource(TupleDomain<HiveColumnHandle> parquetPredicate, List<HiveColumnHandle> columns) {
        return ParquetPageSourceFactory.createPageSource((Path)new Path(this.path), (long)0L, (long)this.fileSize, (long)this.fileSize, columns, parquetPredicate, (boolean)true, (HdfsEnvironment)this.hdfsEnvironment, (Configuration)this.hdfsEnvironment.getConfiguration(this.hdfsContext, new Path(this.path)), (ConnectorIdentity)this.session.getIdentity(), (DateTimeZone)this.parquetDateTimeZone, (FileFormatDataSourceStats)new FileFormatDataSourceStats(), (ParquetReaderOptions)this.parquetReaderOptions.withMaxReadBlockSize(DeltaLakeSessionProperties.getParquetMaxReadBlockSize(this.session)).withUseColumnIndex(DeltaLakeSessionProperties.isParquetUseColumnIndex(this.session)));
    }

    private DeltaLakeWriter createWriter(Path targetFile, List<ColumnMetadata> allColumns, List<DeltaLakeColumnHandle> dataColumns) throws IOException {
        Configuration conf = this.hdfsEnvironment.getConfiguration(new HdfsEnvironment.HdfsContext(this.session), targetFile);
        CompressionConfigUtil.configureCompression((Configuration)conf, (HiveCompressionCodec)HiveCompressionCodec.SNAPPY);
        Properties schema = DeltaLakePageSink.buildSchemaProperties((List)dataColumns.stream().map(DeltaLakeColumnHandle::getName).collect(ImmutableList.toImmutableList()), (List)dataColumns.stream().map(DeltaLakeColumnHandle::getType).collect(ImmutableList.toImmutableList()));
        RecordFileWriter recordFileWriter = new RecordFileWriter(targetFile, (List)dataColumns.stream().map(DeltaLakeColumnHandle::getName).collect(ImmutableList.toImmutableList()), StorageFormat.fromHiveStorageFormat((HiveStorageFormat)HiveStorageFormat.PARQUET), schema, HiveStorageFormat.PARQUET.getEstimatedWriterMemoryUsage(), ConfigurationUtils.toJobConf((Configuration)conf), this.typeManager, DateTimeZone.UTC, this.session);
        Path tablePath = new Path(this.tableHandle.getLocation());
        Path relativePath = new Path(tablePath.toUri().relativize(targetFile.toUri()));
        List<String> partitionValueList = this.getPartitionValues((List)allColumns.stream().filter(columnMetadata -> this.partitionKeys.containsKey(columnMetadata.getName())).collect(ImmutableList.toImmutableList()));
        return new DeltaLakeWriter(this.hdfsEnvironment.getFileSystem(this.hdfsContext, targetFile), (FileWriter)recordFileWriter, tablePath, relativePath.toString(), partitionValueList, new DeltaLakeWriterStats(), dataColumns);
    }

    private List<String> getPartitionValues(List<ColumnMetadata> partitionColumns) {
        Block[] partitionValues = new Block[partitionColumns.size()];
        for (int i = 0; i < partitionValues.length; ++i) {
            ColumnMetadata columnMetadata = partitionColumns.get(i);
            partitionValues[i] = Utils.nativeValueToBlock((Type)columnMetadata.getType(), (Object)TransactionLogParser.deserializePartitionValue(new DeltaLakeColumnHandle(columnMetadata.getName(), columnMetadata.getType(), DeltaLakeColumnType.PARTITION_KEY), this.partitionKeys.get(columnMetadata.getName())));
        }
        return DeltaLakePageSink.createPartitionValues((List)partitionColumns.stream().map(ColumnMetadata::getType).collect(ImmutableList.toImmutableList()), new Page(1, partitionValues), 0);
    }

    public void abort() {
        this.pageSourceDelegate.close();
    }
}

