/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.metastore;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnType;
import io.trino.plugin.deltalake.DeltaLakeErrorCode;
import io.trino.plugin.deltalake.DeltaLakeMetadata;
import io.trino.plugin.deltalake.DeltaLakeSessionProperties;
import io.trino.plugin.deltalake.DeltaLakeSplitManager;
import io.trino.plugin.deltalake.DeltaLakeTableHandle;
import io.trino.plugin.deltalake.metastore.DeltaLakeMetastore;
import io.trino.plugin.deltalake.metastore.NotADeltaLakeTableException;
import io.trino.plugin.deltalake.statistics.CachingDeltaLakeStatisticsAccess;
import io.trino.plugin.deltalake.statistics.DeltaLakeColumnStatistics;
import io.trino.plugin.deltalake.statistics.DeltaLakeStatistics;
import io.trino.plugin.deltalake.transactionlog.AddFileEntry;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeSchemaSupport;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.deltalake.transactionlog.ProtocolEntry;
import io.trino.plugin.deltalake.transactionlog.TableSnapshot;
import io.trino.plugin.deltalake.transactionlog.TransactionLogAccess;
import io.trino.plugin.deltalake.transactionlog.statistics.DeltaLakeFileStatistics;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.PrincipalPrivileges;
import io.trino.plugin.hive.metastore.Table;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.statistics.ColumnStatistics;
import io.trino.spi.statistics.DoubleRange;
import io.trino.spi.statistics.Estimate;
import io.trino.spi.statistics.StatsUtil;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import org.apache.hadoop.fs.Path;

public class HiveMetastoreBackedDeltaLakeMetastore
implements DeltaLakeMetastore {
    public static final String TABLE_PROVIDER_PROPERTY = "spark.sql.sources.provider";
    public static final String TABLE_PROVIDER_VALUE = "DELTA";
    private final HiveMetastore delegate;
    private final TransactionLogAccess transactionLogAccess;
    private final TypeManager typeManager;
    private final CachingDeltaLakeStatisticsAccess statisticsAccess;

    public HiveMetastoreBackedDeltaLakeMetastore(HiveMetastore delegate, TransactionLogAccess transactionLogAccess, TypeManager typeManager, CachingDeltaLakeStatisticsAccess statisticsAccess) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.transactionLogAccess = Objects.requireNonNull(transactionLogAccess, "transactionLogSupport is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.statisticsAccess = Objects.requireNonNull(statisticsAccess, "statisticsAccess is null");
    }

    @Override
    public List<String> getAllDatabases() {
        return this.delegate.getAllDatabases();
    }

    @Override
    public Optional<Database> getDatabase(String databaseName) {
        return this.delegate.getDatabase(databaseName);
    }

    @Override
    public List<String> getAllTables(String databaseName) {
        return this.delegate.getAllTables(databaseName);
    }

    @Override
    public Optional<Table> getTable(String databaseName, String tableName) {
        Optional candidate = this.delegate.getTable(databaseName, tableName);
        candidate.ifPresent(table -> {
            if (!TABLE_PROVIDER_VALUE.equalsIgnoreCase((String)table.getParameters().get(TABLE_PROVIDER_PROPERTY))) {
                throw new NotADeltaLakeTableException(databaseName, tableName);
            }
        });
        return candidate;
    }

    @Override
    public void createDatabase(Database database) {
        this.delegate.createDatabase(database);
    }

    @Override
    public void dropDatabase(String databaseName, boolean deleteData) {
        this.delegate.dropDatabase(databaseName, deleteData);
    }

    @Override
    public void createTable(ConnectorSession session, Table table, PrincipalPrivileges principalPrivileges) {
        String tableLocation = table.getStorage().getLocation();
        this.statisticsAccess.invalidateCache(tableLocation);
        this.transactionLogAccess.invalidateCaches(tableLocation);
        try {
            TableSnapshot tableSnapshot = this.transactionLogAccess.loadSnapshot(table.getSchemaTableName(), new Path(tableLocation), session);
            Optional<MetadataEntry> maybeMetadata = this.transactionLogAccess.getMetadataEntry(tableSnapshot, session);
            if (maybeMetadata.isEmpty()) {
                throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_TABLE, "Provided location did not contain a valid Delta Lake table: " + tableLocation);
            }
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_TABLE, "Failed to access table location: " + tableLocation, (Throwable)e);
        }
        this.delegate.createTable(table, principalPrivileges);
    }

    @Override
    public void dropTable(ConnectorSession session, String databaseName, String tableName) {
        String tableLocation = this.getTableLocation(new SchemaTableName(databaseName, tableName), session);
        this.delegate.dropTable(databaseName, tableName, true);
        this.statisticsAccess.invalidateCache(tableLocation);
        this.transactionLogAccess.invalidateCaches(tableLocation);
    }

    @Override
    public Optional<MetadataEntry> getMetadata(TableSnapshot tableSnapshot, ConnectorSession session) {
        return this.transactionLogAccess.getMetadataEntry(tableSnapshot, session);
    }

    @Override
    public ProtocolEntry getProtocol(ConnectorSession session, TableSnapshot tableSnapshot) {
        return this.transactionLogAccess.getProtocolEntries(tableSnapshot, session).reduce((first, second) -> second).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, "Protocol entry not found in transaction log for table " + tableSnapshot.getTable()));
    }

    @Override
    public String getTableLocation(SchemaTableName table, ConnectorSession session) {
        Map serdeParameters = this.getTable(table.getSchemaName(), table.getTableName()).orElseThrow(() -> new TableNotFoundException(table)).getStorage().getSerdeParameters();
        String location = (String)serdeParameters.get("path");
        if (location == null) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, String.format("No %s property defined for table: %s", "path", table));
        }
        return location;
    }

    @Override
    public TableSnapshot getSnapshot(SchemaTableName table, ConnectorSession session) {
        try {
            return this.transactionLogAccess.loadSnapshot(table, new Path(this.getTableLocation(table, session)), session);
        }
        catch (NotADeltaLakeTableException e) {
            throw e;
        }
        catch (IOException | RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, "Error getting snapshot for " + table, (Throwable)e);
        }
    }

    @Override
    public List<AddFileEntry> getValidDataFiles(SchemaTableName table, ConnectorSession session) {
        return this.transactionLogAccess.getActiveFiles(this.getSnapshot(table, session), session);
    }

    @Override
    public TableStatistics getTableStatistics(ConnectorSession session, DeltaLakeTableHandle tableHandle, Constraint constraint) {
        TableSnapshot tableSnapshot = this.getSnapshot(tableHandle.getSchemaTableName(), session);
        double numRecords = 0.0;
        MetadataEntry metadata = this.transactionLogAccess.getMetadataEntry(tableSnapshot, session).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, "Metadata not found in transaction log for " + tableHandle.getTableName()));
        List<ColumnMetadata> columnMetadata = DeltaLakeSchemaSupport.extractSchema(metadata, this.typeManager);
        List columns = (List)columnMetadata.stream().map(columnMeta -> new DeltaLakeColumnHandle(columnMeta.getName(), columnMeta.getType(), metadata.getCanonicalPartitionColumns().contains(columnMeta.getName()) ? DeltaLakeColumnType.PARTITION_KEY : DeltaLakeColumnType.REGULAR)).collect(ImmutableList.toImmutableList());
        HashMap<DeltaLakeColumnHandle, Double> nullCounts = new HashMap<DeltaLakeColumnHandle, Double>();
        columns.forEach(column -> nullCounts.put((DeltaLakeColumnHandle)column, 0.0));
        HashMap minValues = new HashMap();
        HashMap maxValues = new HashMap();
        HashMap partitioningColumnsDistinctValues = new HashMap();
        columns.stream().filter(column -> column.getColumnType() == DeltaLakeColumnType.PARTITION_KEY).forEach(column -> partitioningColumnsDistinctValues.put(column, new HashSet()));
        if (tableHandle.getEnforcedPartitionConstraint().isNone() || tableHandle.getNonPartitionConstraint().isNone() || constraint.getSummary().isNone()) {
            return this.createZeroStatistics(columns);
        }
        Set predicatedColumnNames = (Set)((Map)tableHandle.getNonPartitionConstraint().getDomains().orElseThrow()).keySet().stream().map(DeltaLakeColumnHandle::getName).collect(ImmutableSet.toImmutableSet());
        List predicatedColumns = (List)columnMetadata.stream().filter(column -> predicatedColumnNames.contains(column.getName())).collect(ImmutableList.toImmutableList());
        for (AddFileEntry addEntry : this.transactionLogAccess.getActiveFiles(tableSnapshot, session)) {
            Optional<? extends DeltaLakeFileStatistics> fileStatistics = addEntry.getStats();
            if (fileStatistics.isEmpty()) {
                return TableStatistics.empty();
            }
            DeltaLakeFileStatistics stats = fileStatistics.get();
            if (!DeltaLakeSplitManager.partitionMatchesPredicate(addEntry.getCanonicalPartitionValues(), (Map)tableHandle.getEnforcedPartitionConstraint().getDomains().orElseThrow())) continue;
            TupleDomain<DeltaLakeColumnHandle> statisticsPredicate = DeltaLakeMetadata.createStatisticsPredicate(addEntry, predicatedColumns, tableHandle.getMetadataEntry().getCanonicalPartitionColumns());
            if (!tableHandle.getNonPartitionConstraint().overlaps(statisticsPredicate)) continue;
            if (stats.getNumRecords().isEmpty()) {
                return TableStatistics.empty();
            }
            numRecords += (double)stats.getNumRecords().get().longValue();
            for (DeltaLakeColumnHandle column2 : columns) {
                if (column2.getColumnType() == DeltaLakeColumnType.PARTITION_KEY) {
                    Optional<String> partitionValue = addEntry.getCanonicalPartitionValues().get(column2.getName());
                    if (partitionValue.isEmpty()) {
                        nullCounts.merge(column2, Double.valueOf(stats.getNumRecords().get().longValue()), Double::sum);
                    } else {
                        ((Set)partitioningColumnsDistinctValues.get(column2)).add(partitionValue.get());
                    }
                } else {
                    Optional<Long> maybeNullCount = stats.getNullCount(column2.getName());
                    if (maybeNullCount.isPresent()) {
                        nullCounts.put(column2, (Double)nullCounts.get(column2) + (double)maybeNullCount.get().longValue());
                    } else {
                        nullCounts.put(column2, Double.NaN);
                    }
                }
                stats.getMinColumnValue(column2).map(parsedValue -> StatsUtil.toStatsRepresentation((Type)column2.getType(), (Object)parsedValue)).filter(OptionalDouble::isPresent).map(OptionalDouble::getAsDouble).ifPresent(parsedValueAsDouble -> minValues.merge(column2, parsedValueAsDouble, Math::min));
                stats.getMaxColumnValue(column2).map(parsedValue -> StatsUtil.toStatsRepresentation((Type)column2.getType(), (Object)parsedValue)).filter(OptionalDouble::isPresent).map(OptionalDouble::getAsDouble).ifPresent(parsedValueAsDouble -> maxValues.merge(column2, parsedValueAsDouble, Math::max));
            }
        }
        if (numRecords == 0.0) {
            return this.createZeroStatistics(columns);
        }
        TableStatistics.Builder statsBuilder = new TableStatistics.Builder().setRowCount(Estimate.of((double)numRecords));
        Optional<Object> statistics = Optional.empty();
        if (DeltaLakeSessionProperties.isExtendedStatisticsEnabled(session)) {
            statistics = this.statisticsAccess.readDeltaLakeStatistics(session, tableHandle.getLocation());
        }
        for (DeltaLakeColumnHandle column3 : columns) {
            DeltaLakeColumnStatistics deltaLakeColumnStatistics;
            ColumnStatistics.Builder columnStatsBuilder = new ColumnStatistics.Builder();
            Double nullCount = (Double)nullCounts.get(column3);
            columnStatsBuilder.setNullsFraction(nullCount.isNaN() ? Estimate.unknown() : Estimate.of((double)(nullCount / numRecords)));
            Double maxValue = (Double)maxValues.get(column3);
            Double minValue = (Double)minValues.get(column3);
            if (this.isValidInRange(maxValue) && this.isValidInRange(minValue)) {
                columnStatsBuilder.setRange(new DoubleRange(minValue.doubleValue(), maxValue.doubleValue()));
            } else if (this.isValidInRange(maxValue)) {
                columnStatsBuilder.setRange(new DoubleRange(Double.NEGATIVE_INFINITY, maxValue.doubleValue()));
            } else if (this.isValidInRange(minValue)) {
                columnStatsBuilder.setRange(new DoubleRange(minValue.doubleValue(), Double.POSITIVE_INFINITY));
            }
            if (column3.getColumnType() == DeltaLakeColumnType.PARTITION_KEY) {
                columnStatsBuilder.setDistinctValuesCount(Estimate.of((double)((Set)partitioningColumnsDistinctValues.get(column3)).size()));
            }
            if (statistics.isPresent() && (deltaLakeColumnStatistics = ((DeltaLakeStatistics)statistics.get()).getColumnStatistics().get(column3.getName())) != null && column3.getColumnType() != DeltaLakeColumnType.PARTITION_KEY) {
                columnStatsBuilder.setDistinctValuesCount(Estimate.of((double)deltaLakeColumnStatistics.getNdvSummary().cardinality()));
            }
            statsBuilder.setColumnStatistics((ColumnHandle)column3, columnStatsBuilder.build());
        }
        return statsBuilder.build();
    }

    private TableStatistics createZeroStatistics(List<DeltaLakeColumnHandle> columns) {
        TableStatistics.Builder statsBuilder = new TableStatistics.Builder().setRowCount(Estimate.of((double)0.0));
        for (DeltaLakeColumnHandle column : columns) {
            ColumnStatistics.Builder columnStatistics = ColumnStatistics.builder();
            columnStatistics.setNullsFraction(Estimate.of((double)0.0));
            columnStatistics.setDistinctValuesCount(Estimate.of((double)0.0));
            statsBuilder.setColumnStatistics((ColumnHandle)column, columnStatistics.build());
        }
        return statsBuilder.build();
    }

    private boolean isValidInRange(Double d) {
        return d != null && !d.isNaN();
    }

    @Override
    public HiveMetastore getHiveMetastore() {
        return this.delegate;
    }
}

