/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.procedure;

import io.trino.plugin.deltalake.DeltaLakeMetadata;
import io.trino.plugin.deltalake.DeltaLakeMetadataFactory;
import io.trino.plugin.deltalake.procedure.Procedures;
import io.trino.plugin.deltalake.statistics.DeltaLakeStatisticsAccess;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.MethodHandleUtil;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;

public class DropExtendedStatsProcedure
implements Provider<Procedure> {
    private static final MethodHandle PROCEDURE_METHOD = MethodHandleUtil.methodHandle(DropExtendedStatsProcedure.class, (String)"dropStats", (Class[])new Class[]{ConnectorSession.class, String.class, String.class});
    private final DeltaLakeMetadataFactory metadataFactory;
    private final DeltaLakeStatisticsAccess statsAccess;

    @Inject
    public DropExtendedStatsProcedure(DeltaLakeMetadataFactory metadataFactory, DeltaLakeStatisticsAccess statsAccess) {
        this.metadataFactory = Objects.requireNonNull(metadataFactory, "metadataFactory");
        this.statsAccess = Objects.requireNonNull(statsAccess, "statsAccess");
    }

    public Procedure get() {
        return new Procedure("system", "drop_extended_stats", List.of(new Procedure.Argument("SCHEMA_NAME", (Type)VarcharType.VARCHAR), new Procedure.Argument("TABLE_NAME", (Type)VarcharType.VARCHAR)), PROCEDURE_METHOD.bindTo(this));
    }

    public void dropStats(ConnectorSession session, String schema, String table) {
        Procedures.checkProcedureArgument(schema != null, "schema_name cannot be null", new Object[0]);
        Procedures.checkProcedureArgument(table != null, "table_name cannot be null", new Object[0]);
        SchemaTableName name = new SchemaTableName(schema, table);
        DeltaLakeMetadata metadata = this.metadataFactory.create(session.getIdentity());
        if (metadata.getTableHandle(session, name) == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, String.format("Table '%s' does not exist", name));
        }
        this.statsAccess.deleteDeltaLakeStatistics(session, metadata.getMetastore().getTableLocation(name, session));
    }
}

